/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.security.Key;
import org.alfresco.encryption.AbstractKeyProvider;
import org.alfresco.encryption.AlfrescoKeyStore;
import org.alfresco.encryption.AlfrescoKeyStoreImpl;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeystoreKeyProvider
extends AbstractKeyProvider {
    private static final Log logger = LogFactory.getLog(KeystoreKeyProvider.class);
    private AlfrescoKeyStore keyStore;
    private boolean useBackupKeys = false;

    public KeystoreKeyProvider() {
    }

    public KeystoreKeyProvider(KeyStoreParameters keyStoreParameters, KeyResourceLoader keyResourceLoader) {
        this();
        this.keyStore = new AlfrescoKeyStoreImpl(keyStoreParameters, keyResourceLoader);
        this.init();
    }

    public void setUseBackupKeys(boolean useBackupKeys) {
        this.useBackupKeys = useBackupKeys;
    }

    public KeystoreKeyProvider(AlfrescoKeyStore keyStore) {
        this();
        this.keyStore = keyStore;
        this.init();
    }

    public void setKeyStore(AlfrescoKeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void init() {
    }

    @Override
    public Key getKey(String keyAlias) {
        if (this.useBackupKeys) {
            return this.keyStore.getBackupKey(keyAlias);
        }
        return this.keyStore.getKey(keyAlias);
    }
}

