/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.query.AbstractCannedQuery;
import org.alfresco.query.AbstractCannedQueryFactory;
import org.alfresco.query.CannedQuery;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryPageDetails;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.util.Pair;
import org.alfresco.util.registry.NamedObjectRegistry;

public class CannedQueryTest
extends TestCase {
    private static final String QUERY_TEST_ONE = "test.query.one";
    private static final String QUERY_TEST_TWO = "test.query.two";
    private static final List<String> RESULTS_ONE;
    private static final List<Long> RESULTS_TWO;
    private static final Set<Object> ANTI_RESULTS;
    private NamedObjectRegistry<CannedQueryFactory> namedQueryFactoryRegistry;

    public void setUp() throws Exception {
        this.namedQueryFactoryRegistry = new NamedObjectRegistry();
        this.namedQueryFactoryRegistry.setStorageType(CannedQueryFactory.class);
        this.namedQueryFactoryRegistry.setNamePattern("test\\.query\\..*");
        TestCannedQueryFactory namedQueryFactoryOne = new TestCannedQueryFactory(RESULTS_ONE);
        namedQueryFactoryOne.setBeanName(QUERY_TEST_ONE);
        namedQueryFactoryOne.setRegistry(this.namedQueryFactoryRegistry);
        namedQueryFactoryOne.afterPropertiesSet();
        TestCannedQueryFactory namedQueryFactoryTwo = new TestCannedQueryFactory(RESULTS_TWO);
        namedQueryFactoryTwo.setBeanName(QUERY_TEST_TWO);
        namedQueryFactoryTwo.setRegistry(this.namedQueryFactoryRegistry);
        namedQueryFactoryTwo.afterPropertiesSet();
    }

    public void testRegistry() throws Exception {
        CannedQueryFactory one = this.namedQueryFactoryRegistry.getNamedObject(QUERY_TEST_ONE);
        CannedQueryTest.assertNotNull((String)"No factory for test.query.one", (Object)one);
        CannedQueryFactory two = this.namedQueryFactoryRegistry.getNamedObject(QUERY_TEST_TWO);
        CannedQueryTest.assertNotNull((String)"No factory for test.query.two", (Object)two);
        try {
            TestCannedQueryFactory namedQueryFactoryBogus = new TestCannedQueryFactory(RESULTS_TWO);
            namedQueryFactoryBogus.setBeanName("test_query_blah");
            namedQueryFactoryBogus.setRegistry(this.namedQueryFactoryRegistry);
            namedQueryFactoryBogus.afterPropertiesSet();
            CannedQueryTest.fail((String)"Should have kicked out incorrectly-named registered queries");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testQueryAllResults() throws Exception {
        CannedQueryFactory qfOne = this.namedQueryFactoryRegistry.getNamedObject(QUERY_TEST_ONE);
        CannedQueryParameters params = new CannedQueryParameters(null);
        CannedQuery qOne = qfOne.getCannedQuery(params);
        CannedQueryResults qrOne = qOne.execute();
        try {
            qOne.execute();
            CannedQueryTest.fail((String)"Second execution of same instance must not be allowed.");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            qrOne.getTotalResultCount();
            CannedQueryTest.fail((String)"Expected failure when requesting total count without explicit request.");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        int pagedResultCount = qrOne.getPagedResultCount();
        CannedQueryTest.assertEquals((String)"Incorrect number of results", (int)9, (int)pagedResultCount);
        CannedQueryTest.assertEquals((String)"No sorting was specified in the parameters", (String)"ONE_0", (String)((String)qrOne.getPages().get(0).get(0)));
        CannedQueryTest.assertFalse((String)"Should NOT have any more pages/items", (boolean)qrOne.hasMoreItems());
    }

    public void testQueryMaxResults() throws Exception {
        CannedQueryFactory qfOne = this.namedQueryFactoryRegistry.getNamedObject(QUERY_TEST_ONE);
        CannedQuery qOne = qfOne.getCannedQuery(null, 0, 9, null);
        CannedQueryResults qrOne = qOne.execute();
        int pagedResultCount = qrOne.getPagedResultCount();
        CannedQueryTest.assertEquals((String)"Incorrect number of results", (int)9, (int)pagedResultCount);
        CannedQueryTest.assertEquals((String)"Incorrect number of pages", (int)1, (int)qrOne.getPageCount());
        List pages = qrOne.getPages();
        CannedQueryTest.assertEquals((String)"Incorrect number of pages", (int)1, (int)pages.size());
        CannedQueryTest.assertEquals((String)"No sorting was specified in the parameters", (String)"ONE_0", (String)((String)qrOne.getPages().get(0).get(0)));
        CannedQueryTest.assertEquals((String)"No sorting was specified in the parameters", (String)"ONE_9", (String)((String)qrOne.getPages().get(0).get(8)));
        CannedQueryTest.assertFalse((String)"Should have more pages/items", (boolean)qrOne.hasMoreItems());
    }

    public void testQueryPagedResults() throws Exception {
        CannedQueryFactory qfOne = this.namedQueryFactoryRegistry.getNamedObject(QUERY_TEST_ONE);
        CannedQueryPageDetails qPageDetails = new CannedQueryPageDetails(0, 5, 1, 2);
        CannedQueryParameters params = new CannedQueryParameters(null, qPageDetails, null);
        CannedQuery qOne = qfOne.getCannedQuery(params);
        CannedQueryResults qrOne = qOne.execute();
        CannedQueryTest.assertEquals((String)"Incorrect number of results", (int)9, (int)qrOne.getPagedResultCount());
        CannedQueryTest.assertEquals((String)"No sorting was specified in the parameters", (String)"ONE_0", (String)((String)qrOne.getPages().get(0).get(0)));
        CannedQueryTest.assertEquals((String)"No sorting was specified in the parameters", (String)"ONE_9", (String)((String)qrOne.getPages().get(1).get(3)));
        List pages = qrOne.getPages();
        CannedQueryTest.assertEquals((String)"Incorrect number of pages", (int)2, (int)pages.size());
        CannedQueryTest.assertEquals((String)"Incorrect results on page", (int)5, (int)pages.get(0).size());
        CannedQueryTest.assertEquals((String)"Incorrect results on page", (int)4, (int)pages.get(1).size());
        CannedQueryTest.assertFalse((String)"Should NOT have any more pages/items", (boolean)qrOne.hasMoreItems());
        qPageDetails = new CannedQueryPageDetails(2, 3, 1, 3);
        params = new CannedQueryParameters(null, qPageDetails, null);
        qOne = qfOne.getCannedQuery(params);
        qrOne = qOne.execute();
        CannedQueryTest.assertEquals((String)"Incorrect number of results", (int)7, (int)qrOne.getPagedResultCount());
        CannedQueryTest.assertEquals((String)"Incorrect number of pages", (int)3, (int)qrOne.getPageCount());
        pages = qrOne.getPages();
        CannedQueryTest.assertEquals((String)"Incorrect number of pages", (int)3, (int)pages.size());
        CannedQueryTest.assertEquals((String)"Incorrect results on page", (int)3, (int)pages.get(0).size());
        CannedQueryTest.assertEquals((String)"Incorrect results on page", (int)3, (int)pages.get(1).size());
        CannedQueryTest.assertEquals((String)"Incorrect results on page", (int)1, (int)pages.get(2).size());
        CannedQueryTest.assertFalse((String)"Should NOT have any more pages/items", (boolean)qrOne.hasMoreItems());
        qPageDetails = new CannedQueryPageDetails(2, 3, 1, 2);
        params = new CannedQueryParameters(null, qPageDetails, null);
        qOne = qfOne.getCannedQuery(params);
        qrOne = qOne.execute();
        CannedQueryTest.assertEquals((String)"Incorrect number of results", (int)6, (int)qrOne.getPagedResultCount());
        CannedQueryTest.assertEquals((String)"Incorrect number of pages", (int)2, (int)qrOne.getPageCount());
        pages = qrOne.getPages();
        CannedQueryTest.assertEquals((String)"Incorrect number of pages", (int)2, (int)pages.size());
        CannedQueryTest.assertEquals((String)"Incorrect results on page", (int)3, (int)pages.get(0).size());
        CannedQueryTest.assertEquals((String)"Incorrect results on page", (int)3, (int)pages.get(1).size());
        CannedQueryTest.assertTrue((String)"Should have more pages/items", (boolean)qrOne.hasMoreItems());
    }

    public void testQuerySortedResults() throws Exception {
        CannedQueryFactory qfOne = this.namedQueryFactoryRegistry.getNamedObject(QUERY_TEST_ONE);
        CannedQuerySortDetails qSortDetails = new CannedQuerySortDetails(new Pair<String, CannedQuerySortDetails.SortOrder>("blah", CannedQuerySortDetails.SortOrder.DESCENDING));
        CannedQueryParameters params = new CannedQueryParameters(null, null, qSortDetails);
        CannedQuery qOne = qfOne.getCannedQuery(params);
        CannedQueryResults qrOne = qOne.execute();
        CannedQueryTest.assertEquals((String)"Incorrect number of results", (int)9, (int)qrOne.getPagedResultCount());
        CannedQueryTest.assertEquals((String)"Expected inverse sorting", (String)"ONE_9", (String)((String)qrOne.getPages().get(0).get(0)));
        CannedQueryTest.assertEquals((String)"Expected inverse sorting", (String)"ONE_0", (String)((String)qrOne.getPages().get(0).get(8)));
        CannedQueryTest.assertFalse((String)"Should NOT have any more pages/items", (boolean)qrOne.hasMoreItems());
    }

    public void testQueryPermissionCheckedResults() throws Exception {
        CannedQueryFactory qfOne = this.namedQueryFactoryRegistry.getNamedObject(QUERY_TEST_ONE);
        CannedQueryParameters params = new CannedQueryParameters(null, null, null, 0, null);
        CannedQuery qOne = qfOne.getCannedQuery(params);
        CannedQueryResults qrOne = qOne.execute();
        CannedQueryTest.assertEquals((String)"Incorrect number of results", (int)9, (int)qrOne.getPagedResultCount());
        CannedQueryTest.assertEquals((String)"Incorrect result order", (String)"ONE_0", (String)((String)qrOne.getPages().get(0).get(0)));
        CannedQueryTest.assertEquals((String)"Incorrect result order", (String)"ONE_1", (String)((String)qrOne.getPages().get(0).get(1)));
        CannedQueryTest.assertEquals((String)"Incorrect result order", (String)"ONE_2", (String)((String)qrOne.getPages().get(0).get(2)));
        CannedQueryTest.assertEquals((String)"Incorrect result order", (String)"ONE_3", (String)((String)qrOne.getPages().get(0).get(3)));
        CannedQueryTest.assertEquals((String)"Incorrect result order", (String)"ONE_4", (String)((String)qrOne.getPages().get(0).get(4)));
        CannedQueryTest.assertEquals((String)"Incorrect result order", (String)"ONE_6", (String)((String)qrOne.getPages().get(0).get(5)));
        CannedQueryTest.assertEquals((String)"Incorrect result order", (String)"ONE_7", (String)((String)qrOne.getPages().get(0).get(6)));
        CannedQueryTest.assertEquals((String)"Incorrect result order", (String)"ONE_8", (String)((String)qrOne.getPages().get(0).get(7)));
        CannedQueryTest.assertEquals((String)"Incorrect result order", (String)"ONE_9", (String)((String)qrOne.getPages().get(0).get(8)));
        CannedQueryTest.assertFalse((String)"Should NOT have any more pages/items", (boolean)qrOne.hasMoreItems());
    }

    public void testQueryPermissionCheckedPagedTotalCount() throws Exception {
        CannedQueryFactory qfOne = this.namedQueryFactoryRegistry.getNamedObject(QUERY_TEST_ONE);
        CannedQueryPageDetails qPageDetails = new CannedQueryPageDetails(5, 1, 1, 1);
        CannedQuerySortDetails qSortDetails = new CannedQuerySortDetails(new Pair<String, CannedQuerySortDetails.SortOrder>("blah", CannedQuerySortDetails.SortOrder.DESCENDING));
        CannedQueryParameters params = new CannedQueryParameters(null, qPageDetails, qSortDetails, 1000, null);
        CannedQuery qOne = qfOne.getCannedQuery(params);
        CannedQueryResults qrOne = qOne.execute();
        CannedQueryTest.assertEquals((String)"Incorrect number of total results", new Pair<Integer, Integer>(9, 9), qrOne.getTotalResultCount());
        CannedQueryTest.assertEquals((String)"Incorrect number of paged results", (int)1, (int)qrOne.getPagedResultCount());
        CannedQueryTest.assertEquals((String)"Incorrect result order", (String)"ONE_3", (String)((String)qrOne.getPages().get(0).get(0)));
        CannedQueryTest.assertTrue((String)"Should have more pages/items", (boolean)qrOne.hasMoreItems());
    }

    static {
        int i;
        RESULTS_ONE = new ArrayList<String>(10);
        for (i = 0; i < 10; ++i) {
            RESULTS_ONE.add("ONE_" + i);
        }
        RESULTS_TWO = new ArrayList<Long>(10);
        for (i = 0; i < 10; ++i) {
            RESULTS_TWO.add(new Long(i));
        }
        ANTI_RESULTS = new HashSet<Object>();
        ANTI_RESULTS.add("ONE_5");
        ANTI_RESULTS.add(new Long(5L));
    }

    private static class TestCannedQuery<T>
    extends AbstractCannedQuery<T> {
        private final List<T> results;
        private final Set<Object> antiResults;

        private TestCannedQuery(CannedQueryParameters params, String queryExecutionId, List<T> results, Set<Object> antiResults) {
            super(params);
            this.results = results;
            this.antiResults = antiResults;
        }

        @Override
        protected List<T> queryAndFilter(CannedQueryParameters parameters) {
            return this.results;
        }

        @Override
        protected boolean isApplyPostQuerySorting() {
            return true;
        }

        @Override
        protected List<T> applyPostQuerySorting(List<T> results, CannedQuerySortDetails sortDetails) {
            if (sortDetails.getSortPairs().size() == 0) {
                return results;
            }
            ArrayList<T> ret = new ArrayList<T>(results);
            Collections.reverse(ret);
            return ret;
        }

        @Override
        protected boolean isApplyPostQueryPermissions() {
            return true;
        }

        @Override
        protected List<T> applyPostQueryPermissions(List<T> results, int requestedCount) {
            boolean cutoffAllowed = this.getParameters().getTotalResultCountMax() == 0;
            ArrayList<T> ret = new ArrayList<T>(results.size());
            for (T t : results) {
                if (!this.antiResults.contains(t)) {
                    ret.add(t);
                }
                if (!cutoffAllowed || ret.size() != requestedCount) continue;
                break;
            }
            return ret;
        }
    }

    private static class TestCannedQueryFactory<T>
    extends AbstractCannedQueryFactory<T> {
        private final List<T> results;

        private TestCannedQueryFactory(List<T> results) {
            this.results = results;
        }

        @Override
        public CannedQuery<T> getCannedQuery(CannedQueryParameters parameters) {
            String queryExecutionId = super.getQueryExecutionId(parameters);
            return new TestCannedQuery(parameters, queryExecutionId, this.results, ANTI_RESULTS);
        }
    }
}

