/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.query;

import java.util.Collections;
import java.util.List;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.util.Pair;

public class ListBackedPagingResults<R>
implements PagingResults<R> {
    private List<R> results;
    private int size;
    private boolean hasMore;

    public ListBackedPagingResults(List<R> list) {
        this.results = Collections.unmodifiableList(list);
        this.size = list.size();
        this.hasMore = false;
    }

    public ListBackedPagingResults(List<R> list, PagingRequest paging) {
        int start = paging.getSkipCount();
        int end = Math.min(list.size(), start + paging.getMaxItems());
        if (paging.getMaxItems() == 0) {
            end = list.size();
        }
        this.results = Collections.unmodifiableList(list.subList(start, end));
        this.size = list.size();
        this.hasMore = list.size() != end;
    }

    @Override
    public List<R> getPage() {
        return this.results;
    }

    @Override
    public boolean hasMoreItems() {
        return this.hasMore;
    }

    @Override
    public Pair<Integer, Integer> getTotalResultCount() {
        return new Pair<Integer, Integer>(this.size, this.size);
    }

    @Override
    public String getQueryExecutionId() {
        return null;
    }
}

