/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.springframework.extensions.config.ConfigSource;
import org.springframework.extensions.config.source.FileConfigSource;
import org.springframework.extensions.config.xml.XMLConfigService;

public abstract class BaseTest
extends TestCase {
    private String resourcesDir;

    public BaseTest() {
        String resourcesDir = System.getProperty("alfresco.test.resources.dir");
        if (resourcesDir == null || resourcesDir.equals("")) {
            resourcesDir = System.getProperty("user.dir") + File.separator + "source" + File.separator + "test-resources";
        }
        this.resourcesDir = resourcesDir + File.separator;
    }

    public String getResourcesDir() {
        return this.resourcesDir;
    }

    protected void assertFileIsValid(String fullFileName) {
        File f = new File(fullFileName);
        BaseTest.assertTrue((String)("Required file missing: " + fullFileName), (boolean)f.exists());
        BaseTest.assertTrue((String)("Required file not readable: " + fullFileName), (boolean)f.canRead());
    }

    protected XMLConfigService initXMLConfigService(String xmlConfigFile) {
        String fullFileName = this.getResourcesDir() + xmlConfigFile;
        this.assertFileIsValid(fullFileName);
        XMLConfigService svc = new XMLConfigService((ConfigSource)new FileConfigSource(fullFileName));
        svc.initConfig();
        return svc;
    }

    protected XMLConfigService initXMLConfigService(String xmlConfigFile, String overridingXmlConfigFile) {
        ArrayList<String> files = new ArrayList<String>(2);
        files.add(xmlConfigFile);
        files.add(overridingXmlConfigFile);
        return this.initXMLConfigService(files);
    }

    protected XMLConfigService initXMLConfigService(List<String> xmlConfigFilenames) {
        ArrayList<String> configFiles = new ArrayList<String>();
        for (String filename : xmlConfigFilenames) {
            String path = this.getResourcesDir() + filename;
            this.assertFileIsValid(path);
            configFiles.add(path);
        }
        XMLConfigService svc = new XMLConfigService((ConfigSource)new FileConfigSource(configFiles));
        svc.initConfig();
        return svc;
    }
}

