/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.util.Pair;

public class BridgeTable<T> {
    HashMap<T, HashMap<Integer, HashMap<T, Counter>>> descendants = new HashMap();
    HashMap<T, HashMap<Integer, HashMap<T, Counter>>> ancestors = new HashMap();
    ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLink(T parent, T child) {
        this.readWriteLock.writeLock().lock();
        try {
            this.addDescendants(parent, child);
            this.addAncestors(parent, child);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void addLink(Pair<T, T> link) {
        this.addLink(link.getFirst(), link.getSecond());
    }

    public void addLinks(Collection<Pair<T, T>> links) {
        for (Pair<T, T> link : links) {
            this.addLink(link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLink(T parent, T child) {
        this.readWriteLock.writeLock().lock();
        try {
            this.removeDescendants(parent, child);
            this.removeAncestors(parent, child);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void removeLink(Pair<T, T> link) {
        this.removeLink(link.getFirst(), link.getSecond());
    }

    public void removeLinks(Collection<Pair<T, T>> links) {
        for (Pair<T, T> link : links) {
            this.removeLink(link);
        }
    }

    public HashSet<T> getDescendants(T node) {
        return this.getDescendants(node, 1, Integer.MAX_VALUE);
    }

    public HashSet<T> getDescendants(T node, int position) {
        return this.getDescendants(node, position, position);
    }

    public HashSet<T> getDescendants(T node, int start, int end) {
        HashSet<T> answer = new HashSet<T>();
        HashMap<Integer, HashMap<T, Counter>> found = this.descendants.get(node);
        if (found != null) {
            for (Integer key : found.keySet()) {
                if (key < start || key > end) continue;
                HashMap<T, Counter> asd = found.get(key);
                answer.addAll(asd.keySet());
            }
        }
        return answer;
    }

    public HashSet<T> getAncestors(T node) {
        return this.getAncestors(node, 1, Integer.MAX_VALUE);
    }

    public HashSet<T> getAncestors(T node, int position) {
        return this.getAncestors(node, position, position);
    }

    public HashSet<T> getAncestors(T node, int start, int end) {
        HashSet<T> answer = new HashSet<T>();
        HashMap<Integer, HashMap<T, Counter>> found = this.ancestors.get(node);
        if (found != null) {
            for (Integer key : found.keySet()) {
                if (key < start || key > end) continue;
                HashMap<T, Counter> asd = found.get(key);
                answer.addAll(asd.keySet());
            }
        }
        return answer;
    }

    private void addDescendants(T parent, T child) {
        HashMap<Integer, HashMap<Object, Counter>> parentsDescendants = this.descendants.get(parent);
        if (parentsDescendants == null) {
            parentsDescendants = new HashMap();
            this.descendants.put(parent, parentsDescendants);
        }
        HashMap<Integer, HashMap<T, Counter>> childDescendantsToAdd = this.descendants.get(child);
        this.add(childDescendantsToAdd, 0, parentsDescendants, child);
        HashMap<Integer, HashMap<T, Counter>> ancestorsToFixUp = this.ancestors.get(parent);
        if (ancestorsToFixUp != null) {
            for (Integer ancestorPosition : ancestorsToFixUp.keySet()) {
                HashMap<T, Counter> ancestorsToFixUpAtPosition = ancestorsToFixUp.get(ancestorPosition);
                for (T ancestorToFixUpAtPosition : ancestorsToFixUpAtPosition.keySet()) {
                    HashMap<Integer, HashMap<T, Counter>> ancestorDescendants = this.descendants.get(ancestorToFixUpAtPosition);
                    this.add(childDescendantsToAdd, ancestorPosition, ancestorDescendants, child);
                }
            }
        }
    }

    private void removeDescendants(T parent, T child) {
        HashMap<Integer, HashMap<T, Counter>> parentsDescendants = this.descendants.get(parent);
        if (parentsDescendants == null) {
            return;
        }
        HashMap<Integer, HashMap<T, Counter>> childDescendantsToRemove = this.descendants.get(child);
        this.remove(childDescendantsToRemove, 0, parentsDescendants, child);
        HashMap<Integer, HashMap<T, Counter>> ancestorsToFixUp = this.ancestors.get(parent);
        if (ancestorsToFixUp != null) {
            for (Integer ancestorPosition : ancestorsToFixUp.keySet()) {
                HashMap<T, Counter> ancestorsToFixUpAtPosition = ancestorsToFixUp.get(ancestorPosition);
                for (T ancestorToFixUpAtPosition : ancestorsToFixUpAtPosition.keySet()) {
                    HashMap<Integer, HashMap<T, Counter>> ancestorDescendants = this.descendants.get(ancestorToFixUpAtPosition);
                    this.remove(childDescendantsToRemove, ancestorPosition, ancestorDescendants, child);
                }
            }
        }
    }

    private void removeAncestors(T parent, T child) {
        HashMap<Integer, HashMap<T, Counter>> childsAncestors = this.ancestors.get(child);
        if (childsAncestors == null) {
            return;
        }
        HashMap<Integer, HashMap<T, Counter>> parentAncestorsToRemove = this.ancestors.get(parent);
        this.remove(parentAncestorsToRemove, 0, childsAncestors, parent);
        HashMap<Integer, HashMap<T, Counter>> decendantsToFixUp = this.descendants.get(child);
        if (decendantsToFixUp != null) {
            for (Integer descendantPosition : decendantsToFixUp.keySet()) {
                HashMap<T, Counter> decendantsToFixUpAtPosition = decendantsToFixUp.get(descendantPosition);
                for (T descendantToFixUpAtPosition : decendantsToFixUpAtPosition.keySet()) {
                    HashMap<Integer, HashMap<T, Counter>> descendantAncestors = this.ancestors.get(descendantToFixUpAtPosition);
                    this.remove(parentAncestorsToRemove, descendantPosition, descendantAncestors, parent);
                }
            }
        }
    }

    private void add(HashMap<Integer, HashMap<T, Counter>> toAdd, Integer position, HashMap<Integer, HashMap<T, Counter>> target, T node) {
        Counter counter;
        Integer directKey = position + 1;
        HashMap<Object, Counter> direct = target.get(directKey);
        if (direct == null) {
            direct = new HashMap();
            target.put(directKey, direct);
        }
        if ((counter = direct.get(node)) == null) {
            counter = new Counter();
            direct.put(node, counter);
        }
        counter.increment();
        if (toAdd != null) {
            for (Integer depth : toAdd.keySet()) {
                Integer newKey = position + depth + 1;
                HashMap<T, Counter> toAddAtDepth = toAdd.get(depth);
                HashMap<Object, Counter> targetAtDepthPlusOne = target.get(newKey);
                if (targetAtDepthPlusOne == null) {
                    targetAtDepthPlusOne = new HashMap();
                    target.put(newKey, targetAtDepthPlusOne);
                }
                for (T key : toAddAtDepth.keySet()) {
                    Counter counterToAdd = toAddAtDepth.get(key);
                    Counter counterToAddTo = targetAtDepthPlusOne.get(key);
                    if (counterToAddTo == null) {
                        counterToAddTo = new Counter();
                        targetAtDepthPlusOne.put(key, counterToAddTo);
                    }
                    counterToAddTo.add(counterToAdd);
                }
            }
        }
    }

    private void remove(HashMap<Integer, HashMap<T, Counter>> toRemove, Integer position, HashMap<Integer, HashMap<T, Counter>> target, T node) {
        Counter counter;
        Integer directKey = position + 1;
        HashMap<T, Counter> direct = target.get(directKey);
        if (direct != null && (counter = direct.get(node)) != null) {
            counter.decrement();
            if (counter.getCount() == 0) {
                direct.remove(node);
            }
        }
        if (toRemove != null) {
            for (Integer depth : toRemove.keySet()) {
                Integer newKey = position + depth + 1;
                HashMap<T, Counter> toRemoveAtDepth = toRemove.get(depth);
                HashMap<T, Counter> targetAtDepthPlusOne = target.get(newKey);
                if (targetAtDepthPlusOne == null) continue;
                for (T key : toRemoveAtDepth.keySet()) {
                    Counter counterToRemove = toRemoveAtDepth.get(key);
                    Counter counterToRemoveFrom = targetAtDepthPlusOne.get(key);
                    if (counterToRemoveFrom == null) continue;
                    counterToRemoveFrom.remove(counterToRemove);
                    if (counterToRemoveFrom.getCount() != 0) continue;
                    targetAtDepthPlusOne.remove(key);
                }
            }
        }
    }

    private void addAncestors(T parent, T child) {
        HashMap<Integer, HashMap<Object, Counter>> childsAncestors = this.ancestors.get(child);
        if (childsAncestors == null) {
            childsAncestors = new HashMap();
            this.ancestors.put(child, childsAncestors);
        }
        HashMap<Integer, HashMap<T, Counter>> parentAncestorsToAdd = this.ancestors.get(parent);
        this.add(parentAncestorsToAdd, 0, childsAncestors, parent);
        HashMap<Integer, HashMap<T, Counter>> descenantsToFixUp = this.descendants.get(child);
        if (descenantsToFixUp != null) {
            for (Integer descendantPosition : descenantsToFixUp.keySet()) {
                HashMap<T, Counter> descenantsToFixUpAtPosition = descenantsToFixUp.get(descendantPosition);
                for (T descenantToFixUpAtPosition : descenantsToFixUpAtPosition.keySet()) {
                    HashMap<Integer, HashMap<T, Counter>> descendatAncestors = this.ancestors.get(descenantToFixUpAtPosition);
                    this.add(parentAncestorsToAdd, descendantPosition, descendatAncestors, parent);
                }
            }
        }
    }

    public int size() {
        return this.ancestors.size();
    }

    public Set<T> keySet() {
        return this.ancestors.keySet();
    }

    private static class Counter {
        int count = 0;

        private Counter() {
        }

        void increment() {
            ++this.count;
        }

        void decrement() {
            --this.count;
        }

        int getCount() {
            return this.count;
        }

        void add(Counter other) {
            this.count += other.count;
        }

        void remove(Counter other) {
            this.count -= other.count;
        }
    }
}

