/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.alfresco.encoding.CharactersetFinder;
import org.alfresco.encoding.GuessEncodingCharsetFinder;
import org.alfresco.util.exec.RuntimeExec;

public class Convert {
    private static final String OPTION_HELP = "--help";
    private static final String OPTION_SVN_STATUS = "--svn-status";
    private static final String OPTION_MATCH = "--match=";
    private static final String OPTION_IGNORE = "--ignore=";
    private static final String OPTION_ENCODING = "--encoding=";
    private static final String OPTION_LINE_ENDING = "--line-ending=";
    private static final String OPTION_REPLACE_TABS = "--replace-tabs=";
    private static final String OPTION_NO_RECURSE = "--no-recurse";
    private static final String OPTION_NO_BACKUP = "--no-backup";
    private static final String OPTION_DRY_RUN = "--dry-run";
    private static final String OPTION_VERBOSE = "--verbose";
    private static final String OPTION_QUIET = "--quiet";
    private static final Set<String> OPTIONS = new HashSet<String>(13);
    private static final CharactersetFinder CHARACTER_ENCODING_FINDER;
    private File startDir = null;
    private boolean svnStatus = false;
    private boolean dryRun = false;
    private Pattern matchPattern = null;
    private Pattern ignorePattern = null;
    private Charset charset = null;
    private String lineEnding = null;
    private Integer replaceTabs = null;
    private boolean noRecurse = false;
    private boolean noBackup = false;
    private boolean verbose = false;
    private boolean quiet = false;
    private static final String EOF_CHECK = "--EOF-CHECK--";

    public static void main(String[] args) {
        File startDir;
        if (args.length < 1) {
            Convert.printUsage();
        }
        ArrayList<String> argList = new ArrayList<String>(args.length);
        List<String> argListFixed = Arrays.asList(args);
        argList.addAll(argListFixed);
        Map<String, String> optionValues = Convert.extractOptions(argList);
        if (optionValues.containsKey(OPTION_HELP)) {
            Convert.printUsage();
            System.exit(0);
        }
        if (argList.size() != 1) {
            Convert.printUsage();
            System.exit(1);
        }
        if (!(startDir = new File((String)argList.get(0))).exists() || !startDir.isDirectory()) {
            System.err.println("Convert: ");
            System.err.println("   Unable to find directory: " + startDir);
            System.err.flush();
            Convert.printUsage();
            System.exit(1);
        }
        Convert convert = new Convert(optionValues, startDir);
        convert.convert();
    }

    private Convert(Map<String, String> optionValues, File startDir) {
        this.startDir = startDir;
        this.svnStatus = optionValues.containsKey(OPTION_SVN_STATUS);
        this.dryRun = optionValues.containsKey(OPTION_DRY_RUN);
        String match = optionValues.get(OPTION_MATCH);
        String ignore = optionValues.get(OPTION_IGNORE);
        String encoding = optionValues.get(OPTION_ENCODING);
        this.lineEnding = optionValues.get(OPTION_LINE_ENDING);
        this.noRecurse = optionValues.containsKey(OPTION_NO_RECURSE);
        this.noBackup = optionValues.containsKey(OPTION_NO_BACKUP);
        this.verbose = optionValues.containsKey(OPTION_VERBOSE);
        this.quiet = optionValues.containsKey(OPTION_QUIET);
        String replaceTabsStr = optionValues.get(OPTION_REPLACE_TABS);
        if (replaceTabsStr != null) {
            try {
                this.replaceTabs = Integer.parseInt(replaceTabsStr);
            }
            catch (NumberFormatException e) {
                System.err.println("Convert: ");
                System.err.println("   Unable to determine how many spaces to replace tabs with: " + replaceTabsStr);
                System.err.flush();
                Convert.printUsage();
                System.exit(1);
            }
        }
        if (match == null) {
            match = ".*";
        }
        try {
            this.matchPattern = Pattern.compile(match);
        }
        catch (Throwable e) {
            System.err.println("Convert: ");
            System.err.println("   Unable to parse regular expression: " + match);
            System.err.flush();
            Convert.printUsage();
            System.exit(1);
        }
        if (ignore != null) {
            try {
                this.ignorePattern = Pattern.compile(ignore);
            }
            catch (Throwable e) {
                System.err.println("Convert: ");
                System.err.println("   Unable to parse regular expression: " + ignore);
                System.err.flush();
                Convert.printUsage();
                System.exit(1);
            }
        }
        if (encoding != null) {
            try {
                this.charset = Charset.forName(encoding);
            }
            catch (Throwable e) {
                System.err.println("Convert: ");
                System.err.println("   Unknown encoding: " + encoding);
                System.err.flush();
                Convert.printUsage();
                System.exit(1);
            }
        }
        if (this.lineEnding != null && !this.lineEnding.equals("WINDOWS") && !this.lineEnding.equals("UNIX")) {
            System.err.println("Convert: ");
            System.err.println("   Line endings can be either WINDOWS or UNIX: " + this.lineEnding);
            System.err.flush();
            Convert.printUsage();
            System.exit(1);
        }
        if (this.verbose && this.quiet) {
            System.err.println("Convert: ");
            System.err.println("   Cannot output in verbose and quiet mode.");
            System.err.flush();
            Convert.printUsage();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convert() {
        try {
            if (!this.quiet) {
                System.out.print("Converting files matching " + this.matchPattern);
                System.out.print(this.ignorePattern == null ? "" : " but not " + this.ignorePattern);
                System.out.println(this.dryRun ? " [DRY RUN]" : "");
            }
            if (!this.svnStatus) {
                this.convertDir(this.startDir);
            } else {
                this.convertSvn(this.startDir);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.flush();
            Convert.printUsage();
            System.exit(1);
        }
        finally {
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertSvn(File currentDir) throws Throwable {
        RuntimeExec exec = new RuntimeExec();
        exec.setCommand(new String[]{"svn", "status", currentDir.toString()});
        RuntimeExec.ExecutionResult result = exec.execute();
        if (!result.getSuccess()) {
            System.out.println("svn status command failed:" + exec);
        }
        String dump = result.getStdOut();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new StringReader(dump));
            while ((line = reader.readLine()) != null) {
                File file;
                String filename;
                if (!line.startsWith("A") && !line.startsWith("M") || (filename = line.substring(7).trim()).length() < 1 || !(file = new File(filename)).exists()) continue;
                this.convertFile(file);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    private void convertDir(File currentDir) throws Throwable {
        File[] childFiles;
        for (File childFile : childFiles = currentDir.listFiles()) {
            if (childFile.isDirectory()) {
                if (this.noRecurse) continue;
                this.convertDir(childFile);
                continue;
            }
            this.convertFile(childFile);
        }
    }

    private void convertFile(File file) throws Throwable {
        String filePath = file.getAbsolutePath();
        if (this.matchPattern.matcher(filePath).find()) {
            if (this.ignorePattern != null && this.ignorePattern.matcher(filePath).find()) {
                return;
            }
        } else {
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        if (file.length() > 0x100000L) {
            System.out.println(" (Too big)");
        }
        File backupFile = null;
        try {
            byte[] fileBytes = Convert.readFileIntoMemory(file);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(fileBytes);
            byte[] fileMd5 = md5.digest();
            Charset fileCharset = Convert.guessCharset(fileBytes, this.charset);
            byte[] convertedBytes = fileBytes;
            byte[] sourceBytes = fileBytes;
            byte[] convertedMd5 = fileMd5;
            if (this.replaceTabs != null) {
                sourceBytes = Convert.convertTabs(sourceBytes, fileCharset, this.replaceTabs);
            }
            if (this.charset != null) {
                // empty if block
            }
            if (this.lineEnding != null) {
                convertedBytes = Convert.convertLineEndings(sourceBytes, fileCharset, this.lineEnding);
            }
            boolean changed = false;
            if (convertedBytes != fileBytes) {
                md5 = MessageDigest.getInstance("MD5");
                md5.update(convertedBytes);
                convertedMd5 = md5.digest();
                boolean bl = changed = !Arrays.equals(fileMd5, convertedMd5);
            }
            if (changed) {
                if (!this.noBackup && !this.dryRun) {
                    String backupFilename = file.getAbsolutePath() + ".bak";
                    File backupFilePre = new File(backupFilename);
                    Convert.writeMemoryIntoFile(fileBytes, backupFilePre);
                    backupFile = backupFilePre;
                }
                if (!this.quiet) {
                    System.out.println("   " + file + " <Modified>");
                }
                if (!this.dryRun) {
                    Convert.writeMemoryIntoFile(convertedBytes, file);
                }
            } else if (this.verbose) {
                System.out.println("   " + file + " <No change>");
            }
        }
        catch (Throwable e) {
            if (backupFile != null) {
                try {
                    file.delete();
                    backupFile.renameTo(file);
                }
                catch (Throwable ee) {
                    System.err.println("Failed to restore backup file: " + backupFile);
                    ee.printStackTrace();
                }
            }
            throw e;
        }
        finally {
            if (!this.quiet || this.verbose) {
                System.out.flush();
            }
        }
    }

    private static Charset guessCharset(byte[] bytes, Charset charset) throws Exception {
        Charset guessedCharset = CHARACTER_ENCODING_FINDER.detectCharset(bytes);
        if (guessedCharset == null) {
            return charset;
        }
        return guessedCharset;
    }

    private static byte[] convertTabs(byte[] bytes, Charset charset, int replaceTabs) throws Exception {
        char[] chars;
        char tab = '\t';
        char space = ' ';
        StringBuilder sb = new StringBuilder(bytes.length);
        String charsetName = charset.name();
        String str = new String(bytes, charsetName);
        for (char c : chars = str.toCharArray()) {
            if (c == tab) {
                for (int i = 0; i < replaceTabs; ++i) {
                    sb.append(space);
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString().getBytes(charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] convertLineEndings(byte[] bytes, Charset charset, String lineEnding) throws Exception {
        String charsetName = charset.name();
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder(bytes.length);
        try {
            String str = new String(bytes, charsetName);
            str = str + EOF_CHECK;
            reader = new BufferedReader(new StringReader(str));
            String line = reader.readLine();
            while (line != null) {
                boolean addLine = true;
                if (line.equals(EOF_CHECK)) {
                    break;
                }
                if (line.endsWith(EOF_CHECK)) {
                    int index = line.indexOf(EOF_CHECK);
                    line = line.substring(0, index);
                    addLine = false;
                }
                sb.append(line);
                if (addLine) {
                    if (lineEnding.equalsIgnoreCase("UNIX")) {
                        sb.append("\n");
                    } else {
                        sb.append("\r\n");
                    }
                }
                line = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable e) {}
            }
        }
        return sb.toString().getBytes(charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFileIntoMemory(File file) throws Exception {
        InputStream is = null;
        OutputStream os = null;
        try {
            byte[] memory;
            int count;
            is = new BufferedInputStream(new FileInputStream(file));
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            os = new BufferedOutputStream(baos);
            byte[] buffer = new byte[1024];
            while ((count = is.read(buffer)) >= 0) {
                os.write(buffer, 0, count);
            }
            os.flush();
            byte[] byArray = memory = baos.toByteArray();
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMemoryIntoFile(byte[] bytes, File file) throws Exception {
        ByteArrayInputStream is = null;
        OutputStream os = null;
        try {
            int count;
            is = new ByteArrayInputStream(bytes);
            os = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[1024];
            while ((count = is.read(buffer)) >= 0) {
                os.write(buffer, 0, count);
            }
            os.flush();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable e) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    private static Map<String, String> extractOptions(List<String> args) {
        HashMap<String, String> optionValues = new HashMap<String, String>(13);
        Iterator<String> iterator = args.iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            boolean foundOption = false;
            for (String option : OPTIONS) {
                if (!arg.startsWith(option)) continue;
                foundOption = true;
                iterator.remove();
                if (option.endsWith("=")) {
                    int index = arg.indexOf("=");
                    if (index == arg.length() - 1) continue;
                    String value = arg.substring(index + 1);
                    optionValues.put(option, value);
                    continue;
                }
                String value = "";
                optionValues.put(option, value);
            }
            if (foundOption) continue;
            break;
        }
        return optionValues;
    }

    public static void printUsage() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Usage: \n").append("   Convert [options] directory \n").append("   \n").append("      options: \n").append("         --help \n").append("            Print this help. \n").append("         --svn-status \n").append("            Execute a 'svn status' command against the directory and use the output for the file list. \n").append("         --match=?: \n").append("            A regular expression that all filenames must match. \n").append("            This argument can be escaped with double quotes, ie.g \"[a-zA-z0-9 ]\". \n").append("            The regular expression will be applied to the full path of the file. \n").append("            Name seperators will be '/' on Unix and ''\\'' on Windows systems. \n").append("            The default is \"--match=.*\", or match all files. \n").append("         --ignore=?: \n").append("            A regular expression that all filenames must not match. \n").append("            This argument can be escaped with double quotes, ie.g \"[a-zA-z0-9 ]\". \n").append("            The regular expression will be applied to the full path of the file. \n").append("            Name seperators will be '/' on Unix and ''\\'' on Windows systems. \n").append("            This option is not present by default. \n").append("         --encoding=? \n").append("            If not specified, the encoding of the files is left unchanged. \n").append("            Typical values would be UTF-8, UTF-16 or any java-recognized encoding string. \n").append("         --line-ending=? \n").append("            This can either be WINDOWS or UNIX. \n").append("            If not set, the line ending style is left unchanged. \n").append("         --replace-tabs=? \n").append("            Specify the number of spaces to insert in place of a tab. \n").append("         --no-recurse \n").append("            Do not recurse into subdirectories. \n").append("         --no-backup \n").append("            The default is to make a backup of all files prior to modification. \n").append("            With this option, no backups are made. \n").append("         --dry-run \n").append("            Do not modify or backup any files. \n").append("            No filesystem modifications are made. \n").append("         --verbose \n").append("            Dump all files checked to std.out. \n").append("         --quiet \n").append("            Don't dump anything to std.out. \n").append("       directory: \n").append("          The directory to start searching in. \n").append("          If the directory has spaces in it, then escape it with double quotes, e.g. \"C:\\Program Files\" \n").append("   \n").append("Details of the modifications being made are written to std.out. \n").append("Errors are written to std.err. \n").append("When used without any options, this program will behave like a FIND. \n");
        System.out.println(sb);
        System.out.flush();
    }

    static {
        OPTIONS.add(OPTION_HELP);
        OPTIONS.add(OPTION_SVN_STATUS);
        OPTIONS.add(OPTION_MATCH);
        OPTIONS.add(OPTION_IGNORE);
        OPTIONS.add(OPTION_ENCODING);
        OPTIONS.add(OPTION_LINE_ENDING);
        OPTIONS.add(OPTION_REPLACE_TABS);
        OPTIONS.add(OPTION_NO_RECURSE);
        OPTIONS.add(OPTION_NO_BACKUP);
        OPTIONS.add(OPTION_DRY_RUN);
        OPTIONS.add(OPTION_VERBOSE);
        OPTIONS.add(OPTION_QUIET);
        CHARACTER_ENCODING_FINDER = new GuessEncodingCharsetFinder();
    }
}

