/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.alfresco.util.OneToManyMap;

public class OneToManyHashMap<K, V>
implements Map<K, Set<V>>,
OneToManyMap<K, V> {
    private final Map<K, Set<V>> map = new HashMap<K, Set<V>>();

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsSingleValue(V value) {
        Collection<Set<V>> values = this.map.values();
        for (Set<V> set : values) {
            if (!set.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, Set<V>> entry : this.map.entrySet()) {
            final K key = entry.getKey();
            Set<V> values = entry.getValue();
            for (final V value : values) {
                entries.add(new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return key;
                    }

                    @Override
                    public V getValue() {
                        return value;
                    }

                    @Override
                    public V setValue(V newValue) {
                        throw new UnsupportedOperationException("Cannot modify the entries returned by " + OneToManyHashMap.class.getName() + ".entries()!");
                    }
                });
            }
        }
        return entries;
    }

    @Override
    public Set<V> get(Object key) {
        Set<V> set = this.map.get(key);
        if (set == null) {
            set = new HashSet<V>();
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<V> put(K key, Set<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public V putSingleValue(K key, V value) {
        Set<V> values = this.map.get(key);
        if (values == null) {
            values = new HashSet<V>();
            this.map.put(key, values);
        }
        values.add(value);
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Set<V>> m) {
        this.map.putAll(m);
    }

    @Override
    public void putAllSingleValues(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.putSingleValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Set<V>> values() {
        return this.map.values();
    }

    @Override
    public Collection<V> flatValues() {
        LinkedList<V> flatValues = new LinkedList<V>();
        for (Set<V> values : this.map.values()) {
            flatValues.addAll(values);
        }
        return flatValues;
    }
}

