/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.Date;
import org.alfresco.util.AbstractTriggerBean;
import org.alfresco.util.TriggerBeanSPI;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class TriggerBean
extends AbstractTriggerBean
implements TriggerBeanSPI {
    public long startDelay = 0L;
    public long repeatInterval = 0L;
    public int repeatCount = -1;

    @Override
    public int getRepeatCount() {
        return this.repeatCount;
    }

    @Override
    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    @Override
    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    @Override
    public void setRepeatInterval(long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    @Override
    public void setRepeatIntervalMinutes(long repeatIntervalMinutes) {
        this.repeatInterval = repeatIntervalMinutes * 60L * 1000L;
    }

    @Override
    public long getStartDelay() {
        return this.startDelay;
    }

    @Override
    public void setStartDelay(long startDelay) {
        this.startDelay = startDelay;
    }

    @Override
    public void setStartDelayMinutes(long startDelayMinutes) {
        this.startDelay = startDelayMinutes * 60L * 1000L;
    }

    @Override
    public Trigger getTrigger() throws Exception {
        if (this.repeatInterval <= 0L && this.repeatCount != 0) {
            logger.error((Object)("Job " + this.getBeanName() + " - repeatInterval/repeatIntervalMinutes cannot be 0 (or -ve) unless repeatCount is also 0"));
            return null;
        }
        SimpleTrigger trigger = new SimpleTrigger(this.getBeanName(), "DEFAULT");
        trigger.setStartTime(new Date(System.currentTimeMillis() + this.startDelay));
        trigger.setRepeatCount(this.repeatCount);
        trigger.setRepeatInterval(this.repeatInterval);
        return trigger;
    }
}

