/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class NamedObjectRegistry<T> {
    private static final Log logger = LogFactory.getLog(NamedObjectRegistry.class);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private Class<T> storageType;
    private Pattern namePattern;
    private final Map<String, T> objects;

    public NamedObjectRegistry() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.namePattern = null;
        this.storageType = null;
        this.objects = new HashMap<String, T>(13);
    }

    public NamedObjectRegistry(Class<T> type) {
        this();
        this.setStorageType(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageType(Class<T> clazz) {
        this.writeLock.lock();
        try {
            this.storageType = clazz;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setNamePattern(String namePattern) {
        this.writeLock.lock();
        try {
            this.namePattern = Pattern.compile(namePattern);
        }
        catch (PatternSyntaxException e) {
            throw new AlfrescoRuntimeException("Regular expression compilation failed for property 'namePrefix': " + e.getMessage(), e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String name, T object) {
        ParameterCheck.mandatoryString((String)"name", (String)name);
        ParameterCheck.mandatory((String)"object", object);
        if (!this.storageType.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("This NameObjectRegistry only accepts objects of type " + this.storageType);
        }
        this.writeLock.lock();
        try {
            if (this.storageType == null) {
                throw new IllegalStateException("The registry has not been configured (setStorageType not yet called yet)");
            }
            if (this.namePattern != null && !this.namePattern.matcher(name).matches()) {
                throw new IllegalArgumentException("Object name '" + name + "' does not match required pattern: " + this.namePattern);
            }
            T prevObject = this.objects.put(name, object);
            if (prevObject != null && prevObject != object) {
                logger.warn((Object)("Overwriting name object in registry: \n   Previous: " + prevObject + "\n" + "   New:      " + object));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getNamedObject(String name) {
        this.readLock.lock();
        try {
            T t = this.objects.get(name);
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, T> getAllNamedObjects() {
        this.readLock.lock();
        try {
            HashMap<String, T> hashMap = new HashMap<String, T>(this.objects);
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.writeLock.lock();
        try {
            if (this.storageType == null) {
                this.objects.clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

