/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.opencmis.dictionary.AbstractTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.BasePropertyDefintionWrapper;
import org.alfresco.opencmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;

public abstract class ShadowTypeDefinitionWrapper
extends AbstractTypeDefinitionWrapper {
    private static final long serialVersionUID = 1L;

    @Override
    public void connectParentAndSubTypes(CMISMapping cmisMapping, CMISAbstractDictionaryService.DictionaryRegistry registry, DictionaryService dictionaryService) {
        if (this.typeDef.getParentTypeId() != null) {
            this.parent = registry.typeDefsByTypeId.get(this.typeDef.getParentTypeId());
        } else {
            if (!this.isBaseType()) {
                throw new AlfrescoRuntimeException("Type " + this.typeDef.getId() + " has no parent!");
            }
            this.parent = null;
        }
        this.children = new ArrayList();
        Collection<QName> childrenNames = dictionaryService.getSubTypes(cmisMapping.getAlfrescoClass(this.getAlfrescoName()), false);
        for (QName childName : childrenNames) {
            if (!cmisMapping.isValidCmisObject(this.getBaseTypeId(), childName)) continue;
            TypeDefinitionWrapper child = registry.typeDefsByQName.get(childName);
            if (child == null) {
                throw new AlfrescoRuntimeException("Failed to retrieve sub type for type id " + childName + " for parent type " + this.getAlfrescoName() + "!");
            }
            this.children.add(child);
        }
    }

    @Override
    public void resolveInheritance(CMISMapping cmisMapping, CMISAbstractDictionaryService.DictionaryRegistry registry, DictionaryService dictionaryService) {
        if (this.parent != null) {
            for (PropertyDefinitionWrapper propDef : this.parent.getProperties()) {
                if (this.propertiesById.containsKey(propDef.getPropertyId())) continue;
                org.alfresco.service.cmr.dictionary.PropertyDefinition alfrescoPropDef = dictionaryService.getProperty(propDef.getOwningType().getAlfrescoName(), propDef.getAlfrescoName());
                PropertyDefinition<?> propertyDefintion = this.createPropertyDefinition(cmisMapping, propDef.getPropertyId(), alfrescoPropDef.getName(), alfrescoPropDef, true);
                if (propertyDefintion == null) continue;
                this.registerProperty(new BasePropertyDefintionWrapper(propertyDefintion, alfrescoPropDef.getName(), propDef.getOwningType(), propDef.getPropertyAccessor(), propDef.getPropertyLuceneBuilder()));
            }
        }
        for (TypeDefinitionWrapper child : this.children) {
            if (!(child instanceof AbstractTypeDefinitionWrapper)) continue;
            ((AbstractTypeDefinitionWrapper)child).resolveInheritance(cmisMapping, registry, dictionaryService);
        }
    }
}

