/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.CMISAccessControlFormatEnum;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.springframework.beans.factory.InitializingBean;

public class CMISMapping
implements InitializingBean {
    public static String CMIS_MODEL_NS = "cmis";
    public static String CMIS_MODEL_URI = "http://www.alfresco.org/model/cmis/1.0/cs01";
    public static String CMIS_EXT_NS = "cmisext";
    public static String CMIS_EXT_URI = "http://www.alfresco.org/model/cmis/1.0/cs01ext";
    public static String CMIS_MODEL_NAME = "cmismodel";
    public static QName CMIS_MODEL_QNAME = QName.createQName(CMIS_MODEL_URI, CMIS_MODEL_NAME);
    public static QName CMIS_DATATYPE_ID = QName.createQName(CMIS_MODEL_URI, "id");
    public static QName CMIS_DATATYPE_URI = QName.createQName(CMIS_MODEL_URI, "uri");
    public static QName CMIS_DATATYPE_XML = QName.createQName(CMIS_MODEL_URI, "xml");
    public static QName CMIS_DATATYPE_HTML = QName.createQName(CMIS_MODEL_URI, "html");
    public static QName OBJECT_QNAME = QName.createQName(CMIS_EXT_URI, "object");
    public static QName DOCUMENT_QNAME = QName.createQName(CMIS_MODEL_URI, "document");
    public static QName FOLDER_QNAME = QName.createQName(CMIS_MODEL_URI, "folder");
    public static QName RELATIONSHIP_QNAME = QName.createQName(CMIS_MODEL_URI, "relationship");
    public static QName POLICY_QNAME = QName.createQName(CMIS_MODEL_URI, "policy");
    public static QName ASPECTS_QNAME = QName.createQName(CMIS_EXT_URI, "aspects");
    public static String OBJECT_TYPE_ID = "cmisext:object";
    public static final String CMIS_READ = "cmis:read";
    public static final String CMIS_WRITE = "cmis:write";
    public static final String CMIS_ALL = "cmis:all";
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private Map<QName, String> mapAlfrescoQNameToTypeId = new HashMap<QName, String>();
    private Map<QName, QName> mapCmisQNameToAlfrescoQName = new HashMap<QName, QName>();
    private Map<QName, QName> mapAlfrescoQNameToCmisQName = new HashMap<QName, QName>();
    private Map<QName, PropertyType> mapAlfrescoToCmisDataType = new HashMap<QName, PropertyType>();
    private Map<PropertyType, QName> mapCmisDataTypeToAlfresco = new HashMap<PropertyType, QName>();

    public void afterPropertiesSet() {
        this.mapAlfrescoQNameToTypeId.put(OBJECT_QNAME, OBJECT_TYPE_ID);
        this.mapAlfrescoQNameToTypeId.put(DOCUMENT_QNAME, BaseTypeId.CMIS_DOCUMENT.value());
        this.mapAlfrescoQNameToTypeId.put(FOLDER_QNAME, BaseTypeId.CMIS_FOLDER.value());
        this.mapAlfrescoQNameToTypeId.put(RELATIONSHIP_QNAME, BaseTypeId.CMIS_RELATIONSHIP.value());
        this.mapAlfrescoQNameToTypeId.put(POLICY_QNAME, BaseTypeId.CMIS_POLICY.value());
        this.mapAlfrescoQNameToCmisQName.put(ContentModel.TYPE_CONTENT, DOCUMENT_QNAME);
        this.mapAlfrescoQNameToCmisQName.put(ContentModel.TYPE_FOLDER, FOLDER_QNAME);
        this.mapCmisQNameToAlfrescoQName.put(DOCUMENT_QNAME, ContentModel.TYPE_CONTENT);
        this.mapCmisQNameToAlfrescoQName.put(FOLDER_QNAME, ContentModel.TYPE_FOLDER);
        this.mapCmisQNameToAlfrescoQName.put(RELATIONSHIP_QNAME, null);
        this.mapCmisQNameToAlfrescoQName.put(POLICY_QNAME, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.ANY, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.ENCRYPTED, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.ASSOC_REF, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.BOOLEAN, PropertyType.BOOLEAN);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.CATEGORY, PropertyType.ID);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.CHILD_ASSOC_REF, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.CONTENT, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.DATE, PropertyType.DATETIME);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.DATETIME, PropertyType.DATETIME);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.DOUBLE, PropertyType.DECIMAL);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.FLOAT, PropertyType.DECIMAL);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.INT, PropertyType.INTEGER);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.LOCALE, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.PERIOD, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.LONG, PropertyType.INTEGER);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.MLTEXT, PropertyType.STRING);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.NODE_REF, PropertyType.ID);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.PATH, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.QNAME, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.TEXT, PropertyType.STRING);
        this.mapAlfrescoToCmisDataType.put(CMIS_DATATYPE_ID, PropertyType.ID);
        this.mapAlfrescoToCmisDataType.put(CMIS_DATATYPE_URI, PropertyType.URI);
        this.mapAlfrescoToCmisDataType.put(CMIS_DATATYPE_HTML, PropertyType.HTML);
        this.mapCmisDataTypeToAlfresco.put(PropertyType.ID, DataTypeDefinition.TEXT);
        this.mapCmisDataTypeToAlfresco.put(PropertyType.INTEGER, DataTypeDefinition.LONG);
        this.mapCmisDataTypeToAlfresco.put(PropertyType.STRING, DataTypeDefinition.TEXT);
        this.mapCmisDataTypeToAlfresco.put(PropertyType.DECIMAL, DataTypeDefinition.DOUBLE);
        this.mapCmisDataTypeToAlfresco.put(PropertyType.BOOLEAN, DataTypeDefinition.BOOLEAN);
        this.mapCmisDataTypeToAlfresco.put(PropertyType.DATETIME, DataTypeDefinition.DATETIME);
        this.mapCmisDataTypeToAlfresco.put(PropertyType.URI, DataTypeDefinition.TEXT);
        this.mapCmisDataTypeToAlfresco.put(PropertyType.HTML, DataTypeDefinition.TEXT);
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public String getCmisTypeId(BaseTypeId scope, QName typeQName) {
        String typeId = this.mapAlfrescoQNameToTypeId.get(typeQName);
        if (typeId == null) {
            String p = null;
            switch (scope) {
                case CMIS_DOCUMENT: {
                    p = "D";
                    break;
                }
                case CMIS_FOLDER: {
                    p = "F";
                    break;
                }
                case CMIS_RELATIONSHIP: {
                    p = "R";
                    break;
                }
                case CMIS_POLICY: {
                    p = "P";
                    break;
                }
                default: {
                    throw new CmisRuntimeException("Invalid base type!");
                }
            }
            return p + ":" + typeQName.toPrefixString(this.namespaceService);
        }
        return typeId;
    }

    public String getCmisTypeId(QName classQName) {
        if (classQName.equals(ContentModel.TYPE_CONTENT)) {
            return this.getCmisTypeId(BaseTypeId.CMIS_DOCUMENT, classQName);
        }
        if (classQName.equals(ContentModel.TYPE_FOLDER)) {
            return this.getCmisTypeId(BaseTypeId.CMIS_FOLDER, classQName);
        }
        if (classQName.equals(RELATIONSHIP_QNAME)) {
            return this.getCmisTypeId(BaseTypeId.CMIS_RELATIONSHIP, classQName);
        }
        if (classQName.equals(POLICY_QNAME)) {
            return this.getCmisTypeId(BaseTypeId.CMIS_POLICY, classQName);
        }
        if (classQName.equals(ASPECTS_QNAME)) {
            return this.getCmisTypeId(BaseTypeId.CMIS_POLICY, classQName);
        }
        if (this.isValidCmisDocument(classQName)) {
            return this.getCmisTypeId(BaseTypeId.CMIS_DOCUMENT, classQName);
        }
        if (this.isValidCmisFolder(classQName)) {
            return this.getCmisTypeId(BaseTypeId.CMIS_FOLDER, classQName);
        }
        if (this.isValidCmisRelationship(classQName)) {
            return this.getCmisTypeId(BaseTypeId.CMIS_RELATIONSHIP, classQName);
        }
        if (this.isValidCmisPolicy(classQName)) {
            return this.getCmisTypeId(BaseTypeId.CMIS_POLICY, classQName);
        }
        return null;
    }

    public String buildPrefixEncodedString(QName qname) {
        return qname.toPrefixString(this.namespaceService);
    }

    public QName getAlfrescoName(String typeId) {
        if (typeId.length() < 4 || typeId.charAt(1) != ':') {
            throw new CmisInvalidArgumentException("Malformed type id '" + typeId + "'");
        }
        return QName.createQName(typeId.substring(2), this.namespaceService);
    }

    public boolean isValidCmisDocumentOrFolder(QName typeQName) {
        return this.isValidCmisFolder(typeQName) || this.isValidCmisDocument(typeQName);
    }

    public boolean isValidCmisObject(BaseTypeId scope, QName qname) {
        switch (scope) {
            case CMIS_DOCUMENT: {
                return this.isValidCmisDocument(qname);
            }
            case CMIS_FOLDER: {
                return this.isValidCmisFolder(qname);
            }
            case CMIS_POLICY: {
                return this.isValidCmisPolicy(qname);
            }
            case CMIS_RELATIONSHIP: {
                return this.isValidCmisRelationship(qname);
            }
        }
        return false;
    }

    public boolean isValidCmisFolder(QName typeQName) {
        if (typeQName == null) {
            return false;
        }
        if (typeQName.equals(FOLDER_QNAME)) {
            return true;
        }
        if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_FOLDER)) {
            return !typeQName.equals(ContentModel.TYPE_FOLDER);
        }
        return false;
    }

    public boolean isValidCmisDocument(QName typeQName) {
        if (typeQName == null) {
            return false;
        }
        if (typeQName.equals(DOCUMENT_QNAME)) {
            return true;
        }
        if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_CONTENT)) {
            return !typeQName.equals(ContentModel.TYPE_CONTENT);
        }
        return false;
    }

    public boolean isValidCmisPolicy(QName typeQName) {
        if (typeQName == null) {
            return false;
        }
        if (typeQName.equals(POLICY_QNAME)) {
            return true;
        }
        if (typeQName.equals(ASPECTS_QNAME)) {
            return true;
        }
        AspectDefinition aspectDef = this.dictionaryService.getAspect(typeQName);
        if (aspectDef == null) {
            return false;
        }
        return !this.dictionaryService.isSubClass(aspectDef.getName(), ContentModel.ASPECT_VERSIONABLE) && !this.dictionaryService.isSubClass(aspectDef.getName(), ContentModel.ASPECT_AUDITABLE) && !this.dictionaryService.isSubClass(aspectDef.getName(), ContentModel.ASPECT_REFERENCEABLE);
    }

    public boolean isValidCmisRelationship(QName associationQName) {
        if (associationQName == null) {
            return false;
        }
        if (associationQName.equals(RELATIONSHIP_QNAME)) {
            return true;
        }
        AssociationDefinition associationDefinition = this.dictionaryService.getAssociation(associationQName);
        if (associationDefinition == null) {
            return false;
        }
        return !associationDefinition.isChild();
    }

    public QName getCmisType(QName typeQName) {
        QName mapped = this.mapAlfrescoQNameToCmisQName.get(typeQName);
        if (mapped != null) {
            return mapped;
        }
        return typeQName;
    }

    public boolean isRemappedType(QName typeQName) {
        return this.mapAlfrescoQNameToCmisQName.containsKey(typeQName);
    }

    public QName getAlfrescoClass(QName cmisTypeQName) {
        QName mapped = this.mapCmisQNameToAlfrescoQName.get(cmisTypeQName);
        if (mapped != null) {
            return mapped;
        }
        return cmisTypeQName;
    }

    public PropertyType getDataType(DataTypeDefinition datatype) {
        return this.getDataType(datatype.getName());
    }

    public PropertyType getDataType(QName dataType) {
        return this.mapAlfrescoToCmisDataType.get(dataType);
    }

    public QName getAlfrescoDataType(PropertyType propertyType) {
        return this.mapCmisDataTypeToAlfresco.get(propertyType);
    }

    public String getCmisPropertyId(QName propertyQName) {
        return propertyQName.toPrefixString(this.namespaceService);
    }

    public Collection<Pair<String, Boolean>> getReportedPermissions(String permission, Set<String> permissions, boolean hasFull, boolean isDirect, CMISAccessControlFormatEnum format) {
        ArrayList<Pair<String, Boolean>> answer = new ArrayList<Pair<String, Boolean>>(20);
        if (hasFull) {
            answer.add(new Pair((Object)CMIS_READ, (Object)false));
            answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_WRITE, (Object)false));
            answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_ALL, (Object)false));
        }
        for (String perm : permissions) {
            if ("Read".equals(perm)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_READ, (Object)false));
            } else if ("Write".equals(perm)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_WRITE, (Object)false));
            } else if ("All".equals(perm)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_READ, (Object)false));
                answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_WRITE, (Object)false));
                answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_ALL, (Object)false));
            }
            if (!hasFull) continue;
            answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_READ, (Object)false));
            answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_WRITE, (Object)false));
            answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_ALL, (Object)false));
        }
        if (format == CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS) {
            if ("Read".equals(permission)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_READ, (Object)false));
                answer.add((Pair<String, Boolean>)new Pair((Object)permission, (Object)isDirect));
            } else if ("Write".equals(permission)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_WRITE, (Object)false));
                answer.add((Pair<String, Boolean>)new Pair((Object)permission, (Object)isDirect));
            } else if ("All".equals(permission)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_ALL, (Object)false));
                answer.add((Pair<String, Boolean>)new Pair((Object)permission, (Object)isDirect));
            } else {
                answer.add((Pair<String, Boolean>)new Pair((Object)permission, (Object)isDirect));
            }
        } else if (format == CMISAccessControlFormatEnum.CMIS_BASIC_PERMISSIONS) {
            if ("Read".equals(permission)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_READ, (Object)isDirect));
            } else if ("Write".equals(permission)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_WRITE, (Object)isDirect));
            } else if ("All".equals(permission)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)CMIS_ALL, (Object)isDirect));
            }
        }
        return answer;
    }

    public String getSetPermission(String permission) {
        if (permission.equals(CMIS_READ)) {
            return "Read";
        }
        if (permission.equals(CMIS_WRITE)) {
            return "Write";
        }
        if (permission.equals(CMIS_ALL)) {
            return "All";
        }
        return permission;
    }
}

