/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.alfresco.opencmis.mapping.AbstractSimpleLuceneBuilder;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.analysis.DateTimeAnalyser;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.lucene.index.IndexReader;
import org.springframework.extensions.surf.util.I18NUtil;

public class DirectLuceneBuilder
extends AbstractSimpleLuceneBuilder {
    private DictionaryService dictionaryService;
    private QName alfrescoName;

    public DirectLuceneBuilder(DictionaryService dictionaryService, QName alfrescoName) {
        this.dictionaryService = dictionaryService;
        this.alfrescoName = alfrescoName;
    }

    @Override
    public String getLuceneSortField(AbstractLuceneQueryParser lqp) {
        String analyserClassName;
        String field = this.getLuceneFieldName();
        Locale sortLocale = null;
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(QName.createQName(field.substring(1)));
        if (propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
            throw new CmisInvalidArgumentException("Order on content properties is not curently supported");
        }
        if (propertyDef.getDataType().getName().equals(DataTypeDefinition.MLTEXT) || propertyDef.getDataType().getName().equals(DataTypeDefinition.TEXT)) {
            List<Locale> locales = lqp.getSearchParameters().getLocales();
            if (locales == null || locales.size() == 0) {
                locales = Collections.singletonList(I18NUtil.getLocale());
            }
            if (locales.size() > 1) {
                throw new CmisInvalidArgumentException("Order on text/mltext properties with more than one locale is not curently supported");
            }
            sortLocale = locales.get(0);
            HashSet<String> allowableLocales = new HashSet<String>();
            MLAnalysisMode analysisMode = lqp.getDefaultSearchMLAnalysisMode();
            for (Locale l : MLAnalysisMode.getLocales(analysisMode, sortLocale, false)) {
                allowableLocales.add(l.toString());
            }
            String sortField = field;
            for (Object current : lqp.getIndexReader().getFieldNames(IndexReader.FieldOption.INDEXED)) {
                String fieldLocale;
                String currentString = (String)current;
                if (!currentString.startsWith(field) || !currentString.endsWith(".sort") || !allowableLocales.contains(fieldLocale = currentString.substring(field.length() + 1, currentString.length() - 5))) continue;
                if (fieldLocale.equals(sortLocale.toString())) {
                    sortField = currentString;
                    break;
                }
                if (sortLocale.toString().startsWith(fieldLocale)) {
                    if (!sortField.equals(field) && currentString.length() >= sortField.length()) continue;
                    sortField = currentString;
                    continue;
                }
                if (!fieldLocale.startsWith(sortLocale.toString()) || !sortField.equals(field) && currentString.length() >= sortField.length()) continue;
                sortField = currentString;
            }
            field = sortField;
        } else if (propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME) && (analyserClassName = propertyDef.resolveAnalyserClassName()).equals(DateTimeAnalyser.class.getCanonicalName())) {
            field = field + ".sort";
        }
        return field;
    }

    @Override
    public String getLuceneFieldName() {
        StringBuilder field = new StringBuilder(64);
        field.append("@");
        field.append(this.alfrescoName);
        return field.toString();
    }

    @Override
    protected String getValueAsString(Serializable value) {
        PropertyDefinition pd = this.dictionaryService.getProperty(this.alfrescoName);
        Object converted = DefaultTypeConverter.INSTANCE.convert(pd.getDataType(), (Object)value);
        String asString = DefaultTypeConverter.INSTANCE.convert(String.class, converted);
        return asString;
    }

    @Override
    protected QName getQNameForExists() {
        return this.alfrescoName;
    }

    @Override
    protected DataTypeDefinition getInDataType() {
        PropertyDefinition pd = this.dictionaryService.getProperty(this.alfrescoName);
        return pd.getDataType();
    }

    @Override
    protected String getRangeMax() {
        if (this.getInDataType().getName().equals(DataTypeDefinition.DATE)) {
            return "MAX";
        }
        if (this.getInDataType().getName().equals(DataTypeDefinition.DATETIME)) {
            return "MAX";
        }
        return super.getRangeMax();
    }

    @Override
    protected String getRangeMin() {
        if (this.getInDataType().getName().equals(DataTypeDefinition.DATE)) {
            return "MIN";
        }
        if (this.getInDataType().getName().equals(DataTypeDefinition.DATETIME)) {
            return "MIN";
        }
        return super.getRangeMin();
    }
}

