/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.search;

import java.util.Locale;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchParameters;
import org.springframework.extensions.surf.util.I18NUtil;

public class CMISQueryOptions
extends QueryOptions {
    private CMISQueryMode queryMode = CMISQueryMode.CMS_STRICT;

    public static CMISQueryOptions create(SearchParameters searchParameters) {
        String sql = searchParameters.getQuery();
        CMISQueryOptions options = new CMISQueryOptions(sql, searchParameters.getStores().get(0));
        options.setIncludeInTransactionData(!searchParameters.excludeDataInTheCurrentTransaction());
        options.setDefaultFTSConnective(searchParameters.getDefaultOperator() == SearchParameters.Operator.OR ? QueryOptions.Connective.OR : QueryOptions.Connective.AND);
        options.setDefaultFTSFieldConnective(searchParameters.getDefaultOperator() == SearchParameters.Operator.OR ? QueryOptions.Connective.OR : QueryOptions.Connective.AND);
        options.setSkipCount(searchParameters.getSkipCount());
        options.setMaxPermissionChecks(searchParameters.getMaxPermissionChecks());
        options.setMaxPermissionCheckTimeMillis(searchParameters.getMaxPermissionCheckTimeMillis());
        if (searchParameters.getLimitBy() == LimitBy.FINAL_SIZE) {
            options.setMaxItems(searchParameters.getLimit());
        } else {
            options.setMaxItems(searchParameters.getMaxItems());
        }
        options.setMlAnalaysisMode(searchParameters.getMlAnalaysisMode());
        options.setLocales(searchParameters.getLocales());
        options.setStores(searchParameters.getStores());
        options.setUseInMemorySort(searchParameters.getUseInMemorySort());
        options.setMaxRawResultSetSizeForInMemorySort(searchParameters.getMaxRawResultSetSizeForInMemorySort());
        options.setQueryParameterDefinitions(searchParameters.getQueryParameterDefinitions());
        options.setDefaultFieldName(searchParameters.getDefaultFieldName());
        return options;
    }

    public CMISQueryOptions(String query, StoreRef storeRef) {
        this(query, storeRef, I18NUtil.getLocale());
    }

    public CMISQueryOptions(String query, StoreRef storeRef, Locale locale) {
        super(query, storeRef, locale);
    }

    public CMISQueryMode getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(CMISQueryMode queryMode) {
        this.queryMode = queryMode;
    }

    public SearchParameters getAsSearchParmeters() {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setDefaultFieldName(this.getDefaultFieldName());
        searchParameters.setDefaultFTSFieldConnective(this.getDefaultFTSFieldConnective() == QueryOptions.Connective.OR ? SearchParameters.Operator.OR : SearchParameters.Operator.AND);
        searchParameters.setDefaultFTSOperator(this.getDefaultFTSConnective() == QueryOptions.Connective.OR ? SearchParameters.Operator.OR : SearchParameters.Operator.AND);
        searchParameters.setDefaultOperator(this.getDefaultFTSConnective() == QueryOptions.Connective.OR ? SearchParameters.Operator.OR : SearchParameters.Operator.AND);
        searchParameters.setLanguage("cmis-alfresco");
        if (this.getMaxItems() > 0) {
            searchParameters.setLimit(this.getMaxItems());
            searchParameters.setLimitBy(LimitBy.FINAL_SIZE);
            searchParameters.setMaxItems(this.getMaxItems());
        }
        searchParameters.setMaxPermissionChecks(this.getMaxPermissionChecks());
        searchParameters.setMaxPermissionCheckTimeMillis(this.getMaxPermissionCheckTimeMillis());
        searchParameters.setMlAnalaysisMode(this.getMlAnalaysisMode());
        searchParameters.setQuery(this.getQuery());
        searchParameters.setSkipCount(this.getSkipCount());
        for (Locale locale : this.getLocales()) {
            searchParameters.addLocale(locale);
        }
        for (QueryParameterDefinition queryParameterDefinition : this.getQueryParameterDefinitions()) {
            searchParameters.addQueryParameterDefinition(queryParameterDefinition);
        }
        for (StoreRef storeRef : this.getStores()) {
            searchParameters.addStore(storeRef);
        }
        return searchParameters;
    }

    public static enum CMISQueryMode {
        CMS_STRICT,
        CMS_WITH_ALFRESCO_EXTENSIONS;

    }
}

