/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import junit.framework.TestCase;
import org.alfresco.repo.cache.MemoryCache;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.M2DataType;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.dictionary.NamespaceDAOImpl;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.dictionary.constraint.RegexConstraint;
import org.alfresco.repo.dictionary.constraint.RegisteredConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.repo.tenant.SingleTServiceImpl;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

public class DictionaryDAOTest
extends TestCase {
    public static final String TEST_RESOURCE_MESSAGES = "alfresco/messages/dictionary-messages";
    private static final String TEST_URL = "http://www.alfresco.org/test/dictionarydaotest/1.0";
    private static final String TEST2_URL = "http://www.alfresco.org/test/dictionarydaotest2/1.0";
    private static final String TEST_MODEL = "org/alfresco/repo/dictionary/dictionarydaotest_model.xml";
    private static final String TEST_BUNDLE = "org/alfresco/repo/dictionary/dictionarydaotest_model";
    private DictionaryService service;

    public void setUp() {
        I18NUtil.registerResourceBundle((String)TEST_RESOURCE_MESSAGES);
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        namespaceDAO.setTenantService(tenantService);
        this.initNamespaceCaches(namespaceDAO);
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl(namespaceDAO);
        dictionaryDAO.setTenantService(tenantService);
        this.initDictionaryCaches(dictionaryDAO);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add(TEST_MODEL);
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(TEST_BUNDLE);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setLabels(labels);
        bootstrap.setDictionaryDAO(dictionaryDAO);
        bootstrap.setTenantService(tenantService);
        bootstrap.bootstrap();
        DictionaryComponent component = new DictionaryComponent();
        component.setDictionaryDAO(dictionaryDAO);
        this.service = component;
    }

    private void initDictionaryCaches(DictionaryDAOImpl dictionaryDAO) {
        dictionaryDAO.setDictionaryRegistryCache(new MemoryCache<String, DictionaryDAOImpl.DictionaryRegistry>());
    }

    private void initNamespaceCaches(NamespaceDAOImpl namespaceDAO) {
        namespaceDAO.setNamespaceRegistryCache(new MemoryCache<String, NamespaceDAOImpl.NamespaceRegistry>());
    }

    public void testBootstrap() {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        namespaceDAO.setTenantService(tenantService);
        this.initNamespaceCaches(namespaceDAO);
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl(namespaceDAO);
        dictionaryDAO.setTenantService(tenantService);
        this.initDictionaryCaches(dictionaryDAO);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO(dictionaryDAO);
        bootstrap.setTenantService(tenantService);
        bootstrap.bootstrap();
    }

    public void testLabels() {
        QName model = QName.createQName(TEST_URL, "dictionarydaotest");
        ModelDefinition modelDef = this.service.getModel(model);
        DictionaryDAOTest.assertEquals((String)"Model Description", (String)modelDef.getDescription());
        QName type = QName.createQName(TEST_URL, "base");
        TypeDefinition typeDef = this.service.getType(type);
        DictionaryDAOTest.assertEquals((String)"Base Title", (String)typeDef.getTitle());
        DictionaryDAOTest.assertEquals((String)"Base Description", (String)typeDef.getDescription());
        QName prop = QName.createQName(TEST_URL, "prop1");
        PropertyDefinition propDef = this.service.getProperty(prop);
        DictionaryDAOTest.assertEquals((String)"Prop1 Title", (String)propDef.getTitle());
        DictionaryDAOTest.assertEquals((String)"Prop1 Description", (String)propDef.getDescription());
        QName assoc = QName.createQName(TEST_URL, "assoc1");
        AssociationDefinition assocDef = this.service.getAssociation(assoc);
        DictionaryDAOTest.assertEquals((String)"Assoc1 Title", (String)assocDef.getTitle());
        DictionaryDAOTest.assertEquals((String)"Assoc1 Description", (String)assocDef.getDescription());
        QName datatype = QName.createQName(TEST_URL, "datatype");
        DataTypeDefinition datatypeDef = this.service.getDataType(datatype);
        DictionaryDAOTest.assertEquals((String)"alfresco/model/dataTypeAnalyzers", (String)datatypeDef.getAnalyserResourceBundleName());
        QName constraint = QName.createQName(TEST_URL, "list1");
        ConstraintDefinition constraintDef = this.service.getConstraint(constraint);
        DictionaryDAOTest.assertEquals((String)"List1 title", (String)constraintDef.getTitle());
        DictionaryDAOTest.assertEquals((String)"List1 description", (String)constraintDef.getDescription());
        ListOfValuesConstraint lovConstraint = (ListOfValuesConstraint)constraintDef.getConstraint();
        DictionaryDAOTest.assertEquals((String)"Wrong localised lov value.", (String)"ABC display", (String)lovConstraint.getDisplayLabel("ABC"));
        DictionaryDAOTest.assertEquals((String)"Wrong localised lov value.", (String)"DEF display", (String)lovConstraint.getDisplayLabel("DEF"));
        DictionaryDAOTest.assertEquals((String)"Wrong localised lov value.", (String)"VALUE WITH SPACES display", (String)lovConstraint.getDisplayLabel("VALUE WITH SPACES"));
        DictionaryDAOTest.assertNull((Object)lovConstraint.getDisplayLabel("nosuchLOV"));
        QName constrainedPropName = QName.createQName(TEST_URL, "constrainedProp");
        PropertyDefinition constrainedPropDef = this.service.getProperty(constrainedPropName);
        List<ConstraintDefinition> constraints = constrainedPropDef.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Wrong number of constraints.", (int)1, (int)constraints.size());
        ConstraintDefinition inlineConstraintDef = constraints.get(0);
        lovConstraint = (ListOfValuesConstraint)inlineConstraintDef.getConstraint();
        DictionaryDAOTest.assertEquals((String)"Wrong localised lov value.", (String)"ALPHA display", (String)lovConstraint.getDisplayLabel("ALPHA"));
        DictionaryDAOTest.assertEquals((String)"Wrong localised lov value.", (String)"BETA display", (String)lovConstraint.getDisplayLabel("BETA"));
        DictionaryDAOTest.assertEquals((String)"Wrong localised lov value.", (String)"GAMMA, DELTA display", (String)lovConstraint.getDisplayLabel("GAMMA, DELTA"));
        DictionaryDAOTest.assertEquals((String)"Wrong localised lov value.", (String)"OMEGA", (String)lovConstraint.getDisplayLabel("OMEGA"));
        DictionaryDAOTest.assertNull((Object)lovConstraint.getDisplayLabel("nosuchLOV"));
    }

    public void testConstraints() {
        QName model = QName.createQName(TEST_URL, "dictionarydaotest");
        Collection<ConstraintDefinition> modelConstraints = this.service.getConstraints(model);
        DictionaryDAOTest.assertEquals((int)23, (int)modelConstraints.size());
        QName conRegExp1QName = QName.createQName(TEST_URL, "regex1");
        boolean found1 = false;
        QName conStrLen1QName = QName.createQName(TEST_URL, "stringLength1");
        boolean found2 = false;
        for (ConstraintDefinition constraintDef : modelConstraints) {
            if (constraintDef.getName().equals(conRegExp1QName)) {
                DictionaryDAOTest.assertEquals((String)"Regex1 title", (String)constraintDef.getTitle());
                DictionaryDAOTest.assertEquals((String)"Regex1 description", (String)constraintDef.getDescription());
                found1 = true;
            }
            if (!constraintDef.getName().equals(conStrLen1QName)) continue;
            DictionaryDAOTest.assertNull((Object)constraintDef.getTitle());
            DictionaryDAOTest.assertNull((Object)constraintDef.getDescription());
            found2 = true;
        }
        DictionaryDAOTest.assertTrue((boolean)found1);
        DictionaryDAOTest.assertTrue((boolean)found2);
        QName propNoConstraintsQName = QName.createQName(TEST_URL, "fileprop");
        PropertyDefinition propNoConstraintsDef = this.service.getProperty(propNoConstraintsQName);
        DictionaryDAOTest.assertNotNull((String)"Property without constraints returned null list", propNoConstraintsDef.getConstraints());
        QName prop1QName = QName.createQName(TEST_URL, "prop1");
        PropertyDefinition propDef = this.service.getProperty(prop1QName);
        List<ConstraintDefinition> constraints = propDef.getConstraints();
        DictionaryDAOTest.assertNotNull((String)"Null constraints list", constraints);
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)3, (int)constraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(constraints.get(0).getConstraint() instanceof RegexConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(constraints.get(1).getConstraint() instanceof StringLengthConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(constraints.get(2).getConstraint() instanceof RegisteredConstraint));
        ConstraintDefinition constraintDef = constraints.get(0);
        DictionaryDAOTest.assertTrue((String)"Constraint anonymous name incorrect", (boolean)constraintDef.getName().getLocalName().startsWith("prop1_anon"));
        DictionaryDAOTest.assertTrue((String)"Constraint title incorrect", (boolean)constraintDef.getTitle().equals("Regex1 title"));
        DictionaryDAOTest.assertTrue((String)"Constraint description incorrect", (boolean)constraintDef.getDescription().equals("Regex1 description"));
        constraintDef = constraints.get(1);
        DictionaryDAOTest.assertTrue((String)"Constraint anonymous name incorrect", (boolean)constraintDef.getName().getLocalName().startsWith("prop1_anon"));
        DictionaryDAOTest.assertTrue((String)"Constraint title incorrect", (boolean)constraintDef.getTitle().equals("Prop1 Strlen1 title"));
        DictionaryDAOTest.assertTrue((String)"Constraint description incorrect", (boolean)constraintDef.getDescription().equals("Prop1 Strlen1 description"));
        Constraint constraint = constraintDef.getConstraint();
        DictionaryDAOTest.assertNotNull((String)"Reference constraint has no implementation", (Object)constraint);
    }

    public void testConstraintsOverrideInheritance() {
        QName baseQName = QName.createQName(TEST_URL, "base");
        QName fileQName = QName.createQName(TEST_URL, "file");
        QName folderQName = QName.createQName(TEST_URL, "folder");
        QName prop1QName = QName.createQName(TEST_URL, "prop1");
        PropertyDefinition prop1Def = this.service.getProperty(baseQName, prop1QName);
        DictionaryDAOTest.assertNotNull((Object)prop1Def);
        List<ConstraintDefinition> prop1Constraints = prop1Def.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)3, (int)prop1Constraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(0).getConstraint() instanceof RegexConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(1).getConstraint() instanceof StringLengthConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(2).getConstraint() instanceof RegisteredConstraint));
        prop1Def = this.service.getProperty(folderQName, prop1QName);
        DictionaryDAOTest.assertNotNull((Object)prop1Def);
        prop1Constraints = prop1Def.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)3, (int)prop1Constraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(0).getConstraint() instanceof RegexConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(1).getConstraint() instanceof StringLengthConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(2).getConstraint() instanceof RegisteredConstraint));
        prop1Def = this.service.getProperty(fileQName, prop1QName);
        DictionaryDAOTest.assertNotNull((Object)prop1Def);
        prop1Constraints = prop1Def.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)3, (int)prop1Constraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(0).getConstraint() instanceof StringLengthConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(1).getConstraint() instanceof RegexConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(2).getConstraint() instanceof RegisteredConstraint));
    }

    public void testConstraintsOverrideInheritanceOnAspects() {
        QName aspectBaseQName = QName.createQName(TEST_URL, "aspect-base");
        QName aspectOneQName = QName.createQName(TEST_URL, "aspect-one");
        QName aspectTwoQName = QName.createQName(TEST_URL, "aspect-two");
        QName aspectThreeQName = QName.createQName(TEST2_URL, "aspect-three");
        QName propQName = QName.createQName(TEST_URL, "aspect-base-p1");
        PropertyDefinition propDef = this.service.getProperty(aspectBaseQName, propQName);
        DictionaryDAOTest.assertNotNull((Object)propDef);
        List<ConstraintDefinition> propConstraints = propDef.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)1, (int)propConstraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(propConstraints.get(0).getConstraint() instanceof ListOfValuesConstraint));
        ListOfValuesConstraint constraint = (ListOfValuesConstraint)propConstraints.get(0).getConstraint();
        List<String> allowedValues = constraint.getAllowedValues();
        DictionaryDAOTest.assertEquals((String)"Expected 3 allowed values", (int)3, (int)allowedValues.size());
        DictionaryDAOTest.assertEquals((String)"ABC", (String)allowedValues.get(0));
        DictionaryDAOTest.assertEquals((String)"DEF", (String)allowedValues.get(1));
        DictionaryDAOTest.assertEquals((String)"VALUE WITH SPACES", (String)allowedValues.get(2));
        propDef = this.service.getProperty(aspectOneQName, propQName);
        DictionaryDAOTest.assertNotNull((Object)propDef);
        propConstraints = propDef.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)1, (int)propConstraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(propConstraints.get(0).getConstraint() instanceof ListOfValuesConstraint));
        constraint = (ListOfValuesConstraint)propConstraints.get(0).getConstraint();
        allowedValues = constraint.getAllowedValues();
        DictionaryDAOTest.assertEquals((String)"Expected 1 allowed values", (int)1, (int)allowedValues.size());
        DictionaryDAOTest.assertEquals((String)"HIJ", (String)allowedValues.get(0));
        propDef = this.service.getProperty(aspectTwoQName, propQName);
        DictionaryDAOTest.assertNotNull((Object)propDef);
        propConstraints = propDef.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)2, (int)propConstraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(propConstraints.get(0).getConstraint() instanceof ListOfValuesConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(propConstraints.get(1).getConstraint() instanceof ListOfValuesConstraint));
        constraint = (ListOfValuesConstraint)propConstraints.get(0).getConstraint();
        allowedValues = constraint.getAllowedValues();
        DictionaryDAOTest.assertEquals((String)"Wrong number of allowed values", (int)3, (int)allowedValues.size());
        DictionaryDAOTest.assertEquals((String)"ABC", (String)allowedValues.get(0));
        DictionaryDAOTest.assertEquals((String)"DEF", (String)allowedValues.get(1));
        DictionaryDAOTest.assertEquals((String)"VALUE WITH SPACES", (String)allowedValues.get(2));
        constraint = (ListOfValuesConstraint)propConstraints.get(1).getConstraint();
        allowedValues = constraint.getAllowedValues();
        DictionaryDAOTest.assertEquals((String)"Wrong number of allowed values", (int)1, (int)allowedValues.size());
        DictionaryDAOTest.assertEquals((String)"HIJ", (String)allowedValues.get(0));
        propDef = this.service.getProperty(aspectThreeQName, propQName);
        DictionaryDAOTest.assertNotNull((Object)propDef);
        propConstraints = propDef.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)1, (int)propConstraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(propConstraints.get(0).getConstraint() instanceof ListOfValuesConstraint));
        constraint = (ListOfValuesConstraint)propConstraints.get(0).getConstraint();
        allowedValues = constraint.getAllowedValues();
        DictionaryDAOTest.assertEquals((String)"Expected 1 allowed values", (int)1, (int)allowedValues.size());
        DictionaryDAOTest.assertEquals((String)"XYZ", (String)allowedValues.get(0));
    }

    public void testArchive() {
        QName testFileQName = QName.createQName(TEST_URL, "file");
        ClassDefinition fileClassDef = this.service.getClass(testFileQName);
        DictionaryDAOTest.assertTrue((String)"File type should have the archive flag", (boolean)fileClassDef.getArchive());
        QName testFileDerivedQName = QName.createQName(TEST_URL, "file-derived");
        ClassDefinition fileDerivedClassDef = this.service.getClass(testFileDerivedQName);
        DictionaryDAOTest.assertTrue((String)"Direct derived File type should have the archive flag", (boolean)fileDerivedClassDef.getArchive());
        QName testFileDerivedNoArchiveQName = QName.createQName(TEST_URL, "file-derived-no-archive");
        ClassDefinition fileDerivedNoArchiveClassDef = this.service.getClass(testFileDerivedNoArchiveQName);
        DictionaryDAOTest.assertFalse((String)"Derived File with archive override type should NOT have the archive flag", (boolean)fileDerivedNoArchiveClassDef.getArchive());
        QName testFolderQName = QName.createQName(TEST_URL, "folder");
        ClassDefinition folderClassDef = this.service.getClass(testFolderQName);
        DictionaryDAOTest.assertNull((String)"Folder type should not have the archive flag", (Object)folderClassDef.getArchive());
    }

    public void testMandatoryEnforced() {
        QName testEnforcedQName = QName.createQName(TEST_URL, "enforced");
        ClassDefinition testEnforcedClassDef = this.service.getClass(testEnforcedQName);
        Map<QName, PropertyDefinition> testEnforcedPropertyDefs = testEnforcedClassDef.getProperties();
        PropertyDefinition propertyDef = null;
        QName testMandatoryEnforcedQName = QName.createQName(TEST_URL, "mandatory-enforced");
        propertyDef = testEnforcedPropertyDefs.get(testMandatoryEnforcedQName);
        DictionaryDAOTest.assertNotNull((String)("Property not found: " + testMandatoryEnforcedQName), (Object)propertyDef);
        DictionaryDAOTest.assertTrue((String)("Expected property to be mandatory: " + testMandatoryEnforcedQName), (boolean)propertyDef.isMandatory());
        DictionaryDAOTest.assertTrue((String)("Expected property to be mandatory-enforced: " + testMandatoryEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
        QName testMandatoryNotEnforcedQName = QName.createQName(TEST_URL, "mandatory-not-enforced");
        propertyDef = testEnforcedPropertyDefs.get(testMandatoryNotEnforcedQName);
        DictionaryDAOTest.assertNotNull((String)("Property not found: " + testMandatoryNotEnforcedQName), (Object)propertyDef);
        DictionaryDAOTest.assertTrue((String)("Expected property to be mandatory: " + testMandatoryNotEnforcedQName), (boolean)propertyDef.isMandatory());
        DictionaryDAOTest.assertFalse((String)("Expected property to be mandatory-not-enforced: " + testMandatoryNotEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
        QName testMandatoryDefaultEnforcedQName = QName.createQName(TEST_URL, "mandatory-default-enforced");
        propertyDef = testEnforcedPropertyDefs.get(testMandatoryDefaultEnforcedQName);
        DictionaryDAOTest.assertNotNull((String)("Property not found: " + testMandatoryDefaultEnforcedQName), (Object)propertyDef);
        DictionaryDAOTest.assertTrue((String)("Expected property to be mandatory: " + testMandatoryDefaultEnforcedQName), (boolean)propertyDef.isMandatory());
        DictionaryDAOTest.assertFalse((String)("Expected property to be mandatory-not-enforced: " + testMandatoryDefaultEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
    }

    public void testSubClassOf() {
        QName invalid = QName.createQName(TEST_URL, "invalid");
        QName base = QName.createQName(TEST_URL, "base");
        QName file = QName.createQName(TEST_URL, "file");
        QName folder = QName.createQName(TEST_URL, "folder");
        QName referenceable = QName.createQName(TEST_URL, "referenceable");
        boolean testI1 = this.service.isSubClass(invalid, referenceable);
        DictionaryDAOTest.assertFalse((boolean)testI1);
        boolean testI2 = this.service.isSubClass(referenceable, invalid);
        DictionaryDAOTest.assertFalse((boolean)testI2);
        boolean testI3 = this.service.isSubClass(invalid, invalid);
        DictionaryDAOTest.assertFalse((boolean)testI3);
        boolean test1 = this.service.isSubClass(file, referenceable);
        DictionaryDAOTest.assertFalse((boolean)test1);
        boolean test2 = this.service.isSubClass(file, folder);
        DictionaryDAOTest.assertFalse((boolean)test2);
        boolean test3 = this.service.isSubClass(file, file);
        DictionaryDAOTest.assertTrue((boolean)test3);
        boolean test4 = this.service.isSubClass(folder, base);
        DictionaryDAOTest.assertTrue((boolean)test4);
        boolean test5 = this.service.isSubClass(base, folder);
        DictionaryDAOTest.assertFalse((boolean)test5);
    }

    public void testPropertyOverride() {
        TypeDefinition type1 = this.service.getType(QName.createQName(TEST_URL, "overridetype1"));
        Map<QName, PropertyDefinition> props1 = type1.getProperties();
        PropertyDefinition prop1 = props1.get(QName.createQName(TEST_URL, "propoverride"));
        String def1 = prop1.getDefaultValue();
        DictionaryDAOTest.assertEquals((String)"one", (String)def1);
        TypeDefinition type2 = this.service.getType(QName.createQName(TEST_URL, "overridetype2"));
        Map<QName, PropertyDefinition> props2 = type2.getProperties();
        PropertyDefinition prop2 = props2.get(QName.createQName(TEST_URL, "propoverride"));
        String def2 = prop2.getDefaultValue();
        DictionaryDAOTest.assertEquals((String)"two", (String)def2);
        TypeDefinition type3 = this.service.getType(QName.createQName(TEST_URL, "overridetype3"));
        Map<QName, PropertyDefinition> props3 = type3.getProperties();
        PropertyDefinition prop3 = props3.get(QName.createQName(TEST_URL, "propoverride"));
        String def3 = prop3.getDefaultValue();
        DictionaryDAOTest.assertEquals((String)"three", (String)def3);
    }

    public void testChildAssocPropagate() {
        AssociationDefinition assocDef = this.service.getAssociation(QName.createQName(TEST_URL, "childassoc1"));
        DictionaryDAOTest.assertNotNull((String)"No such child association found", (Object)assocDef);
        DictionaryDAOTest.assertTrue((String)"Expected a child association", (boolean)(assocDef instanceof ChildAssociationDefinition));
        ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)assocDef;
        DictionaryDAOTest.assertFalse((String)"Expected 'false' for default timestamp propagation", (boolean)childAssocDef.getPropagateTimestamps());
        assocDef = this.service.getAssociation(QName.createQName(TEST_URL, "childassocPropagate"));
        DictionaryDAOTest.assertNotNull((String)"No such child association found", (Object)assocDef);
        DictionaryDAOTest.assertTrue((String)"Expected a child association", (boolean)(assocDef instanceof ChildAssociationDefinition));
        childAssocDef = (ChildAssociationDefinition)assocDef;
        DictionaryDAOTest.assertTrue((String)"Expected 'true' for timestamp propagation", (boolean)childAssocDef.getPropagateTimestamps());
    }

    public void testDataTypeAnlyserResolution() {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        namespaceDAO.setTenantService(tenantService);
        this.initNamespaceCaches(namespaceDAO);
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl(namespaceDAO);
        dictionaryDAO.setTenantService(tenantService);
        this.initDictionaryCaches(dictionaryDAO);
        dictionaryDAO.putModel(this.createModel(dictionaryDAO, false, false, false));
        QName modeQName = QName.createQName("test:analyzerModel", namespaceDAO);
        QName dataTypeQName = QName.createQName("test:analyzerDataType", namespaceDAO);
        ModelDefinition modelDefinition = dictionaryDAO.getModel(modeQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), null);
        DataTypeDefinition dataTypeDefinition = dictionaryDAO.getDataType(dataTypeQName);
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getAnalyserResourceBundleName(), null);
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getDefaultAnalyserClassName(), null);
        DictionaryDAOTest.assertNull((Object)dataTypeDefinition.resolveAnalyserClassName());
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("defaultBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modeQName);
        dictionaryDAO.putModel(this.createModel(dictionaryDAO, false, false, true));
        modelDefinition = dictionaryDAO.getModel(modeQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), null);
        dataTypeDefinition = dictionaryDAO.getDataType(dataTypeQName);
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getAnalyserResourceBundleName(), null);
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getDefaultAnalyserClassName(), (String)"java.lang.String");
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.resolveAnalyserClassName(), (String)"java.lang.String");
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("defaultBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modeQName);
        dictionaryDAO.putModel(this.createModel(dictionaryDAO, false, true, false));
        modelDefinition = dictionaryDAO.getModel(modeQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), null);
        dataTypeDefinition = dictionaryDAO.getDataType(dataTypeQName);
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getAnalyserResourceBundleName(), (String)"dataTypeResourceBundle");
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getDefaultAnalyserClassName(), null);
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("dataTypeResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("defaultBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modeQName);
        dictionaryDAO.putModel(this.createModel(dictionaryDAO, false, true, true));
        modelDefinition = dictionaryDAO.getModel(modeQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), null);
        dataTypeDefinition = dictionaryDAO.getDataType(dataTypeQName);
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getAnalyserResourceBundleName(), (String)"dataTypeResourceBundle");
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getDefaultAnalyserClassName(), (String)"java.lang.String");
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("dataTypeResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("defaultBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modeQName);
        dictionaryDAO.putModel(this.createModel(dictionaryDAO, true, false, false));
        modelDefinition = dictionaryDAO.getModel(modeQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), (String)"dataTypeModelResourceBundle");
        dataTypeDefinition = dictionaryDAO.getDataType(dataTypeQName);
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getAnalyserResourceBundleName(), null);
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getDefaultAnalyserClassName(), null);
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("dataTypeModelResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("defaultBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modeQName);
        dictionaryDAO.putModel(this.createModel(dictionaryDAO, true, false, true));
        modelDefinition = dictionaryDAO.getModel(modeQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), (String)"dataTypeModelResourceBundle");
        dataTypeDefinition = dictionaryDAO.getDataType(dataTypeQName);
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getAnalyserResourceBundleName(), null);
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getDefaultAnalyserClassName(), (String)"java.lang.String");
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("dataTypeModelResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("defaultBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modeQName);
        dictionaryDAO.putModel(this.createModel(dictionaryDAO, true, true, false));
        modelDefinition = dictionaryDAO.getModel(modeQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), (String)"dataTypeModelResourceBundle");
        dataTypeDefinition = dictionaryDAO.getDataType(dataTypeQName);
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getAnalyserResourceBundleName(), (String)"dataTypeResourceBundle");
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getDefaultAnalyserClassName(), null);
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("dataTypeResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("defaultBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modeQName);
        dictionaryDAO.putModel(this.createModel(dictionaryDAO, true, true, true));
        modelDefinition = dictionaryDAO.getModel(modeQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), (String)"dataTypeModelResourceBundle");
        dataTypeDefinition = dictionaryDAO.getDataType(dataTypeQName);
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getAnalyserResourceBundleName(), (String)"dataTypeResourceBundle");
        DictionaryDAOTest.assertEquals((String)dataTypeDefinition.getDefaultAnalyserClassName(), (String)"java.lang.String");
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("dataTypeResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            dataTypeDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("defaultBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modeQName);
    }

    private M2Model createModel(DictionaryDAO dictionaryDAO, boolean withModelBundle, boolean withDataTypeBundle, boolean withTypeAnalyserClss) {
        String testNamespace = "http://www.alfresco.org/test/analyserResolution";
        M2Model model = M2Model.createModel("test:analyzerModel");
        model.createNamespace(testNamespace, "test");
        if (withModelBundle) {
            model.setAnalyserResourceBundleName("dataTypeModelResourceBundle");
        }
        M2DataType dataTypeWithAnalyserBundleName = model.createPropertyType("test:analyzerDataType");
        dataTypeWithAnalyserBundleName.setJavaClassName("java.lang.String");
        if (withTypeAnalyserClss) {
            dataTypeWithAnalyserBundleName.setDefaultAnalyserClassName("java.lang.String");
        }
        if (withDataTypeBundle) {
            dataTypeWithAnalyserBundleName.setAnalyserResourceBundleName("dataTypeResourceBundle");
        }
        return model;
    }

    public void testTypeAnalyserResolution() {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        namespaceDAO.setTenantService(tenantService);
        this.initNamespaceCaches(namespaceDAO);
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl(namespaceDAO);
        dictionaryDAO.setTenantService(tenantService);
        this.initDictionaryCaches(dictionaryDAO);
        dictionaryDAO.putModel(this.createModel(dictionaryDAO, true, false, true));
        dictionaryDAO.putModel(this.createTypeModel(dictionaryDAO, true, true, true, true));
        QName modelQName = QName.createQName("test2:analyzerClassModel", namespaceDAO);
        QName superQName = QName.createQName("test2:analyzerSuperType", namespaceDAO);
        QName typeQName = QName.createQName("test2:analyzerType", namespaceDAO);
        QName propertyQName = QName.createQName("test2:analyzerProperty", namespaceDAO);
        ModelDefinition modelDefinition = dictionaryDAO.getModel(modelQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), (String)"typeModelResourceBundle");
        TypeDefinition superDefinition = dictionaryDAO.getType(superQName);
        DictionaryDAOTest.assertEquals((String)superDefinition.getAnalyserResourceBundleName(), (String)"superTypeResourceBundle");
        TypeDefinition classDefinition = dictionaryDAO.getType(typeQName);
        DictionaryDAOTest.assertEquals((String)classDefinition.getAnalyserResourceBundleName(), (String)"typeResourceBundle");
        PropertyDefinition propertyDefinition = dictionaryDAO.getProperty(propertyQName);
        DictionaryDAOTest.assertEquals((String)propertyDefinition.getAnalyserResourceBundleName(), (String)"propertyResourceBundle");
        try {
            propertyDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("propertyResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            propertyDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("propertyResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modelQName);
        dictionaryDAO.putModel(this.createTypeModel(dictionaryDAO, true, true, true, false));
        modelDefinition = dictionaryDAO.getModel(modelQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), (String)"typeModelResourceBundle");
        superDefinition = dictionaryDAO.getType(superQName);
        DictionaryDAOTest.assertEquals((String)superDefinition.getAnalyserResourceBundleName(), (String)"superTypeResourceBundle");
        classDefinition = dictionaryDAO.getType(typeQName);
        DictionaryDAOTest.assertEquals((String)classDefinition.getAnalyserResourceBundleName(), (String)"typeResourceBundle");
        propertyDefinition = dictionaryDAO.getProperty(propertyQName);
        DictionaryDAOTest.assertEquals((String)propertyDefinition.getAnalyserResourceBundleName(), null);
        try {
            propertyDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("typeResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            propertyDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("typeResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modelQName);
        dictionaryDAO.putModel(this.createTypeModel(dictionaryDAO, true, true, false, false));
        modelDefinition = dictionaryDAO.getModel(modelQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), (String)"typeModelResourceBundle");
        superDefinition = dictionaryDAO.getType(superQName);
        DictionaryDAOTest.assertEquals((String)superDefinition.getAnalyserResourceBundleName(), (String)"superTypeResourceBundle");
        classDefinition = dictionaryDAO.getType(typeQName);
        DictionaryDAOTest.assertEquals((String)classDefinition.getAnalyserResourceBundleName(), null);
        propertyDefinition = dictionaryDAO.getProperty(propertyQName);
        DictionaryDAOTest.assertEquals((String)propertyDefinition.getAnalyserResourceBundleName(), null);
        try {
            propertyDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("superTypeResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            propertyDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("superTypeResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modelQName);
        dictionaryDAO.putModel(this.createTypeModel(dictionaryDAO, true, false, false, false));
        modelDefinition = dictionaryDAO.getModel(modelQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), (String)"typeModelResourceBundle");
        superDefinition = dictionaryDAO.getType(superQName);
        DictionaryDAOTest.assertEquals((String)superDefinition.getAnalyserResourceBundleName(), null);
        classDefinition = dictionaryDAO.getType(typeQName);
        DictionaryDAOTest.assertEquals((String)classDefinition.getAnalyserResourceBundleName(), null);
        propertyDefinition = dictionaryDAO.getProperty(propertyQName);
        DictionaryDAOTest.assertEquals((String)propertyDefinition.getAnalyserResourceBundleName(), null);
        try {
            propertyDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("typeModelResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            propertyDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("typeModelResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modelQName);
        dictionaryDAO.putModel(this.createTypeModel(dictionaryDAO, false, false, false, false));
        modelDefinition = dictionaryDAO.getModel(modelQName);
        DictionaryDAOTest.assertEquals((String)modelDefinition.getAnalyserResourceBundleName(), null);
        superDefinition = dictionaryDAO.getType(superQName);
        DictionaryDAOTest.assertEquals((String)superDefinition.getAnalyserResourceBundleName(), null);
        classDefinition = dictionaryDAO.getType(typeQName);
        DictionaryDAOTest.assertEquals((String)classDefinition.getAnalyserResourceBundleName(), null);
        propertyDefinition = dictionaryDAO.getProperty(propertyQName);
        DictionaryDAOTest.assertEquals((String)propertyDefinition.getAnalyserResourceBundleName(), null);
        try {
            propertyDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("dataTypeModelResourceBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName("defaultBundle");
        try {
            propertyDefinition.resolveAnalyserClassName();
            DictionaryDAOTest.fail();
        }
        catch (MissingResourceException mre) {
            DictionaryDAOTest.assertTrue((boolean)mre.getMessage().contains("defaultBundle"));
        }
        dictionaryDAO.setDefaultAnalyserResourceBundleName(null);
        dictionaryDAO.removeModel(modelQName);
    }

    private M2Model createTypeModel(DictionaryDAOImpl dictionaryDAO, boolean withModelBundle, boolean withInheritedTypeBundle, boolean withTypeBundle, boolean withPropertyBundle) {
        String testNamespace = "http://www.alfresco.org/test/analyserResolutionType";
        M2Model model = M2Model.createModel("test2:analyzerClassModel");
        model.createNamespace(testNamespace, "test2");
        model.createImport("http://www.alfresco.org/test/analyserResolution", "test");
        if (withModelBundle) {
            model.setAnalyserResourceBundleName("typeModelResourceBundle");
        }
        M2Type superTypeWithAnalyserBundleName = model.createType("test2:analyzerSuperType");
        if (withInheritedTypeBundle) {
            superTypeWithAnalyserBundleName.setAnalyserResourceBundleName("superTypeResourceBundle");
        }
        M2Type typeWithAnalyserBundleName = model.createType("test2:analyzerType");
        typeWithAnalyserBundleName.setParentName("test2:analyzerSuperType");
        if (withTypeBundle) {
            typeWithAnalyserBundleName.setAnalyserResourceBundleName("typeResourceBundle");
        }
        M2Property propertyWithAnalyserBundelName = typeWithAnalyserBundleName.createProperty("test2:analyzerProperty");
        propertyWithAnalyserBundelName.setType("test:analyzerDataType");
        if (withPropertyBundle) {
            propertyWithAnalyserBundelName.setAnalyserResourceBundleName("propertyResourceBundle");
        }
        return model;
    }
}

