/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.namespace.NamespaceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NamespaceDAOImpl
implements NamespaceDAO {
    private static final Log logger = LogFactory.getLog(NamespaceDAOImpl.class);
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();
    private SimpleCache<String, NamespaceRegistry> namespaceRegistryCache;
    private ThreadLocal<NamespaceRegistry> namespaceRegistryThreadLocal = new ThreadLocal();
    private ThreadLocal<NamespaceRegistry> defaultNamespaceRegistryThreadLocal = new ThreadLocal();
    private TenantService tenantService;
    private DictionaryDAO dictionaryDAO;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setNamespaceRegistryCache(SimpleCache<String, NamespaceRegistry> namespaceRegistryCache) {
        this.namespaceRegistryCache = namespaceRegistryCache;
    }

    @Override
    public void registerDictionary(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterDictionaryInit() {
        String tenantDomain = this.getTenantDomain();
        NamespaceRegistry namespaceRegistry = this.getNamespaceRegistryLocal(tenantDomain);
        if (namespaceRegistry == null) {
            this.readLock.lock();
            try {
                namespaceRegistry = this.namespaceRegistryCache.get(tenantDomain);
                if (namespaceRegistry == null) {
                    throw new IllegalStateException("In afterDictionaryInit, yet no namespace registry for domain " + tenantDomain);
                }
                if (tenantDomain.equals("")) {
                    this.defaultNamespaceRegistryThreadLocal.set(namespaceRegistry);
                }
                this.namespaceRegistryThreadLocal.set(namespaceRegistry);
            }
            finally {
                this.readLock.unlock();
            }
        } else {
            this.writeLock.lock();
            try {
                this.namespaceRegistryCache.put(tenantDomain, namespaceRegistry);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public void init() {
        String tenantDomain = this.getTenantDomain();
        NamespaceRegistry namespaceRegistry = this.initNamespaceRegistry(tenantDomain);
        if (namespaceRegistry == null) {
            throw new AlfrescoRuntimeException("Failed to init namespaceRegistry " + tenantDomain);
        }
    }

    @Override
    public void destroy() {
        String tenantDomain = this.getTenantDomain();
        this.removeNamespaceRegistry(tenantDomain);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Namespaces destroyed");
        }
    }

    private NamespaceRegistry initNamespaceRegistry(String tenantDomain) {
        NamespaceRegistry namespaceRegistry = this.createNamespaceLocal(tenantDomain);
        namespaceRegistry.setUrisCache(new ArrayList<String>());
        namespaceRegistry.setPrefixesCache(new HashMap<String, String>());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Empty namespaces initialised: " + namespaceRegistry + " - " + this.namespaceRegistryThreadLocal + " [" + Thread.currentThread() + "]"));
        }
        return namespaceRegistry;
    }

    @Override
    public Collection<String> getURIs() {
        if (!this.tenantService.isTenantUser()) {
            return Collections.unmodifiableCollection(this.getUrisCtx());
        }
        List<String> domainUris = this.getUrisCtx();
        ArrayList<String> urisFiltered = new ArrayList<String>();
        for (String uri : this.getUrisCtx("")) {
            if (domainUris.contains(uri)) continue;
            urisFiltered.add(uri);
        }
        urisFiltered.addAll(domainUris);
        return Collections.unmodifiableCollection(urisFiltered);
    }

    @Override
    public Collection<String> getPrefixes() {
        if (!AuthenticationUtil.isMtEnabled() || !this.tenantService.isTenantUser()) {
            return Collections.unmodifiableCollection(this.getPrefixesCtx("").keySet());
        }
        Set<String> domainPrefixes = this.getPrefixesCtx().keySet();
        ArrayList<String> prefixesFiltered = new ArrayList<String>();
        for (String prefix : this.getPrefixesCtx("").keySet()) {
            if (domainPrefixes.contains(prefix)) continue;
            prefixesFiltered.add(prefix);
        }
        prefixesFiltered.addAll(domainPrefixes);
        return Collections.unmodifiableCollection(prefixesFiltered);
    }

    @Override
    public void addURI(String uri) {
        if (this.getUrisCtx().contains(uri)) {
            throw new NamespaceException("URI " + uri + " has already been defined");
        }
        this.getUrisCtx().add(uri);
    }

    @Override
    public void addPrefix(String prefix, String uri) {
        if (!this.getUrisCtx().contains(uri)) {
            throw new NamespaceException("Namespace URI " + uri + " does not exist");
        }
        this.getPrefixesCtx().put(prefix, uri);
    }

    @Override
    public void removeURI(String uri) {
        this.getUrisCtx().remove(uri);
    }

    @Override
    public void removePrefix(String prefix) {
        this.getPrefixesCtx().remove(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (!this.tenantService.isTenantUser()) {
            return this.getPrefixesCtx().get(prefix);
        }
        String uri = this.getPrefixesCtx().get(prefix);
        if (uri != null) {
            return uri;
        }
        return this.getPrefixesCtx("").get(prefix);
    }

    @Override
    public Collection<String> getPrefixes(String URI) {
        if (!this.tenantService.isTenantUser()) {
            ArrayList<String> uriPrefixes = new ArrayList<String>();
            for (String key : this.getPrefixesCtx().keySet()) {
                String uri = this.getPrefixesCtx().get(key);
                if (uri == null || !uri.equals(URI)) continue;
                uriPrefixes.add(key);
            }
            return uriPrefixes;
        }
        ArrayList<String> domainUriPrefixes = new ArrayList<String>();
        for (String key : this.getPrefixesCtx().keySet()) {
            String uri = this.getPrefixesCtx().get(key);
            if (uri == null || !uri.equals(URI)) continue;
            domainUriPrefixes.add(key);
        }
        ArrayList<String> uriPrefixes = new ArrayList<String>();
        for (String key : this.getPrefixesCtx("").keySet()) {
            String uri = this.getPrefixesCtx("").get(key);
            if (uri == null || !uri.equals(URI) || domainUriPrefixes != null && domainUriPrefixes.contains(key)) continue;
            uriPrefixes.add(key);
        }
        if (domainUriPrefixes != null) {
            uriPrefixes.addAll(domainUriPrefixes);
        }
        return uriPrefixes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamespaceRegistry getNamespaceRegistry(String tenantDomain) {
        NamespaceRegistry namespaceRegistry = null;
        namespaceRegistry = this.getNamespaceRegistryLocal(tenantDomain);
        if (namespaceRegistry != null) {
            return namespaceRegistry;
        }
        try {
            String currentUserDomain = this.tenantService.getCurrentUserDomain();
            if (currentUserDomain.equals(tenantDomain)) {
                this.dictionaryDAO.init();
            } else {
                AuthenticationUtil.runAs(new AuthenticationUtil.RunAsWork<Void>(){

                    @Override
                    public Void doWork() throws Exception {
                        NamespaceDAOImpl.this.dictionaryDAO.init();
                        return null;
                    }
                }, this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
            }
            namespaceRegistry = this.getNamespaceRegistryLocal(tenantDomain);
            if (namespaceRegistry != null) {
                NamespaceRegistry namespaceRegistry2 = namespaceRegistry;
                return namespaceRegistry2;
            }
        }
        finally {
            this.removeNamespaceLocal(tenantDomain);
        }
        throw new IllegalStateException("dictionaryDAO.init() called, yet no namespace registry for domain " + tenantDomain);
    }

    private NamespaceRegistry createNamespaceLocal(String tenantDomain) {
        NamespaceRegistry namespaceRegistry = this.getNamespaceRegistryLocal(tenantDomain);
        if (namespaceRegistry == null) {
            namespaceRegistry = new NamespaceRegistry(tenantDomain);
            if (tenantDomain.equals("")) {
                this.defaultNamespaceRegistryThreadLocal.set(namespaceRegistry);
            } else {
                this.namespaceRegistryThreadLocal.set(namespaceRegistry);
            }
        }
        return namespaceRegistry;
    }

    private NamespaceRegistry getNamespaceRegistryLocal(String tenantDomain) {
        NamespaceRegistry namespaceRegistry = null;
        namespaceRegistry = tenantDomain.equals("") ? this.defaultNamespaceRegistryThreadLocal.get() : this.namespaceRegistryThreadLocal.get();
        if (namespaceRegistry != null && tenantDomain.equals(namespaceRegistry.getTenantDomain())) {
            return namespaceRegistry;
        }
        return null;
    }

    private void removeNamespaceLocal(String tenantDomain) {
        if (tenantDomain.equals("")) {
            this.defaultNamespaceRegistryThreadLocal.set(null);
        } else {
            this.defaultNamespaceRegistryThreadLocal.set(null);
            this.namespaceRegistryThreadLocal.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNamespaceRegistry(String tenantDomain) {
        try {
            this.writeLock.lock();
            if (this.namespaceRegistryCache.get(tenantDomain) != null) {
                this.namespaceRegistryCache.remove(tenantDomain);
            }
            this.removeNamespaceLocal(tenantDomain);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private List<String> getUrisCtx() {
        return this.getUrisCtx(this.getTenantDomain());
    }

    private List<String> getUrisCtx(String tenantDomain) {
        if (!AuthenticationUtil.isMtEnabled() || !tenantDomain.equals("")) {
            return this.getNamespaceRegistry(tenantDomain).getUrisCache();
        }
        return AuthenticationUtil.runAs(new AuthenticationUtil.RunAsWork<List<String>>(){

            @Override
            public List<String> doWork() {
                return NamespaceDAOImpl.this.getNamespaceRegistry("").getUrisCache();
            }
        }, AuthenticationUtil.getSystemUserName() + "@");
    }

    private Map<String, String> getPrefixesCtx() {
        return this.getPrefixesCtx(this.getTenantDomain());
    }

    private Map<String, String> getPrefixesCtx(String tenantDomain) {
        if (!AuthenticationUtil.isMtEnabled() || !tenantDomain.equals("")) {
            return this.getNamespaceRegistry(tenantDomain).getPrefixesCache();
        }
        return AuthenticationUtil.runAs(new AuthenticationUtil.RunAsWork<Map<String, String>>(){

            @Override
            public Map<String, String> doWork() {
                return NamespaceDAOImpl.this.getNamespaceRegistry("").getPrefixesCache();
            }
        }, AuthenticationUtil.getSystemUserName() + "@");
    }

    private String getTenantDomain() {
        return this.tenantService.getCurrentUserDomain();
    }

    public class NamespaceRegistry {
        private List<String> urisCache = new ArrayList<String>(0);
        private Map<String, String> prefixesCache = new HashMap<String, String>(0);
        private String tenantDomain;

        public NamespaceRegistry(String tenantDomain) {
            this.tenantDomain = tenantDomain;
        }

        public String getTenantDomain() {
            return this.tenantDomain;
        }

        public List<String> getUrisCache() {
            return this.urisCache;
        }

        public void setUrisCache(List<String> urisCache) {
            this.urisCache = urisCache;
        }

        public Map<String, String> getPrefixesCache() {
            return this.prefixesCache;
        }

        public void setPrefixesCache(Map<String, String> prefixesCache) {
            this.prefixesCache = prefixesCache;
        }
    }
}

