/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.impl.BaseConjunction;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class LuceneConjunction
extends BaseConjunction
implements LuceneQueryBuilderComponent {
    public LuceneConjunction(List<Constraint> constraints) {
        super(constraints);
    }

    @Override
    public Query addComponent(Set<String> selectors, Map<String, Argument> functionArgs, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) throws ParseException {
        BooleanQuery query = new BooleanQuery();
        boolean must = false;
        boolean should = false;
        boolean must_not = false;
        for (Constraint constraint : this.getConstraints()) {
            if (constraint instanceof LuceneQueryBuilderComponent) {
                LuceneQueryBuilderComponent luceneQueryBuilderComponent = (LuceneQueryBuilderComponent)((Object)constraint);
                Query constraintQuery = luceneQueryBuilderComponent.addComponent(selectors, functionArgs, luceneContext, functionContext);
                if (constraintQuery != null) {
                    constraintQuery.setBoost(constraint.getBoost());
                    switch (constraint.getOccur()) {
                        case DEFAULT: 
                        case MANDATORY: {
                            query.add(constraintQuery, BooleanClause.Occur.MUST);
                            must = true;
                            break;
                        }
                        case OPTIONAL: {
                            query.add(constraintQuery, BooleanClause.Occur.SHOULD);
                            should = true;
                            break;
                        }
                        case EXCLUDE: {
                            query.add(constraintQuery, BooleanClause.Occur.MUST_NOT);
                            must_not = true;
                        }
                    }
                }
            } else {
                throw new UnsupportedOperationException();
            }
            if (must || !must_not) continue;
            query.add((Query)new TermQuery(new Term("ISNODE", "T")), BooleanClause.Occur.MUST);
        }
        return query;
    }
}

