/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene;

import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.LuceneAnalyser;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.apache.lucene.index.IndexReader;

public class LuceneQueryBuilderContextImpl
implements LuceneQueryBuilderContext {
    private LuceneQueryParser lqp;
    private NamespacePrefixResolver namespacePrefixResolver;

    public LuceneQueryBuilderContextImpl(DictionaryService dictionaryService, NamespacePrefixResolver namespacePrefixResolver, TenantService tenantService, SearchParameters searchParameters, MLAnalysisMode defaultSearchMLAnalysisMode, IndexReader indexReader) {
        LuceneAnalyser analyzer = new LuceneAnalyser(dictionaryService, searchParameters.getMlAnalaysisMode() == null ? defaultSearchMLAnalysisMode : searchParameters.getMlAnalaysisMode());
        this.lqp = new LuceneQueryParser(searchParameters.getDefaultFieldName(), analyzer);
        this.lqp.setDefaultOperator(AbstractLuceneQueryParser.OR_OPERATOR);
        this.lqp.setDictionaryService(dictionaryService);
        this.lqp.setNamespacePrefixResolver(namespacePrefixResolver);
        this.lqp.setTenantService(tenantService);
        this.lqp.setSearchParameters(searchParameters);
        this.lqp.setDefaultSearchMLAnalysisMode(defaultSearchMLAnalysisMode);
        this.lqp.setIndexReader(indexReader);
        this.lqp.setAllowLeadingWildcard(true);
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    @Override
    public AbstractLuceneQueryParser getLuceneQueryParser() {
        return this.lqp;
    }

    @Override
    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.namespacePrefixResolver;
    }
}

