/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.impl.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import org.alfresco.deployment.FileDescriptor;
import org.alfresco.deployment.FileType;
import org.alfresco.deployment.impl.DeploymentException;
import org.alfresco.deployment.impl.server.DeployedFile;
import org.alfresco.deployment.impl.server.Deployment;
import org.alfresco.deployment.impl.server.DirectoryMetaData;
import org.alfresco.deployment.util.Path;
import org.alfresco.util.Deleter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Target
implements Serializable {
    private static final long serialVersionUID = 7759718377782991626L;
    private static final String MD_NAME = ".md.";
    private static final String CLONE = "clone";
    private static final String OLD = "old";
    private boolean busy = false;
    private static Log logger = LogFactory.getLog(Target.class);
    private String fTargetName;
    private String fMetaDataDirectory;
    private MetadataCache metadataCache = new MetadataCache();

    public Target(String name, String metadataDirectory) {
        File metaRoot;
        this.fTargetName = name;
        this.fMetaDataDirectory = metadataDirectory;
        File meta = new File(this.fMetaDataDirectory);
        if (!meta.exists()) {
            logger.info((Object)("Initialised empty metadata for target:" + this.fTargetName));
            if (!meta.mkdir()) {
                throw new DeploymentException("Could not create meta data directory: " + this.fMetaDataDirectory);
            }
        }
        if (!(metaRoot = new File(this.fMetaDataDirectory + File.separatorChar + MD_NAME)).exists()) {
            DirectoryMetaData md = new DirectoryMetaData();
            this.putDirectory(this.fMetaDataDirectory + File.separatorChar + MD_NAME, md);
        }
    }

    public boolean validateMetaData(String rootDir, boolean autoFix) {
        File dir = new File(rootDir);
        return this.validateMetaData(this.fMetaDataDirectory, dir, autoFix);
    }

    private boolean validateMetaData(String metaDir, File destDir, boolean fixit) {
        boolean error = false;
        String metaFileName = metaDir + File.separatorChar + MD_NAME;
        try {
            DirectoryMetaData meta = this.getDirectory(metaFileName);
            File[] srcList = destDir.listFiles();
            HashMap<String, File> srcMap = new HashMap<String, File>(srcList.length);
            for (int i = 0; i < srcList.length; ++i) {
                srcMap.put(srcList[i].getName(), srcList[i]);
            }
            SortedSet<FileDescriptor> metaList = meta.getListing();
            HashSet<FileDescriptor> toRemove = new HashSet<FileDescriptor>();
            boolean modified = false;
            for (FileDescriptor descriptor : metaList) {
                File child = (File)srcMap.get(descriptor.getName());
                if (child != null) {
                    if (child.isDirectory() != (descriptor.getType() == FileType.DIR)) {
                        error = true;
                        logger.warn((Object)("mismatch on file file or directory for path:" + descriptor.getName()));
                        if (fixit) {
                            toRemove.add(descriptor);
                            modified = true;
                        }
                    }
                    if (!child.isDirectory()) continue;
                    boolean val = this.validateMetaData(metaDir + File.separatorChar + descriptor.getName(), child, fixit);
                    boolean bl = error = val || error;
                    if (!val || !fixit) continue;
                    descriptor.setGuid("None");
                    modified = true;
                    continue;
                }
                error = true;
                logger.warn((Object)("missing file or directory for path:" + descriptor.getName()));
                if (!fixit) continue;
                toRemove.add(descriptor);
                modified = true;
            }
            if (modified) {
                for (FileDescriptor desc : toRemove) {
                    meta.remove(desc);
                }
                logger.warn((Object)("autofix: replaced metadata for dir:" + metaDir));
                this.putDirectory(metaFileName, meta);
            }
        }
        catch (DeploymentException de) {
            error = true;
            if (fixit) {
                logger.warn((Object)("metadata is unreadable.  Replaced metadata for target: " + this.fTargetName + ", metaDir:" + metaDir), (Throwable)((Object)de));
                this.putDirectory(metaFileName, new DirectoryMetaData());
            }
            logger.error((Object)("metadata is unreadable. metaDir:" + metaDir), (Throwable)((Object)de));
        }
        return error;
    }

    public String getName() {
        return this.fTargetName;
    }

    public String getMetaDataDirectory() {
        return this.fMetaDataDirectory;
    }

    public FileDescriptor lookupMetadataFile(String path, String fileName) {
        try {
            SortedSet<FileDescriptor> list = this.getListing(path);
            for (FileDescriptor file : list) {
                if (!file.getName().equals(fileName)) continue;
                logger.debug((Object)"lookupMetadataFile : found file in metadata");
                return file;
            }
            logger.debug((Object)"lookupMetadataFile : not found metadata : return null");
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public SortedSet<FileDescriptor> getListing(String path) {
        SortedSet<FileDescriptor> val = this.metadataCache.lookup(path);
        if (val != null) {
            return val;
        }
        Path cPath = new Path(path);
        StringBuilder builder = new StringBuilder();
        builder.append(this.fMetaDataDirectory);
        if (cPath.size() != 0) {
            for (int i = 0; i < cPath.size(); ++i) {
                builder.append(File.separatorChar);
                builder.append(cPath.get(i));
            }
        }
        builder.append(File.separatorChar);
        builder.append(MD_NAME);
        String mdPath = builder.toString();
        val = this.getDirectory(mdPath).getListing();
        return this.metadataCache.put(path, val);
    }

    public void cloneMetaData(Deployment deployment) {
        this.metadataCache.clear();
        String currentmd = null;
        DirectoryMetaData md = null;
        block6: for (DeployedFile file : deployment) {
            String mdName;
            Path path = new Path(file.getPath());
            Path parent = path.getParent();
            String parentPath = "";
            if (parent != null) {
                parentPath = parent.toString() + File.separatorChar;
            }
            if (!(mdName = this.fMetaDataDirectory + File.separatorChar + parentPath + MD_NAME).equals(currentmd)) {
                if (md != null) {
                    this.putDirectory(currentmd + CLONE, md);
                }
                File metaFile = new File(mdName);
                File cloneFile = new File(mdName + CLONE);
                File parentDir = new File(metaFile.getParent());
                if (cloneFile.exists()) {
                    md = this.getDirectory(cloneFile.getPath());
                } else if (metaFile.exists()) {
                    md = this.getDirectory(metaFile.getPath());
                } else {
                    parentDir.mkdirs();
                    md = new DirectoryMetaData();
                }
                currentmd = mdName;
            }
            switch (file.getType()) {
                case FILE: {
                    FileDescriptor fd = new FileDescriptor(path.getBaseName(), FileType.FILE, file.getGuid());
                    md.remove(fd);
                    md.add(fd);
                    continue block6;
                }
                case DIR: {
                    FileDescriptor fd = new FileDescriptor(path.getBaseName(), FileType.DIR, file.getGuid());
                    md.remove(fd);
                    md.add(fd);
                    String newDirPath = this.fMetaDataDirectory + File.separatorChar + path.toString();
                    File newDir = new File(newDirPath);
                    newDir.mkdir();
                    DirectoryMetaData newMD = new DirectoryMetaData();
                    this.putDirectory(newDirPath + File.separatorChar + MD_NAME + CLONE, newMD);
                    continue block6;
                }
                case DELETED: {
                    FileDescriptor toRemove = new FileDescriptor(path.getBaseName(), FileType.DELETED, null);
                    md.remove(toRemove);
                    continue block6;
                }
                case SETGUID: {
                    FileDescriptor toModify = new FileDescriptor(path.getBaseName(), null, null);
                    SortedSet<FileDescriptor> tail = md.getListing().tailSet(toModify);
                    if (tail.size() != 0 && (toModify = tail.first()).getName().equals(path.getBaseName())) {
                        toModify.setGuid(file.getGuid());
                        continue block6;
                    }
                    throw new DeploymentException("Trying to set guid on non existent file " + path);
                }
            }
            throw new DeploymentException("Configuration Error: unknown FileType " + file.getType());
        }
        if (md != null) {
            this.putDirectory(currentmd + CLONE, md);
        }
    }

    private DirectoryMetaData getDirectory(String path) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(path));
            DirectoryMetaData md = (DirectoryMetaData)in.readObject();
            in.close();
            return md;
        }
        catch (IOException ioe) {
            throw new DeploymentException("Could not read metadata file " + path, ioe);
        }
        catch (ClassNotFoundException nfe) {
            throw new DeploymentException("Configuration error: could not instantiate DirectoryMetaData.");
        }
    }

    private void putDirectory(String path, DirectoryMetaData md) {
        try {
            FileOutputStream fout = new FileOutputStream(path);
            ObjectOutputStream out = new ObjectOutputStream(fout);
            out.writeObject(md);
            out.flush();
            fout.getChannel().force(true);
            out.close();
        }
        catch (IOException ioe) {
            throw new DeploymentException("Could not write metadata path:" + path, ioe);
        }
    }

    public void rollbackMetaData() {
        this.recursiveRollbackMetaData(this.fMetaDataDirectory);
    }

    public void commitMetaData(Deployment deployment) {
        this.metadataCache.clear();
        HashSet<String> toCommit = new HashSet<String>();
        for (DeployedFile file : deployment) {
            Path path = new Path(file.getPath());
            if (file.getType() == FileType.DIR) {
                toCommit.add(this.fMetaDataDirectory + File.separatorChar + path.toString() + File.separatorChar + MD_NAME);
            }
            String parent = this.fMetaDataDirectory + File.separatorChar + path.getParent().toString() + File.separatorChar + MD_NAME;
            toCommit.add(parent);
        }
        for (String path : toCommit) {
            File original = new File(path);
            File old = new File(path + OLD);
            if (original.exists() && !original.renameTo(old)) {
                throw new DeploymentException("Could not rename meta data file " + path);
            }
            File clone = new File(path + CLONE);
            clone.renameTo(original);
            old.delete();
        }
    }

    private void recursiveRollbackMetaData(String dir) {
        File[] listing;
        this.metadataCache.clear();
        String mdName = dir + File.separatorChar + MD_NAME;
        String clone = mdName + CLONE;
        File dClone = new File(clone);
        dClone.delete();
        DirectoryMetaData md = this.getDirectory(mdName);
        SortedSet<FileDescriptor> mdListing = md.getListing();
        File dDir = new File(dir);
        for (File entry : listing = dDir.listFiles()) {
            FileDescriptor dummy;
            if (!entry.isDirectory() || mdListing.contains(dummy = new FileDescriptor(entry.getName(), null, null))) continue;
            Deleter.Delete((File)entry);
        }
        for (File entry : listing = dDir.listFiles()) {
            if (!entry.isDirectory()) continue;
            this.recursiveRollbackMetaData(dir + File.separatorChar + entry.getName());
        }
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public boolean isBusy() {
        return this.busy;
    }

    private class MetadataCache {
        Map<String, SortedSet<FileDescriptor>> internalMap = Collections.synchronizedMap(new HashMap(10));

        private MetadataCache() {
        }

        SortedSet<FileDescriptor> lookup(String path) {
            return this.internalMap.get(path);
        }

        SortedSet<FileDescriptor> put(String path, SortedSet<FileDescriptor> listing) {
            if (this.internalMap.size() > 10) {
                this.clear();
            }
            this.internalMap.put(path, listing);
            return listing;
        }

        void clear() {
            this.internalMap.clear();
        }
    }
}

