/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpProtocol
extends AbstractAjpProtocol {
    private static final Log log = LogFactory.getLog(AjpProtocol.class);
    private AjpConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public AjpProtocol() {
        this.endpoint = new JIoEndpoint();
        this.cHandler = new AjpConnectionHandler(this);
        ((JIoEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
    }

    @Override
    protected String getNamePrefix() {
        return "ajp-bio";
    }

    protected static class AjpConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler
    implements JIoEndpoint.Handler {
        protected AjpProtocol proto;
        protected ConcurrentHashMap<SocketWrapper<Socket>, AjpProcessor> connections = new ConcurrentHashMap();
        protected AbstractProtocol.RecycledProcessors<AjpProcessor> recycledProcessors = new AbstractProtocol.RecycledProcessors(this);

        public AjpConnectionHandler(AjpProtocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return null;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socket) {
            return this.process(socket, SocketStatus.OPEN);
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socket, SocketStatus status) {
            AjpProcessor processor = this.connections.remove(socket);
            try {
                AbstractEndpoint.Handler.SocketState state;
                if (processor == null) {
                    processor = (AjpProcessor)this.recycledProcessors.poll();
                }
                if (processor == null) {
                    processor = this.createProcessor();
                }
                AbstractEndpoint.Handler.SocketState socketState = state = socket.isAsync() ? processor.asyncDispatch(status) : processor.process(socket);
                if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    socket.setAsync(true);
                    return processor.asyncPostProcess();
                }
                socket.setAsync(false);
                processor.recycle();
                this.recycledProcessors.offer(processor);
                return state;
            }
            catch (SocketException e) {
                log.debug((Object)AbstractAjpProtocol.sm.getString("ajpprotocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)AbstractAjpProtocol.sm.getString("ajpprotocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                log.error((Object)AbstractAjpProtocol.sm.getString("ajpprotocol.proto.error"), e);
            }
            processor.recycle();
            this.recycledProcessors.offer(processor);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        protected AjpProcessor createProcessor() {
            AjpProcessor processor = new AjpProcessor(this.proto.packetSize, (JIoEndpoint)this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            processor.setRequiredSecret(this.proto.requiredSecret);
            processor.setKeepAliveTimeout(this.proto.getKeepAliveTimeout());
            processor.setClientCertProvider(this.proto.getClientCertProvider());
            this.register(processor);
            return processor;
        }
    }
}

