/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.nio.channels.SelectionKey;
import java.util.Locale;
import javax.net.ssl.SSLEngine;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalNioInputBuffer;
import org.apache.coyote.http11.InternalNioOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SocketStatus;

public class Http11NioProcessor
extends AbstractHttp11Processor {
    private static final Log log = LogFactory.getLog(Http11NioProcessor.class);
    protected SSLSupport sslSupport;
    protected InternalNioInputBuffer inputBuffer = null;
    protected InternalNioOutputBuffer outputBuffer = null;
    protected NioEndpoint.SendfileData sendfileData = null;
    protected boolean comet = false;
    protected boolean cometClose = false;
    protected NioChannel socket = null;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11NioProcessor(int maxHttpHeaderSize, NioEndpoint endpoint, int maxTrailerSize) {
        this.endpoint = endpoint;
        this.request = new Request();
        this.inputBuffer = new InternalNioInputBuffer(this.request, maxHttpHeaderSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.response = new Response();
        this.response.setHook(this);
        this.outputBuffer = new InternalNioOutputBuffer(this.response, maxHttpHeaderSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters(maxTrailerSize);
        HexUtils.load();
    }

    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        long soTimeout = this.endpoint.getSoTimeout();
        int keepAliveTimeout = this.endpoint.getKeepAliveTimeout();
        RequestInfo rp = this.request.getRequestProcessor();
        NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
        try {
            rp.setStage(3);
            boolean bl = this.error = !this.adapter.event(this.request, this.response, status);
            if (!this.error && attach != null) {
                attach.setComet(this.comet);
                if (this.comet) {
                    Integer comettimeout = (Integer)this.request.getAttribute("org.apache.tomcat.comet.timeout");
                    if (comettimeout != null) {
                        attach.setTimeout(comettimeout.longValue());
                    }
                } else if (this.keepAlive && keepAliveTimeout > 0) {
                    attach.setTimeout(keepAliveTimeout);
                } else {
                    attach.setTimeout(soTimeout);
                }
            }
        }
        catch (InterruptedIOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("http11processor.request.process"), t);
            this.response.setStatus(500);
            this.adapter.log(this.request, this.response, 0L);
            this.error = true;
        }
        rp.setStage(7);
        if (this.error) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.comet) {
            return this.keepAlive ? AbstractEndpoint.Handler.SocketState.OPEN : AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus status) throws IOException {
        long soTimeout = this.endpoint.getSoTimeout();
        int keepAliveTimeout = this.endpoint.getKeepAliveTimeout();
        RequestInfo rp = this.request.getRequestProcessor();
        NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
        try {
            rp.setStage(3);
            boolean bl = this.error = !this.adapter.asyncDispatch(this.request, this.response, status);
            if (!this.error && attach != null) {
                attach.setComet(this.comet);
                if (this.comet) {
                    Integer comettimeout = (Integer)this.request.getAttribute("org.apache.tomcat.comet.timeout");
                    if (comettimeout != null) {
                        attach.setTimeout(comettimeout.longValue());
                    }
                } else if (this.asyncStateMachine.isAsyncDispatching()) {
                    if (this.keepAlive && keepAliveTimeout > 0) {
                        attach.setTimeout(keepAliveTimeout);
                    } else {
                        attach.setTimeout(soTimeout);
                    }
                }
            }
        }
        catch (InterruptedIOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("http11processor.request.process"), t);
            this.response.setStatus(500);
            this.adapter.log(this.request, this.response, 0L);
            this.error = true;
        }
        rp.setStage(7);
        if (this.error) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.comet && !this.isAsync()) {
            return this.keepAlive ? AbstractEndpoint.Handler.SocketState.OPEN : AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    public AbstractEndpoint.Handler.SocketState process(NioChannel socket) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.socket = socket;
        this.inputBuffer.setSocket(socket);
        this.outputBuffer.setSocket(socket);
        this.inputBuffer.setSelectorPool(((NioEndpoint)this.endpoint).getSelectorPool());
        this.outputBuffer.setSelectorPool(((NioEndpoint)this.endpoint).getSelectorPool());
        this.error = false;
        this.keepAlive = true;
        this.comet = false;
        long soTimeout = this.endpoint.getSoTimeout();
        int keepAliveTimeout = this.endpoint.getKeepAliveTimeout();
        boolean keptAlive = false;
        boolean openSocket = false;
        boolean readComplete = true;
        NioEndpoint.KeyAttachment ka = (NioEndpoint.KeyAttachment)socket.getAttachment(false);
        while (!(this.error || !this.keepAlive || this.comet || this.isAsync() || this.endpoint.isPaused())) {
            SelectionKey key;
            ka.setTimeout(soTimeout);
            try {
                if (!this.disableUploadTimeout && keptAlive && soTimeout > 0L) {
                    socket.getIOChannel().socket().setSoTimeout((int)soTimeout);
                }
                if (!this.inputBuffer.parseRequestLine(keptAlive)) {
                    openSocket = true;
                    if (this.inputBuffer.getParsingRequestLinePhase() < 2) {
                        if (keepAliveTimeout > 0) {
                            ka.setTimeout(keepAliveTimeout);
                        }
                    } else {
                        readComplete = false;
                    }
                    if (!this.endpoint.isPaused()) break;
                    this.response.setStatus(503);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
                if (!this.endpoint.isPaused()) {
                    keptAlive = true;
                    if (!this.inputBuffer.parseHeaders()) {
                        openSocket = true;
                        readComplete = false;
                        break;
                    }
                    this.request.setStartTime(System.currentTimeMillis());
                    if (!this.disableUploadTimeout) {
                        socket.getIOChannel().socket().setSoTimeout(this.connectionUploadTimeout);
                    }
                }
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("http11processor.header.parse"), (Throwable)e);
                }
                this.error = true;
                break;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("http11processor.header.parse"), t);
                }
                this.response.setStatus(400);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            if (!this.error) {
                rp.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("http11processor.request.prepare"), t);
                    }
                    this.response.setStatus(400);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            if (this.maxKeepAliveRequests == 1) {
                this.keepAlive = false;
            }
            if (this.maxKeepAliveRequests > 0 && ka.decrementKeepAlive() <= 0) {
                this.keepAlive = false;
            }
            if (!this.error) {
                try {
                    NioEndpoint.KeyAttachment attach;
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                    if (this.keepAlive && !this.error) {
                        boolean bl = this.error = this.response.getErrorException() != null || !this.isAsync() && this.statusDropsConnection(this.response.getStatus());
                    }
                    if ((key = socket.getIOChannel().keyFor(socket.getPoller().getSelector())) != null && (attach = (NioEndpoint.KeyAttachment)key.attachment()) != null) {
                        Integer comettimeout;
                        attach.setComet(this.comet);
                        if (this.comet && (comettimeout = (Integer)this.request.getAttribute("org.apache.tomcat.comet.timeout")) != null) {
                            attach.setTimeout(comettimeout.longValue());
                        }
                    }
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    log.error((Object)sm.getString("http11processor.request.process"), t);
                    this.response.setStatus(500);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            if (!this.comet && !this.isAsync()) {
                if (this.error) {
                    this.inputBuffer.setSwallowInput(false);
                }
                this.endRequest();
            }
            if (this.error) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            if (!this.comet && !this.isAsync()) {
                this.inputBuffer.nextRequest();
                this.outputBuffer.nextRequest();
            }
            if (this.sendfileData != null && !this.error) {
                ka.setSendfileData(this.sendfileData);
                this.sendfileData.keepAlive = this.keepAlive;
                key = socket.getIOChannel().keyFor(socket.getPoller().getSelector());
                openSocket = socket.getPoller().processSendfile(key, ka, true, true);
                break;
            }
            rp.setStage(6);
        }
        rp.setStage(7);
        if (this.error || this.endpoint.isPaused()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.comet || this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        return openSocket ? (readComplete ? AbstractEndpoint.Handler.SocketState.OPEN : AbstractEndpoint.Handler.SocketState.LONG) : AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    public void recycleInternal() {
        this.socket = null;
        this.cometClose = false;
        this.comet = false;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localAddr = null;
        this.localName = null;
        this.remotePort = -1;
        this.localPort = -1;
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.CLOSE) {
            NioEndpoint.KeyAttachment attach;
            this.comet = false;
            this.cometClose = true;
            SelectionKey key = this.socket.getIOChannel().keyFor(this.socket.getPoller().getSelector());
            if (key == null || (attach = (NioEndpoint.KeyAttachment)key.attachment()) == null || attach.getComet()) {
                // empty if block
            }
            try {
                this.outputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.REQ_HOST_ADDR_ATTRIBUTE) {
            InetAddress inetAddr;
            if (this.remoteAddr == null && this.socket != null && (inetAddr = this.socket.getIOChannel().socket().getInetAddress()) != null) {
                this.remoteAddr = inetAddr.getHostAddress();
            }
            this.request.remoteAddr().setString(this.remoteAddr);
        } else if (actionCode == ActionCode.REQ_LOCAL_NAME_ATTRIBUTE) {
            InetAddress inetAddr;
            if (this.localName == null && this.socket != null && (inetAddr = this.socket.getIOChannel().socket().getLocalAddress()) != null) {
                this.localName = inetAddr.getHostName();
            }
            this.request.localName().setString(this.localName);
        } else if (actionCode == ActionCode.REQ_HOST_ATTRIBUTE) {
            if (this.remoteHost == null && this.socket != null) {
                InetAddress inetAddr = this.socket.getIOChannel().socket().getInetAddress();
                if (inetAddr != null) {
                    this.remoteHost = inetAddr.getHostName();
                }
                if (this.remoteHost == null) {
                    if (this.remoteAddr != null) {
                        this.remoteHost = this.remoteAddr;
                    } else {
                        this.request.remoteHost().recycle();
                    }
                }
            }
            this.request.remoteHost().setString(this.remoteHost);
        } else if (actionCode == ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE) {
            if (this.localAddr == null) {
                this.localAddr = this.socket.getIOChannel().socket().getLocalAddress().getHostAddress();
            }
            this.request.localAddr().setString(this.localAddr);
        } else if (actionCode == ActionCode.REQ_REMOTEPORT_ATTRIBUTE) {
            if (this.remotePort == -1 && this.socket != null) {
                this.remotePort = this.socket.getIOChannel().socket().getPort();
            }
            this.request.setRemotePort(this.remotePort);
        } else if (actionCode == ActionCode.REQ_LOCALPORT_ATTRIBUTE) {
            if (this.localPort == -1 && this.socket != null) {
                this.localPort = this.socket.getIOChannel().socket().getLocalPort();
            }
            this.request.setLocalPort(this.localPort);
        } else if (actionCode == ActionCode.REQ_SSL_ATTRIBUTE) {
            try {
                if (this.sslSupport != null) {
                    Object sslO = this.sslSupport.getCipherSuite();
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                    }
                    this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
                }
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
            }
        } else if (actionCode == ActionCode.REQ_SSL_CERTIFICATE) {
            if (this.sslSupport != null) {
                InputFilter[] inputFilters = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilters[3]);
                SecureNioChannel sslChannel = (SecureNioChannel)this.socket;
                SSLEngine engine = sslChannel.getSslEngine();
                if (!engine.getNeedClientAuth()) {
                    engine.setNeedClientAuth(true);
                    try {
                        sslChannel.rehandshake(this.endpoint.getSoTimeout());
                        this.sslSupport = ((NioEndpoint)this.endpoint).getHandler().getSslImplementation().getSSLSupport(engine.getSession());
                    }
                    catch (IOException ioe) {
                        log.warn((Object)sm.getString("http11processor.socket.sslreneg", ioe));
                    }
                }
                try {
                    Object[] sslO = this.sslSupport.getPeerCertificateChain(false);
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
            }
        } else if (actionCode == ActionCode.AVAILABLE) {
            this.request.setAvailable(this.inputBuffer.available());
        } else if (actionCode == ActionCode.COMET_BEGIN) {
            this.comet = true;
        } else if (actionCode == ActionCode.COMET_END) {
            this.comet = false;
        } else if (actionCode == ActionCode.COMET_CLOSE) {
            if (this.socket == null || this.socket.getAttachment(false) == null) {
                return;
            }
            NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
            attach.setCometOps(512);
            RequestInfo rp = this.request.getRequestProcessor();
            if (rp.getStage() != 3) {
                this.socket.getPoller().add(this.socket);
            }
        } else if (actionCode == ActionCode.COMET_SETTIMEOUT) {
            if (param == null) {
                return;
            }
            if (this.socket == null || this.socket.getAttachment(false) == null) {
                return;
            }
            NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
            long timeout = (Long)param;
            RequestInfo rp = this.request.getRequestProcessor();
            if (rp.getStage() != 3) {
                attach.setTimeout(timeout);
            }
        } else if (actionCode == ActionCode.ASYNC_COMPLETE) {
            if (this.asyncStateMachine.asyncComplete()) {
                ((NioEndpoint)this.endpoint).processSocket(this.socket, SocketStatus.OPEN, true);
            }
        } else if (actionCode == ActionCode.ASYNC_SETTIMEOUT) {
            if (param == null) {
                return;
            }
            if (this.socket == null || this.socket.getAttachment(false) == null) {
                return;
            }
            NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
            long timeout = (Long)param;
            attach.setTimeout(timeout);
        } else if (actionCode == ActionCode.ASYNC_DISPATCH && this.asyncStateMachine.asyncDispatch()) {
            ((NioEndpoint)this.endpoint).processSocket(this.socket, SocketStatus.OPEN, true);
        }
    }

    protected void prepareRequest() {
        long contentLength;
        ByteChunk uriBC;
        MessageBytes userAgentValueMB;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        this.expectation = false;
        this.sendfileData = null;
        if (this.endpoint.isSSLEnabled()) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.error = true;
            this.response.setStatus(505);
            this.adapter.log(this.request, this.response, 0L);
        }
        MessageBytes methodMB = this.request.method();
        if (methodMB.equals("GET")) {
            methodMB.setString("GET");
        } else if (methodMB.equals("POST")) {
            methodMB.setString("POST");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
            } else if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
            }
        }
        MessageBytes expectMB = null;
        if (this.http11) {
            expectMB = headers.getValue("expect");
        }
        if (expectMB != null && expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
            this.inputBuffer.setSwallowInput(false);
            this.expectation = true;
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive) && (userAgentValueMB = headers.getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            if (this.restrictedUserAgents != null && this.restrictedUserAgents.matcher(userAgentValue).matches()) {
                this.http11 = false;
                this.keepAlive = false;
            }
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = headers.getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos).toLowerCase(Locale.ENGLISH).trim();
                if (!this.addInputFilter(inputFilters, encodingName)) {
                    this.error = true;
                    this.response.setStatus(501);
                    this.adapter.log(this.request, this.response, 0L);
                }
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos).toLowerCase(Locale.ENGLISH).trim();
            if (!this.addInputFilter(inputFilters, encodingName)) {
                this.error = true;
                this.response.setStatus(501);
                this.adapter.log(this.request, this.response, 0L);
            }
        }
        if ((contentLength = this.request.getContentLengthLong()) >= 0L && !this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[0]);
            this.contentDelimitation = true;
        }
        MessageBytes valueMB = headers.getValue("host");
        if (this.http11 && valueMB == null) {
            this.error = true;
            this.response.setStatus(400);
            this.adapter.log(this.request, this.response, 0L);
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
        if (this.endpoint.getUseSendfile()) {
            this.request.setAttribute("org.apache.tomcat.sendfile.support", Boolean.TRUE);
        }
        this.request.setAttribute("org.apache.tomcat.comet.support", Boolean.TRUE);
        this.request.setAttribute("org.apache.tomcat.comet.timeout.support", Boolean.TRUE);
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilters) {
        String fileName = (String)this.request.getAttribute("org.apache.tomcat.sendfile.filename");
        if (fileName != null) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
            this.sendfileData = new NioEndpoint.SendfileData();
            this.sendfileData.fileName = fileName;
            this.sendfileData.pos = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            this.sendfileData.length = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end") - this.sendfileData.pos;
            return true;
        }
        return false;
    }

    @Override
    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower(buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    @Override
    protected AbstractInputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public void setSslSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }
}

