/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.web.config.forms.ConstraintHandlerDefinition;
import org.alfresco.web.config.forms.Control;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigException;

public class FormField {
    private static final String ATTR_LABEL_ID = "label-id";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_DESCRIPTION_ID = "description-id";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_HELP_TEXT_ID = "help-id";
    private static final String ATTR_HELP_TEXT = "help";
    private static final String ATTR_SET = "set";
    private static final String ATTR_READ_ONLY = "read-only";
    private static final String ATTR_MANDATORY = "mandatory";
    private static final String ATTR_SORTED = "sorted";
    private static Log logger = LogFactory.getLog(FormField.class);
    private final String id;
    private final Map<String, String> attributes;
    private Control associatedControl = new Control();
    private final List<ConstraintHandlerDefinition> constraintDefns = new ArrayList<ConstraintHandlerDefinition>();

    public FormField(String id, Map<String, String> attributes) {
        if (id == null) {
            String msg = "Illegal null field id";
            if (logger.isWarnEnabled()) {
                logger.warn((Object)msg);
            }
            throw new ConfigException(msg);
        }
        this.id = id;
        if (attributes == null) {
            attributes = Collections.emptyMap();
        }
        this.attributes = attributes;
    }

    public Control getControl() {
        return this.associatedControl;
    }

    void addConstraintDefinition(String type, String message, String messageId, String validationHandler, String event) {
        for (ConstraintHandlerDefinition constraint : this.constraintDefns) {
            if (!constraint.getType().equals(type)) continue;
            constraint.setMessage(message);
            constraint.setMessageId(messageId);
            constraint.setValidationHandler(validationHandler);
            constraint.setEvent(event);
            return;
        }
        this.constraintDefns.add(new ConstraintHandlerDefinition(type, validationHandler, message, messageId, event));
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.attributes.get(ATTR_LABEL);
    }

    public String getLabelId() {
        return this.attributes.get(ATTR_LABEL_ID);
    }

    public String getDescription() {
        return this.attributes.get(ATTR_DESCRIPTION);
    }

    public String getDescriptionId() {
        return this.attributes.get(ATTR_DESCRIPTION_ID);
    }

    public boolean isReadOnly() {
        String disabledValue = this.attributes.get(ATTR_READ_ONLY);
        return disabledValue instanceof String && "true".equalsIgnoreCase(disabledValue);
    }

    public boolean isMandatory() {
        String mandatoryValue = this.attributes.get(ATTR_MANDATORY);
        return mandatoryValue instanceof String && "true".equalsIgnoreCase(mandatoryValue);
    }

    public boolean isSorted() {
        String sortedValue = this.attributes.get(ATTR_SORTED);
        return sortedValue instanceof String && "true".equalsIgnoreCase(sortedValue);
    }

    public String getSet() {
        String setId = this.attributes.get(ATTR_SET);
        if (setId != null) {
            return setId;
        }
        return "";
    }

    public String getHelpText() {
        return this.attributes.get(ATTR_HELP_TEXT);
    }

    public String getHelpTextId() {
        return this.attributes.get(ATTR_HELP_TEXT_ID);
    }

    public Map<String, ConstraintHandlerDefinition> getConstraintDefinitionMap() {
        LinkedHashMap<String, ConstraintHandlerDefinition> defns = new LinkedHashMap<String, ConstraintHandlerDefinition>(4);
        for (ConstraintHandlerDefinition defn : this.constraintDefns) {
            defns.put(defn.getType(), defn);
        }
        return Collections.unmodifiableMap(defns);
    }

    public FormField combine(FormField otherField) {
        Control combinedControl;
        StringBuilder msg;
        if (logger.isDebugEnabled()) {
            msg = new StringBuilder();
            msg.append("Combining instances of ").append(this);
            logger.debug((Object)msg.toString());
        }
        if (!this.id.equals(otherField.id)) {
            if (logger.isWarnEnabled()) {
                msg = new StringBuilder();
                msg.append("Illegal attempt to combine two FormFields with different IDs: ").append(this.id).append(", ").append(otherField.id);
                logger.warn((Object)msg.toString());
            }
            return this;
        }
        LinkedHashMap<String, String> combinedAttributes = new LinkedHashMap<String, String>();
        combinedAttributes.putAll(this.attributes);
        combinedAttributes.putAll(otherField.attributes);
        FormField result = new FormField(this.id, combinedAttributes);
        result.associatedControl = combinedControl = this.associatedControl.combine(otherField.associatedControl);
        for (ConstraintHandlerDefinition constraint : this.constraintDefns) {
            result.addConstraintDefinition(constraint.getType(), constraint.getMessage(), constraint.getMessageId(), constraint.getValidationHandler(), constraint.getEvent());
        }
        for (ConstraintHandlerDefinition constraint : otherField.constraintDefns) {
            result.addConstraintDefinition(constraint.getType(), constraint.getMessage(), constraint.getMessageId(), constraint.getValidationHandler(), constraint.getEvent());
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("FormField:").append(this.id);
        return result.toString();
    }
}

