/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.catalina.host;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.alfresco.catalina.context.AVMStandardContext;
import org.alfresco.catalina.host.AVMHost;
import org.alfresco.catalina.loader.AVMWebappLoader;
import org.alfresco.catalina.valve.AVMUrlValve;
import org.alfresco.jndi.AVMFileDirContext;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.remote.AVMRemote;
import org.alfresco.service.namespace.QName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.startup.HostConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMHostConfig
extends HostConfig {
    protected static Log log = LogFactory.getLog(AVMHostConfig.class);
    protected Hashtable<String, ClassLoader> context_classloader_registry_ = new Hashtable();
    protected static AVMRemote AVMRemote_ = AVMFileDirContext.getAVMRemote();
    String AVMHostRelativeAppBase_ = "avm_webapps";
    protected String contextClass = "org.alfresco.catalina.context.AVMStandardContext";

    public AVMHostConfig(String AVMHostRelativeAppBase) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AVMHostConfig: initial AVMHostRelativeAppBase: " + AVMHostRelativeAppBase));
        }
        if (AVMHostRelativeAppBase == null) {
            AVMHostRelativeAppBase = "avm_webapps";
        }
        if (AVMHostRelativeAppBase.startsWith("/")) {
            AVMHostRelativeAppBase = AVMHostRelativeAppBase.substring(1);
        }
        if (AVMHostRelativeAppBase.equals("")) {
            AVMHostRelativeAppBase = "avm_webapps";
        }
        this.AVMHostRelativeAppBase_ = AVMHostRelativeAppBase;
        if (log.isDebugEnabled()) {
            log.debug((Object)("AVMHostConfig: initial AVMHostRelativeAppBase_: " + this.AVMHostRelativeAppBase_));
        }
    }

    public void start() {
        super.start();
    }

    public void stop() {
        super.stop();
        this.context_classloader_registry_.clear();
    }

    protected void undeployApps() {
        super.undeployApps();
    }

    protected void deployApps() {
        File appBase = this.appBase();
        File configBase = this.configBase();
        this.deployDescriptors(configBase, configBase.list());
        this.deployAllAVMwebappsInRepository();
    }

    protected void deployAllAVMwebappsInRepository() {
        HashMap<String, AVMWebappDescriptor> webapp_descriptors;
        block13: {
            webapp_descriptors = new HashMap<String, AVMWebappDescriptor>();
            LinkedList avm_webapp_paths = new LinkedList();
            long split = System.currentTimeMillis();
            try {
                Map store_dns_entries = AVMRemote_.queryStoresPropertyKey(QName.createQName(null, (String)".dns.%"));
                if (log.isInfoEnabled()) {
                    log.info((Object)("deployAllAVMwebappsInRepository: found " + store_dns_entries.size() + " store dns entries in " + (System.currentTimeMillis() - split) + " ms"));
                }
                split = System.currentTimeMillis();
                for (Map.Entry store_dns_entry : store_dns_entries.entrySet()) {
                    String store_name = (String)store_dns_entry.getKey();
                    Map.Entry dns_map = ((Map)store_dns_entry.getValue()).entrySet().iterator().next();
                    String dns_store_path = ((PropertyValue)dns_map.getValue()).getStringValue();
                    if (dns_store_path == null || !dns_store_path.endsWith(this.AVMHostRelativeAppBase_)) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("DNS mount point " + dns_store_path + " does not end with: " + this.AVMHostRelativeAppBase_ + " ...skipping on this host."));
                        continue;
                    }
                    SortedMap webapp_entries = null;
                    try {
                        webapp_entries = AVMRemote_.getDirectoryListing(-1, dns_store_path);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    for (Map.Entry webapp_entry : webapp_entries.entrySet()) {
                        String webapp_name = (String)webapp_entry.getKey();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("webapp: " + webapp_name));
                        }
                        if (webapp_name.equalsIgnoreCase("META-INF") || webapp_name.equalsIgnoreCase("WEB-INF")) {
                            if (!log.isWarnEnabled()) continue;
                            log.warn((Object)("AVMHostConfig disallows webapps named: " + webapp_name));
                            continue;
                        }
                        String webapp_entry_path = ((AVMNodeDescriptor)webapp_entry.getValue()).getPath();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("webapp_entry_path: " + webapp_entry_path));
                        }
                        String webapp_entry_indirection_path = AVMRemote_.getIndirectionPath(-1, webapp_entry_path);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("AVMWebappDescriptor: -1," + store_name + "," + webapp_entry_indirection_path + "," + dns_store_path + "," + webapp_name));
                        }
                        AVMWebappDescriptor webapp_desc = new AVMWebappDescriptor(-1, store_name, webapp_entry_indirection_path, dns_store_path, webapp_name);
                        webapp_descriptors.put(webapp_desc.getContextPath(), webapp_desc);
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("deployAllAVMwebappsInRepository: found " + webapp_descriptors.size() + " webapp descriptors in " + (System.currentTimeMillis() - split) + " ms"));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block13;
                log.error((Object)("deployAllAVMwebappsInRepository failed: " + e.getMessage()));
            }
        }
        this.deployAVMWebappsInDependencyOrder(webapp_descriptors);
    }

    public boolean updateVirtualWebapp(int version, String pathToWebapp, boolean isRecursive) {
        String parent_store_name;
        int parent_index_store_tail;
        String context_name;
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateVirtualWebapp: " + version + ", " + pathToWebapp + " (isRecursive=" + isRecursive + ")"));
        }
        if ((context_name = AVMUrlValve.GetContextNameFromStorePath(version, pathToWebapp)) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("webapp update failed; bad webapp path: " + pathToWebapp));
            }
            return false;
        }
        this.deployed.remove(context_name);
        AVMStandardContext context = (AVMStandardContext)this.host.findChild(context_name);
        if (context != null) {
            this.host.removeChild((Container)context);
            if (log.isInfoEnabled()) {
                log.info((Object)("updateVirtualWebapp: temporarily removed webapp: " + context_name));
            }
        }
        int first_colon = pathToWebapp.indexOf(58);
        int last_slash = pathToWebapp.lastIndexOf(47);
        if (first_colon < 0 || last_slash < 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Not a valid path to a webapp: " + pathToWebapp));
            }
            return false;
        }
        String store_name = pathToWebapp.substring(0, first_colon);
        String store_relpath = pathToWebapp.substring(first_colon + 1);
        String avm_appBase = pathToWebapp.substring(0, last_slash);
        String webapp_name = pathToWebapp.substring(last_slash + 1);
        String indirection_path = null;
        try {
            indirection_path = AVMRemote_.getIndirectionPath(version, pathToWebapp);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("webapp update failed; bad webapp path: " + pathToWebapp));
            }
            return false;
        }
        String parent_context_name = null;
        if (indirection_path != null && (parent_index_store_tail = indirection_path.indexOf(58)) > 0 && !(parent_store_name = indirection_path.substring(0, parent_index_store_tail)).equals(store_name)) {
            parent_context_name = AVMUrlValve.GetContextNameFromStoreName(version, parent_store_name, webapp_name);
        }
        this.deployAVMWebapp(version, avm_appBase, webapp_name, context_name, parent_context_name);
        boolean is_sucessful = true;
        if (isRecursive) {
            ArrayList<LinkedList<String>> store_hierarchy = this.getDependentWebappStores(store_name);
            for (LinkedList<String> store_list : store_hierarchy) {
                if (store_list == null) break;
                for (String dep_store : store_list) {
                    is_sucessful = this.updateVirtualWebapp(version, dep_store + ":" + store_relpath, false) && is_sucessful;
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("updateVirtualWebapp: " + version + ", " + pathToWebapp + " (isRecursive=" + isRecursive + ") updated in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return is_sucessful;
    }

    public boolean updateAllVirtualWebapps(int version, String storePath, boolean isRecursive) {
        int index_store_tail;
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateAllVirtualWebapps: " + version + ", " + storePath + " (isRecursive=" + isRecursive + ")"));
        }
        if ((index_store_tail = storePath.indexOf(58)) <= 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)("webapp update failed; bad store path: " + storePath));
            }
            return false;
        }
        String store_name = storePath.substring(0, index_store_tail);
        String store_relpath = storePath.substring(index_store_tail + 1, storePath.length());
        int index_www_tail = storePath.indexOf(47, index_store_tail + 2);
        if (index_www_tail < 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)("webapp update failed; bad store path: " + storePath));
            }
            return false;
        }
        int index_app_base_tail = storePath.indexOf(47, index_www_tail + 1);
        if (index_app_base_tail < 0) {
            index_app_base_tail = storePath.length();
        }
        if (index_app_base_tail == index_www_tail) {
            if (log.isErrorEnabled()) {
                log.error((Object)("webapp update failed; bad store path: " + storePath));
            }
            return false;
        }
        String avm_appBase = storePath.substring(0, index_app_base_tail);
        SortedMap webapp_entries = null;
        try {
            webapp_entries = AVMRemote_.getDirectoryListing(version, avm_appBase);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("webapp update failed; could not list: " + avm_appBase));
                log.error((Object)e.getMessage());
            }
            return false;
        }
        for (Map.Entry webapp_entry : webapp_entries.entrySet()) {
            String parent_store_name;
            int parent_index_store_tail;
            String webapp_storePath;
            String context_name;
            String webapp_name = (String)webapp_entry.getKey();
            if (log.isDebugEnabled()) {
                log.debug((Object)("webapp found: " + webapp_name));
            }
            if ((context_name = AVMUrlValve.GetContextNameFromStorePath(version, webapp_storePath = avm_appBase + "/" + webapp_name)) == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("webapp update failed; bad store path: " + webapp_storePath));
                }
                return false;
            }
            this.deployed.remove(context_name);
            AVMStandardContext context = (AVMStandardContext)this.host.findChild(context_name);
            if (context != null) {
                this.host.removeChild((Container)context);
                if (log.isInfoEnabled()) {
                    log.info((Object)("temporarily removed webapp: " + context_name));
                }
            }
            String indirection_path = AVMRemote_.getIndirectionPath(version, ((AVMNodeDescriptor)webapp_entry.getValue()).getPath());
            String parent_context_name = null;
            if (indirection_path != null && (parent_index_store_tail = indirection_path.indexOf(58)) > 0 && !(parent_store_name = indirection_path.substring(0, parent_index_store_tail)).equals(store_name)) {
                parent_context_name = AVMUrlValve.GetContextNameFromStoreName(version, parent_store_name, webapp_name);
            }
            this.deployAVMWebapp(version, avm_appBase, webapp_name, context_name, parent_context_name);
        }
        boolean is_sucessful = true;
        if (isRecursive) {
            ArrayList<LinkedList<String>> store_hierarchy = this.getDependentWebappStores(store_name);
            for (LinkedList<String> store_list : store_hierarchy) {
                if (store_list == null) break;
                for (String dep_store : store_list) {
                    is_sucessful = this.updateAllVirtualWebapps(version, dep_store + ":" + store_relpath, false) && is_sucessful;
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("updateAllVirtualWebapps: " + version + ", " + storePath + " (isRecursive=" + isRecursive + ") updated in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return is_sucessful;
    }

    protected ArrayList<LinkedList<String>> getDependentWebappStores(String store_name) {
        long split = System.currentTimeMillis();
        ArrayList<LinkedList<String>> store_hierarchy = new ArrayList<LinkedList<String>>(8);
        boolean lazyDeploy = true;
        if (this.host instanceof AVMHost) {
            lazyDeploy = ((AVMHost)this.host).getLazyDeploy();
        }
        Map store_child_entries = AVMRemote_.queryStoresPropertyKey(QName.createQName(null, (String)(".background-layer." + store_name)));
        if (log.isDebugEnabled()) {
            log.debug((Object)("getDependentWebappStores: for '" + store_name + "' found " + store_child_entries.size() + " store child entries in " + (System.currentTimeMillis() - split) + " ms"));
        }
        split = System.currentTimeMillis();
        for (Map.Entry store_child_entry : store_child_entries.entrySet()) {
            String child_store_name = (String)store_child_entry.getKey();
            boolean isStoreDeployed = true;
            if (lazyDeploy) {
                isStoreDeployed = false;
                Container[] children = this.host.findChildren();
                for (int i = 0; i < children.length; ++i) {
                    AVMStandardContext sc;
                    String ctxName;
                    if (!(children[i] instanceof AVMStandardContext) || !(ctxName = (sc = (AVMStandardContext)children[i]).getName()).startsWith(AVMUrlValve.GetContextNameFromStoreName(-1, child_store_name, ""))) continue;
                    isStoreDeployed = true;
                }
            }
            if (!isStoreDeployed) continue;
            Map.Entry child_map = ((Map)store_child_entry.getValue()).entrySet().iterator().next();
            int distance = (int)((PropertyValue)child_map.getValue()).getLongValue();
            if (distance > store_hierarchy.size()) {
                for (int i = store_hierarchy.size(); i < distance; ++i) {
                    store_hierarchy.add(new LinkedList());
                }
            }
            LinkedList<String> store_list = store_hierarchy.get(distance - 1);
            store_list.add(child_store_name);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("getDependentWebappStores: for '" + store_name + "' found " + store_hierarchy.size() + " stores " + (lazyDeploy ? "(lazy deploy is enabled) " : "") + "in " + (System.currentTimeMillis() - split) + " ms"));
        }
        return store_hierarchy;
    }

    public boolean removeVirtualWebapp(int version, String pathToWebapp, boolean isRecursive) {
        AVMStandardContext context;
        String context_name;
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeVirtualWebapp: " + version + ", " + pathToWebapp + " (isRecursive=" + isRecursive + ")"));
        }
        int first_colon = pathToWebapp.indexOf(58);
        int last_slash = pathToWebapp.lastIndexOf(47);
        if (first_colon < 0 || last_slash < 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Not a valid path to a webapp: " + pathToWebapp));
            }
            return false;
        }
        String store_name = pathToWebapp.substring(0, first_colon);
        String store_relpath = pathToWebapp.substring(first_colon + 1);
        String avm_appBase = pathToWebapp.substring(0, last_slash);
        String webapp_name = pathToWebapp.substring(last_slash + 1);
        boolean is_sucessful = true;
        if (isRecursive) {
            ArrayList<LinkedList<String>> store_hierarchy = this.getDependentWebappStores(store_name);
            for (int i = store_hierarchy.size() - 1; i >= 0; --i) {
                LinkedList<String> store_list = store_hierarchy.get(i);
                if (store_list == null) continue;
                for (String dep_store : store_list) {
                    is_sucessful = this.removeVirtualWebapp(version, dep_store + ":" + store_relpath, false) && is_sucessful;
                }
            }
        }
        if ((context_name = AVMUrlValve.GetContextNameFromStorePath(version, pathToWebapp)) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("remove webapp failed; bad webapp path: " + pathToWebapp));
            }
            return false;
        }
        this.deployed.remove(context_name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove webapp removed: " + context_name));
        }
        if ((context = (AVMStandardContext)this.host.findChild(context_name)) != null) {
            ServletContext servletContext = context.getServletContext();
            File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            this.host.removeChild((Container)context);
            boolean clean_ok = AVMHostConfig.CleanDir(workDir, true);
            if (!clean_ok) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not remove entire work directory: " + workDir.getAbsolutePath()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Remove work directory: " + workDir.getAbsolutePath()));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("removed webapp: " + context_name));
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("removeVirtualWebapp: " + version + ", " + pathToWebapp + " (isRecursive=" + isRecursive + ") removed in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return is_sucessful;
    }

    public boolean removeAllVirtualWebapps(int version, String storePath, boolean isRecursive) {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeAllVirtualWebapps: " + version + ", " + storePath + " (isRecursive=" + isRecursive + ")"));
        }
        boolean is_sucessful = true;
        int index_store_tail = storePath.indexOf(58);
        if (index_store_tail <= 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)("remove webapp failed; bad store path: " + storePath));
            }
            return false;
        }
        String store_name = storePath.substring(0, index_store_tail);
        String store_relpath = storePath.substring(index_store_tail + 1, storePath.length());
        int index_www_tail = storePath.indexOf(47, index_store_tail + 2);
        if (index_www_tail < 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)("remove webapp failed; bad store path: " + storePath));
            }
            return false;
        }
        int index_app_base_tail = storePath.indexOf(47, index_www_tail + 1);
        if (index_app_base_tail < 0) {
            index_app_base_tail = storePath.length();
        }
        if (index_app_base_tail == index_www_tail) {
            if (log.isErrorEnabled()) {
                log.error((Object)("remove webapp failed; bad store path: " + storePath));
            }
            return false;
        }
        if (isRecursive) {
            ArrayList<LinkedList<String>> store_hierarchy = this.getDependentWebappStores(store_name);
            for (int i = store_hierarchy.size() - 1; i >= 0; --i) {
                LinkedList<String> store_list = store_hierarchy.get(i);
                if (store_list == null) continue;
                for (String dep_store : store_list) {
                    is_sucessful = this.removeAllVirtualWebapps(version, dep_store + ":" + store_relpath, false) && is_sucessful;
                }
            }
        }
        String avm_appBase = storePath.substring(0, index_app_base_tail);
        SortedMap webapp_entries = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove webapp listing: " + avm_appBase));
        }
        try {
            webapp_entries = AVMRemote_.getDirectoryListing(version, avm_appBase);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("remove webapp failed; could not list: " + avm_appBase));
                log.error((Object)e.getMessage());
            }
            return false;
        }
        for (Map.Entry webapp_entry : webapp_entries.entrySet()) {
            AVMStandardContext context;
            String webapp_storePath;
            String context_name;
            String webapp_name = (String)webapp_entry.getKey();
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove webapp found: " + webapp_name));
            }
            if ((context_name = AVMUrlValve.GetContextNameFromStorePath(version, webapp_storePath = avm_appBase + "/" + webapp_name)) == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("remove webapp failed; bad store path: " + webapp_storePath));
                }
                return false;
            }
            this.deployed.remove(context_name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove webapp removed: " + context_name));
            }
            if ((context = (AVMStandardContext)this.host.findChild(context_name)) == null) continue;
            ServletContext servletContext = context.getServletContext();
            File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            this.host.removeChild((Container)context);
            boolean clean_ok = AVMHostConfig.CleanDir(workDir, true);
            if (!clean_ok) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not remove entire work directory: " + workDir.getAbsolutePath()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Remove work directory: " + workDir.getAbsolutePath()));
            }
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("removed webapp: " + context_name));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("removeAllVirtualWebapps: " + version + ", " + storePath + " (isRecursive=" + isRecursive + ") removed in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return is_sucessful;
    }

    static boolean CleanDir(File dir, boolean deleteDir) {
        boolean overall_status = true;
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            boolean status = file.isDirectory() ? AVMHostConfig.CleanDir(file, true) : file.delete();
            overall_status = overall_status && status;
        }
        if (deleteDir) {
            overall_status = dir.delete() && overall_status;
        }
        return overall_status;
    }

    protected void deployAVMWebappsInDependencyOrder(HashMap<String, AVMWebappDescriptor> webapp_descriptors) {
        long split = System.currentTimeMillis();
        boolean lazyDeploy = false;
        if (this.host instanceof AVMHost) {
            lazyDeploy = ((AVMHost)this.host).getLazyDeploy();
        }
        boolean deployDependentsRecursively = !lazyDeploy;
        for (AVMWebappDescriptor desc : webapp_descriptors.values()) {
            int version = desc.version_;
            String store_path = desc.avm_appBase_ + "/" + desc.webapp_leafname_;
            if (desc.indirection_name_ != null) {
                int index;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Indirection name for:  " + store_path + " is: " + desc.indirection_name_));
                }
                if ((index = desc.indirection_name_.indexOf(58)) <= 0) continue;
                String parent_store = desc.indirection_name_.substring(0, index);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("parent_store for:  " + desc.store_name_ + " is: " + parent_store));
                }
                if (parent_store.equals(desc.store_name_)) continue;
                desc.setWebappDependency(webapp_descriptors, parent_store);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Indirection name is null for: " + store_path));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("deployAllAVMwebappsInRepository: get " + webapp_descriptors.size() + " webapp descriptors (w/ dependencies) in " + (System.currentTimeMillis() - split) + " ms"));
        }
        split = System.currentTimeMillis();
        int noDepsCnt = 0;
        for (AVMWebappDescriptor desc : webapp_descriptors.values()) {
            if (desc.getParentContextPath() != null) continue;
            this.deployAVMWebappDescriptorTree(desc, deployDependentsRecursively);
            ++noDepsCnt;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("deployAllAVMwebappsInRepository: deployed " + (deployDependentsRecursively ? Integer.valueOf(webapp_descriptors.size()) : " (not dependents - lazy deploy is enabled) " + noDepsCnt) + " webapp descriptors in " + (System.currentTimeMillis() - split) + " ms"));
        }
    }

    protected void deployAVMWebappDescriptorTree(AVMWebappDescriptor desc) {
        this.deployAVMWebappDescriptorTree(desc, true);
    }

    private void deployAVMWebappDescriptorTree(AVMWebappDescriptor desc, boolean deployDependentsRecursively) {
        this.deployAVMWebapp(desc.version_, desc.avm_appBase_, desc.webapp_leafname_, desc.getContextPath(), desc.getParentContextPath());
        if (deployDependentsRecursively) {
            for (AVMWebappDescriptor dependent : desc.dependents_) {
                this.deployAVMWebappDescriptorTree(dependent);
            }
        }
    }

    protected void deployAVMWebapp(int version, String avm_appBase, String webapp_leafname, String context_path, String parent_context_path) {
        if (this.isServiced(context_path)) {
            return;
        }
        if (webapp_leafname.equalsIgnoreCase("META-INF") || webapp_leafname.equalsIgnoreCase("WEB-INF")) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Disallow webapps named: " + webapp_leafname));
            }
            return;
        }
        this.deployAVMdirectory(version, avm_appBase, webapp_leafname, context_path, parent_context_path);
    }

    protected boolean deployAVMdirectory(int version, String avmAppBase, String webapp_leafname, String contextPath, String parent_context_path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deployAVMdirectory: webapp [" + version + ", " + avmAppBase + ", " + webapp_leafname + "]"));
        }
        String webapp_fullpath = avmAppBase + "/" + webapp_leafname;
        if (this.deploymentExists(contextPath)) {
            return false;
        }
        AVMDeployedApplication deployedApp = new AVMDeployedApplication(contextPath, avmAppBase);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.deployDir", (Object)webapp_leafname));
        }
        try {
            AVMStandardContext context = new AVMStandardContext();
            if (context instanceof Lifecycle) {
                Class<?> clazz = Class.forName(this.host.getConfigClass());
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                context.addLifecycleListener(listener);
            }
            context.setResources((DirContext)new AVMFileDirContext());
            ClassLoader parent_cl = this.host.getParentClassLoader();
            AVMWebappLoader webappLoader = new AVMWebappLoader(parent_cl, this.context_classloader_registry_, contextPath, parent_context_path, version, avmAppBase + "/" + webapp_leafname);
            webappLoader.setDelegate(false);
            context.setLoader(webappLoader);
            context.setPath(contextPath);
            int store_delim = webapp_fullpath.indexOf(58);
            context.setDocBase(webapp_fullpath.substring(0, store_delim) + "/VERSION/v" + version + "/DATA" + webapp_fullpath.substring(store_delim + 1, webapp_fullpath.length()));
            String configFile = webapp_fullpath + "/" + "META-INF/context.xml";
            if (this.deployXML) {
                context.setConfigFile(configFile);
            }
            long split = System.currentTimeMillis();
            this.host.addChild((Container)context);
            if (log.isInfoEnabled()) {
                log.info((Object)("deployAVMdirectory: started web app [" + version + ", " + avmAppBase + ", " + webapp_leafname + "] in " + (System.currentTimeMillis() - split) + " ms"));
            }
            AVMNodeDescriptor desc = null;
            Long last_modified = null;
            try {
                desc = AVMRemote_.lookup(version, webapp_fullpath);
                last_modified = desc != null ? new Long(desc.getModDate()) : new Long(0L);
            }
            catch (Exception e) {
                last_modified = new Long(0L);
            }
            deployedApp.redeployResources.put(webapp_fullpath, last_modified);
            if (this.deployXML) {
                try {
                    desc = AVMRemote_.lookup(version, configFile);
                    last_modified = desc != null ? new Long(desc.getModDate()) : new Long(0L);
                }
                catch (Exception e) {
                    last_modified = new Long(0L);
                }
                deployedApp.redeployResources.put(configFile, last_modified);
            }
            this.addWatchedResources(deployedApp, webapp_fullpath, (Context)context);
        }
        catch (Throwable t) {
            if (log.isErrorEnabled()) {
                log.error((Object)sm.getString("hostConfig.deployDir.error", (Object)webapp_leafname), t);
            }
            return false;
        }
        this.deployed.put(contextPath, deployedApp);
        return true;
    }

    protected void addWatchedResources(AVMDeployedApplication app, String webapp_fullpath, Context context) {
        String[] watchedResources = context.findWatchedResources();
        for (int i = 0; i < watchedResources.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("watched resource: " + watchedResources[i]));
            }
            Long last_modified = null;
            String resource = watchedResources[i];
            if (!resource.startsWith(webapp_fullpath)) {
                if (File.separatorChar == '/') {
                    if (resource.charAt(0) == '/') continue;
                    resource = webapp_fullpath + "/" + resource;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("relative watched resource put into webapp_fullpath: " + resource));
                    }
                } else {
                    if (resource.startsWith(":\\", 1)) continue;
                    resource = webapp_fullpath + "/" + resource;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("relative watched resource put into webapp_fullpath: " + resource));
                    }
                }
            }
            AVMNodeDescriptor resource_desc = null;
            try {
                resource_desc = AVMRemote_.lookup(-1, resource);
                last_modified = resource_desc != null ? new Long(resource_desc.getModDate()) : new Long(0L);
            }
            catch (Exception e) {
                last_modified = new Long(0L);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding watched resource: " + resource + "  modtime:" + last_modified));
            }
            app.reloadResources.put(resource, last_modified);
        }
    }

    protected void check() {
    }

    protected synchronized void checkResources(HostConfig.DeployedApplication app) {
    }

    class AVMDeployedApplication
    extends HostConfig.DeployedApplication {
        String avmAppBase_;

        public AVMDeployedApplication(String name) {
            super((HostConfig)AVMHostConfig.this, name);
        }

        public AVMDeployedApplication(String name, String avmAppBase) {
            super((HostConfig)AVMHostConfig.this, name);
            this.avmAppBase_ = avmAppBase;
        }

        public String getName() {
            return this.name;
        }

        public String getAvmAppBase() {
            return this.avmAppBase_;
        }

        public void setAvmAppBase(String avmAppBase) {
            this.avmAppBase_ = avmAppBase;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AVMWebappDescriptor {
        int version_;
        String store_name_;
        String indirection_name_;
        String avm_appBase_;
        String webapp_leafname_;
        String context_path_;
        String parent_store_name_;
        String parent_context_path_;
        List<AVMWebappDescriptor> dependents_ = new LinkedList<AVMWebappDescriptor>();

        void addDependentWebappDescriptor(AVMWebappDescriptor d) {
            this.dependents_.add(d);
        }

        AVMWebappDescriptor(int version, String store_name, String indirection_name, String avm_appBase, String webapp_leafname) {
            this.version_ = version;
            this.store_name_ = store_name;
            this.indirection_name_ = indirection_name;
            this.avm_appBase_ = avm_appBase;
            this.webapp_leafname_ = webapp_leafname;
        }

        String getContextPath() {
            if (this.context_path_ == null) {
                this.context_path_ = AVMUrlValve.GetContextNameFromStoreName(this.version_, this.store_name_, this.webapp_leafname_);
            }
            return this.context_path_;
        }

        void setWebappDependency(HashMap<String, AVMWebappDescriptor> webapp_descriptors, String parent_store_name) {
            this.parent_store_name_ = parent_store_name;
            String parent_context_path = this.getParentContextPath();
            AVMWebappDescriptor parent_desc = webapp_descriptors.get(parent_context_path);
            if (parent_desc != null) {
                parent_desc.addDependentWebappDescriptor(this);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Virtual context: " + this.getContextPath() + " has parent: " + parent_context_path));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Virtual context: " + this.getContextPath() + " has no parent: " + parent_context_path));
            }
        }

        String getParentContextPath() {
            if (this.parent_store_name_ == null) {
                return null;
            }
            if (this.parent_context_path_ == null) {
                this.parent_context_path_ = AVMUrlValve.GetContextNameFromStoreName(this.version_, this.parent_store_name_, this.webapp_leafname_);
            }
            return this.parent_context_path_;
        }
    }
}

