/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.authenticator;

import java.io.IOException;
import java.util.Map;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.authenticator.ClusterSingleSignOn;
import org.apache.catalina.cluster.authenticator.SingleSignOnMessage;
import org.apache.catalina.cluster.session.ClusterListener;

public class ClusterSingleSignOnListener
extends ClusterListener {
    protected static final String info = "org.apache.catalina.cluster.authenticator.ClusterSingleSignOnListener/1.0";
    private ClusterSingleSignOn clusterSSO = null;

    public String getInfo() {
        return info;
    }

    public ClusterSingleSignOn getClusterSSO() {
        return this.clusterSSO;
    }

    public void setClusterSSO(ClusterSingleSignOn clusterSSO) {
        this.clusterSSO = clusterSSO;
    }

    public void messageReceived(ClusterMessage myobj) {
        if (myobj != null && myobj instanceof SingleSignOnMessage) {
            SingleSignOnMessage msg = (SingleSignOnMessage)myobj;
            int action = msg.getAction();
            Session session = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("SingleSignOnMessage Received with action " + msg.getAction()));
            }
            switch (action) {
                case 1: {
                    session = this.getSession(msg.getSessionId(), msg.getContextName());
                    if (session == null) break;
                    this.clusterSSO.associateLocal(msg.getSsoId(), session);
                    break;
                }
                case 2: {
                    session = this.getSession(msg.getSessionId(), msg.getContextName());
                    if (session == null) break;
                    this.clusterSSO.deregisterLocal(msg.getSsoId(), session);
                    break;
                }
                case 3: {
                    this.clusterSSO.deregisterLocal(msg.getSsoId());
                    break;
                }
                case 4: {
                    this.clusterSSO.registerLocal(msg.getSsoId(), null, msg.getAuthType(), msg.getUsername(), msg.getPassword());
                    break;
                }
                case 5: {
                    this.clusterSSO.updateLocal(msg.getSsoId(), null, msg.getAuthType(), msg.getUsername(), msg.getPassword());
                    break;
                }
                case 6: {
                    session = this.getSession(msg.getSessionId(), msg.getContextName());
                    if (session == null) break;
                    this.clusterSSO.removeSessionLocal(msg.getSsoId(), session);
                }
            }
        }
    }

    public boolean accept(ClusterMessage msg) {
        return msg instanceof SingleSignOnMessage;
    }

    private Session getSession(String sessionId, String ctxname) {
        Map managers = this.clusterSSO.getCluster().getManagers();
        Session session = null;
        if (ctxname == null) {
            for (String key : managers.keySet()) {
                ClusterManager mgr = (ClusterManager)managers.get(key);
                if (mgr != null) {
                    try {
                        session = mgr.findSession(sessionId);
                    }
                    catch (IOException io) {
                        log.error((Object)("Session doesn't exist:" + io));
                    }
                    return session;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Context manager doesn't exist:" + key));
            }
        } else {
            ClusterManager mgr = (ClusterManager)managers.get(ctxname);
            if (mgr != null) {
                try {
                    session = mgr.findSession(sessionId);
                }
                catch (IOException io) {
                    log.error((Object)("Session doesn't exist:" + io));
                }
                return session;
            }
            log.error((Object)("Context manager doesn't exist:" + ctxname));
        }
        return null;
    }
}

