/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.util.Map;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.session.ClusterListener;
import org.apache.catalina.cluster.session.SessionMessage;

public class ClusterSessionListener
extends ClusterListener {
    protected static final String info = "org.apache.catalina.session.ClusterSessionListener/1.1";

    public String getInfo() {
        return info;
    }

    public void messageReceived(ClusterMessage myobj) {
        if (myobj != null && myobj instanceof SessionMessage) {
            SessionMessage msg = (SessionMessage)myobj;
            String ctxname = msg.getContextName();
            Map managers = this.cluster.getManagers();
            if (ctxname == null) {
                for (String key : managers.keySet()) {
                    ClusterManager mgr = (ClusterManager)managers.get(key);
                    if (mgr != null) {
                        mgr.messageDataReceived(msg);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Context manager doesn't exist:" + key));
                }
            } else {
                ClusterManager mgr = (ClusterManager)managers.get(ctxname);
                if (mgr != null) {
                    mgr.messageDataReceived(msg);
                } else if (log.isErrorEnabled()) {
                    log.error((Object)("Context manager doesn't exist:" + ctxname));
                }
            }
        }
    }

    public boolean accept(ClusterMessage msg) {
        return msg instanceof SessionMessage;
    }
}

