/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.catalina.cluster.io.ListenCallback;
import org.apache.catalina.cluster.io.SocketObjectReader;
import org.apache.catalina.cluster.tcp.ClusterData;
import org.apache.catalina.cluster.tcp.SocketReplicationListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketReplicationThread
extends Thread
implements ListenCallback {
    private static Log log = LogFactory.getLog(SocketReplicationThread.class);
    private static byte[] ACK_COMMAND = new byte[]{6, 2, 3};
    private static int count = 0;
    private SocketReplicationListener master;
    private Socket socket;
    private SocketObjectReader reader;
    private boolean keepRunning = true;

    SocketReplicationThread(SocketReplicationListener master, Socket socket) {
        super("ClusterListenThread-" + count++);
        this.master = master;
        this.socket = socket;
        this.reader = new SocketObjectReader(socket, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            byte[] buffer = new byte[1024];
            InputStream in = this.socket.getInputStream();
            while (this.keepRunning) {
                int cnt = in.read(buffer);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("read " + cnt + " bytes from " + this.socket.getPort()));
                }
                int ack = 0;
                if (cnt > 0) {
                    ack = this.reader.append(buffer, 0, cnt);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("sending " + ack + " ack packages to " + this.socket.getLocalPort()));
                    }
                    this.keepRunning = this.master.isDoListen();
                    continue;
                }
                this.keepRunning = false;
            }
        }
        catch (SocketTimeoutException se) {
        }
        catch (SocketException se) {
        }
        catch (IOException x) {
            log.error((Object)"Unable to read data from client, disconnecting.", (Throwable)x);
        }
        finally {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {}
            }
            this.keepRunning = false;
            this.socket = null;
        }
    }

    public void messageDataReceived(ClusterData data) {
        this.master.messageDataReceived(data);
    }

    public boolean isSendAck() {
        return this.master.isSendAck();
    }

    public void sendAck() throws IOException {
        this.socket.getOutputStream().write(ACK_COMMAND);
        if (log.isTraceEnabled()) {
            log.trace((Object)("ACK sent to " + this.socket.getPort()));
        }
    }
}

