/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.catalina.cluster.io.ObjectReader;
import org.apache.catalina.cluster.tcp.WorkerThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpReplicationThread
extends WorkerThread {
    public static final byte[] ACK_COMMAND = new byte[]{6, 2, 3};
    private static Log log = LogFactory.getLog(TcpReplicationThread.class);
    private ByteBuffer buffer = ByteBuffer.allocate(1024);
    private SelectionKey key;
    private boolean sendAck = true;

    TcpReplicationThread() {
    }

    public synchronized void run() {
        while (this.doRun) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"TCP worker thread interrupted in cluster", (Throwable)e);
                }
                Thread.interrupted();
            }
            if (this.key == null) continue;
            try {
                this.drainChannel(this.key);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"IOException in replication worker, unable to drain channel. Probable cause: Keep alive socket closed.", (Throwable)e);
                    }
                } else if (log.isErrorEnabled()) {
                    log.error((Object)"Exception caught in TcpReplicationThread.drainChannel.", (Throwable)e);
                }
                try {
                    this.key.channel().close();
                }
                catch (IOException ex) {
                    log.error((Object)"Unable to close channel.", (Throwable)ex);
                }
                this.key.selector().wakeup();
            }
            this.key = null;
            this.pool.returnWorker(this);
        }
    }

    synchronized void serviceChannel(SelectionKey key, boolean sendAck) {
        this.key = key;
        this.sendAck = sendAck;
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drainChannel(SelectionKey key) throws Exception {
        Object mutex;
        int count;
        boolean packetReceived = false;
        SocketChannel channel = (SocketChannel)key.channel();
        this.buffer.clear();
        ObjectReader reader = (ObjectReader)key.attachment();
        while ((count = channel.read(this.buffer)) > 0) {
            this.buffer.flip();
            reader.append(this.buffer.array(), 0, count);
            this.buffer.clear();
        }
        int pkgcnt = reader.execute();
        if (log.isTraceEnabled()) {
            log.trace((Object)("sending " + pkgcnt + " ack packages to " + channel.socket().getLocalPort()));
        }
        if (this.sendAck) {
            while (pkgcnt > 0) {
                this.sendAck(key, channel);
                --pkgcnt;
            }
        }
        if (count < 0) {
            channel.close();
            return;
        }
        Object object = mutex = this.getPool().getInterestOpsMutex();
        synchronized (object) {
            key.selector().wakeup();
            int resumeOps = key.interestOps() | 1;
            key.interestOps(resumeOps);
        }
    }

    protected void sendAck(SelectionKey key, SocketChannel channel) {
        try {
            channel.write(ByteBuffer.wrap(ACK_COMMAND));
            if (log.isTraceEnabled()) {
                log.trace((Object)("ACK sent to " + channel.socket().getPort()));
            }
        }
        catch (IOException x) {
            log.warn((Object)("Unable to send ACK back through channel, channel disconnected?: " + x.getMessage()));
        }
    }
}

