/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco;

import java.io.Serializable;
import java.lang.reflect.Field;
import junit.framework.TestCase;
import net.sf.ehcache.CacheManager;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.BaseApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class RepositoryStartStopTest
extends TestCase {
    private ServiceRegistry serviceRegistry;
    private TransactionService transactionService;
    private boolean writeTestWorked;

    public void setUp() throws Exception {
        ApplicationContextHelper.closeApplicationContext();
    }

    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public static void assertNoCachedApplicationContext() throws Exception {
        Field instanceF = BaseApplicationContextHelper.class.getDeclaredField("instance");
        instanceF.setAccessible(true);
        RepositoryStartStopTest.assertNull((String)"Instance cache on ApplicationContextHelper was populated instead of empty", (Object)instanceF.get(null));
    }

    public static void assertAllCachesShutdown() throws Exception {
        RepositoryStartStopTest.assertEquals((String)"All Caches should have been shut down, but some remained", (int)0, (int)CacheManager.ALL_CACHE_MANAGERS.size());
    }

    private ApplicationContext getMinimalContext() {
        ApplicationContextHelper.setUseLazyLoading((boolean)false);
        ApplicationContextHelper.setNoAutoStart((boolean)true);
        return ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:alfresco/minimal-context.xml"});
    }

    private ApplicationContext getFullContext() {
        ApplicationContextHelper.setUseLazyLoading((boolean)false);
        ApplicationContextHelper.setNoAutoStart((boolean)false);
        return ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:alfresco/application-context.xml"});
    }

    public void testOpenClose() throws Exception {
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        ApplicationContext ctx = this.getMinimalContext();
        RepositoryStartStopTest.assertNotNull((Object)ctx);
        this.doTestBasicWriteOperations(ctx);
        ApplicationContextHelper.closeApplicationContext();
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        RepositoryStartStopTest.assertAllCachesShutdown();
    }

    public void testOpenCloseOpenCloseNoAutostart() throws Exception {
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        ApplicationContext ctx = this.getMinimalContext();
        RepositoryStartStopTest.assertNotNull((Object)ctx);
        this.doTestBasicWriteOperations(ctx);
        ApplicationContextHelper.closeApplicationContext();
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        RepositoryStartStopTest.assertAllCachesShutdown();
        ApplicationContext ctx2 = this.getMinimalContext();
        RepositoryStartStopTest.assertNotNull((Object)ctx2);
        this.doTestBasicWriteOperations(ctx2);
        RepositoryStartStopTest.assertNotSame((Object)ctx, (Object)ctx2);
        ctx = this.getMinimalContext();
        RepositoryStartStopTest.assertEquals((Object)ctx, (Object)ctx2);
        ApplicationContextHelper.closeApplicationContext();
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        RepositoryStartStopTest.assertAllCachesShutdown();
    }

    public void testOpenCloseOpenCloseFull() throws Exception {
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        ApplicationContext ctx = this.getFullContext();
        RepositoryStartStopTest.assertNotNull((Object)ctx);
        this.doTestBasicWriteOperations(ctx);
        ApplicationContextHelper.closeApplicationContext();
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        RepositoryStartStopTest.assertAllCachesShutdown();
        ApplicationContext ctx2 = this.getFullContext();
        RepositoryStartStopTest.assertNotNull((Object)ctx2);
        this.doTestBasicWriteOperations(ctx2);
        ctx = this.getFullContext();
        RepositoryStartStopTest.assertEquals((Object)ctx, (Object)ctx2);
        ((AbstractApplicationContext)ctx).refresh();
        ApplicationContextHelper.closeApplicationContext();
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        RepositoryStartStopTest.assertAllCachesShutdown();
    }

    public void testOpenCloseRepeatedly() throws Exception {
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        ApplicationContext ctx = this.getMinimalContext();
        RepositoryStartStopTest.assertNotNull((Object)ctx);
        this.doTestBasicWriteOperations(ctx);
        ApplicationContextHelper.closeApplicationContext();
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        RepositoryStartStopTest.assertAllCachesShutdown();
        ctx = this.getFullContext();
        RepositoryStartStopTest.assertNotNull((Object)ctx);
        this.doTestBasicWriteOperations(ctx);
        ApplicationContext ctxSav = ctx;
        ctx = this.getFullContext();
        RepositoryStartStopTest.assertEquals((Object)ctx, (Object)ctxSav);
        ApplicationContextHelper.closeApplicationContext();
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        RepositoryStartStopTest.assertAllCachesShutdown();
        ctx = this.getMinimalContext();
        RepositoryStartStopTest.assertNotNull((Object)ctx);
        this.doTestBasicWriteOperations(ctx);
        ApplicationContextHelper.closeApplicationContext();
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        RepositoryStartStopTest.assertAllCachesShutdown();
        ctx = this.getFullContext();
        RepositoryStartStopTest.assertNotNull((Object)ctx);
        this.doTestBasicWriteOperations(ctx);
        ApplicationContextHelper.closeApplicationContext();
        RepositoryStartStopTest.assertNoCachedApplicationContext();
        RepositoryStartStopTest.assertAllCachesShutdown();
    }

    public void doTestBasicWriteOperations(ApplicationContext ctx) throws Exception {
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = this.serviceRegistry.getTransactionService();
        AuthenticationUtil.setRunAsUserSystem();
        RepositoryStartStopTest.assertFalse((String)"The transaction is read-only - further unit tests are pointless.", (boolean)this.transactionService.isReadOnly());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> addPropertyCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeService nodeService = RepositoryStartStopTest.this.serviceRegistry.getNodeService();
                NodeRef rootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
                nodeService.setProperty(rootNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"SanityCheck"));
                RepositoryStartStopTest.this.writeTestWorked = true;
                return null;
            }
        };
        this.writeTestWorked = false;
        this.transactionService.getRetryingTransactionHelper().doInTransaction(addPropertyCallback, false, true);
        RepositoryStartStopTest.assertTrue((String)"The Node Write didn't occur or failed with an error", (boolean)this.writeTestWorked);
    }
}

