/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server.impl.subetha;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.email.server.EmailServer;
import org.alfresco.email.server.impl.subetha.SubethaEmailMessage;
import org.alfresco.service.cmr.email.EmailMessageException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.TooMuchDataException;
import org.subethamail.smtp.server.SMTPServer;

public class SubethaEmailServer
extends EmailServer {
    private static final Log log = LogFactory.getLog(SubethaEmailServer.class);
    private SMTPServer serverImpl;

    protected SubethaEmailServer() {
    }

    public void startup() {
        this.serverImpl = new SMTPServer((MessageHandlerFactory)new HandlerFactory());
        this.serverImpl.setPort(this.getPort());
        this.serverImpl.setHostName(this.getDomain());
        this.serverImpl.setMaxConnections(this.getMaxConnections());
        this.serverImpl.start();
        log.info((Object)"Email Server has started successfully");
    }

    public void shutdown() {
        this.serverImpl.stop();
        log.info((Object)"Email Server has stopped successfully");
    }

    class Delivery {
        private String recipient;

        public Delivery(String recipient) {
            this.recipient = recipient;
        }

        public String getRecipient() {
            return this.recipient;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Handler
    implements MessageHandler {
        private int DEFAULT_DATA_DEFERRED_SIZE = 0x700000;
        private List<String> EMPTY_LIST = new LinkedList<String>();
        private String from;
        private MessageContext messageContext;
        List<Delivery> deliveries = new ArrayList<Delivery>();

        public Handler(MessageContext messageContext) {
            this.messageContext = messageContext;
        }

        public MessageContext getMessageContext() {
            return this.messageContext;
        }

        public void from(String from) throws RejectException {
            this.from = from;
            try {
                SubethaEmailServer.this.filterSender(from);
            }
            catch (EmailMessageException e) {
                throw new RejectException(554, e.getMessage());
            }
        }

        public void recipient(String recipient) throws RejectException {
            this.deliveries.add(new Delivery(recipient));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void data(InputStream data) throws TooMuchDataException, IOException, RejectException {
            try {
                if (this.deliveries.size() > 0) {
                    Delivery delivery = this.deliveries.get(0);
                    this.processDelivery(delivery, data);
                }
            }
            finally {
                this.deliveries.clear();
            }
        }

        private void processDelivery(Delivery delivery, InputStream data) throws RejectException {
            try {
                SubethaEmailMessage emailMessage = new SubethaEmailMessage(this.from, delivery.getRecipient(), data);
                SubethaEmailServer.this.getEmailService().importMessage(emailMessage);
            }
            catch (EmailMessageException e) {
                throw new RejectException(554, e.getMessage());
            }
            catch (Throwable e) {
                log.error((Object)e.getMessage(), e);
                throw new RejectException(554, "An internal error prevented mail delivery.");
            }
        }

        public List<String> getAuthenticationMechanisms() {
            return this.EMPTY_LIST;
        }

        public boolean auth(String clientInput, StringBuffer response) throws RejectException {
            return true;
        }

        public void resetState() {
        }
    }

    class HandlerFactory
    implements MessageHandlerFactory {
        HandlerFactory() {
        }

        public MessageHandler create(MessageContext messageContext) {
            return new Handler(messageContext);
        }
    }
}

