/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.auth.cifs;

import java.security.NoSuchAlgorithmException;
import net.sf.acegisecurity.Authentication;
import org.alfresco.filesys.alfresco.AlfrescoClientInfo;
import org.alfresco.filesys.auth.cifs.AuthTokenAuthContext;
import org.alfresco.filesys.auth.cifs.CifsAuthenticatorBase;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.AuthContext;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.NTLanManAuthContext;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.util.HexDump;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NTLMPassthruToken;
import org.alfresco.repo.transaction.RetryingTransactionHelper;

public class AlfrescoCifsAuthenticator
extends CifsAuthenticatorBase {
    protected boolean validateAuthenticationMode() {
        try {
            return this.getNTLMAuthenticator().getNTLMMode() == NTLMMode.MD4_PROVIDER || this.getNTLMAuthenticator().getNTLMMode() == NTLMMode.PASS_THROUGH;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public int authenticateUser(final ClientInfo client, final SrvSession sess, final int alg) {
        int authSts;
        block17: {
            if (!(client instanceof AlfrescoClientInfo)) {
                return -1;
            }
            AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
            if (client.isNullSession() && sess instanceof SMBSrvSession) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Null CIFS logon allowed");
                }
                return 0;
            }
            try {
                if (alfClient.hasAuthenticationTicket() && client.getLogonType() != 2) {
                    this.getAuthenticationService().validate(alfClient.getAuthenticationTicket());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Re-using existing authentication token");
                    }
                    return client.getLogonType() != 1 ? 0 : 0x10000000;
                }
            }
            catch (AuthenticationException ex) {
                alfClient.setAuthenticationTicket(null);
            }
            authSts = -1;
            try {
                if (client.isGuest() || client.getUserName().equalsIgnoreCase(this.getGuestUserName())) {
                    if (!this.allowGuest()) {
                        return -1;
                    }
                    this.doGuestLogon(client, sess);
                    authSts = 0x10000000;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Authenticated user " + client.getUserName() + " sts=" + this.getStatusAsString(authSts)));
                    }
                    return authSts;
                }
                authSts = this.getNTLMAuthenticator().getNTLMMode() == NTLMMode.MD4_PROVIDER ? this.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                    @Override
                    public Integer execute() throws Throwable {
                        return AlfrescoCifsAuthenticator.this.doMD4UserAuthentication(client, sess, alg);
                    }
                }).intValue() : this.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                    @Override
                    public Integer execute() throws Throwable {
                        return AlfrescoCifsAuthenticator.this.doPassthruUserAuthentication(client, sess, alg);
                    }
                }).intValue();
                if (authSts == 0x10000000) {
                    if (this.mapUnknownUserToGuest()) {
                        this.doGuestLogon(client, sess);
                    } else {
                        authSts = -1;
                    }
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block17;
                logger.debug((Object)ex);
            }
        }
        if (authSts == 0 && client.getLogonType() == 0) {
            this.checkForAdminUserName(client);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authenticated user " + client.getUserName() + " sts=" + this.getStatusAsString(authSts) + " via " + (this.getNTLMAuthenticator().getNTLMMode() == NTLMMode.MD4_PROVIDER ? "MD4" : "Passthru")));
        }
        return authSts;
    }

    public int authenticateShareConnect(ClientInfo client, SharedDevice share, String sharePwd, SrvSession sess) {
        return 2;
    }

    public AuthContext getAuthContext(SMBSrvSession sess) {
        Object authCtx = null;
        if (sess.hasAuthenticationContext() && sess.getClientInformation().getLogonType() != 2) {
            authCtx = sess.getAuthenticationContext();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Re-using existing challenge, already authenticated");
            }
        } else if (this.getNTLMAuthenticator().getNTLMMode() == NTLMMode.MD4_PROVIDER) {
            authCtx = new NTLanManAuthContext();
            sess.setAuthenticationContext(authCtx);
        } else {
            NTLMPassthruToken authToken = new NTLMPassthruToken(this.mapClientAddressToDomain(sess.getRemoteAddress()));
            this.getNTLMAuthenticator().authenticate((Authentication)authToken);
            authCtx = new AuthTokenAuthContext(authToken);
            sess.setAuthenticationContext(authCtx);
        }
        return authCtx;
    }

    private final int doMD4UserAuthentication(ClientInfo client, SrvSession sess, int alg) {
        String md4hash = this.getNTLMAuthenticator().getMD4HashedPassword(client.getUserName());
        if (md4hash != null) {
            if (client.getPassword() == null) {
                return -2;
            }
            try {
                byte[] p21 = new byte[21];
                byte[] md4byts = null;
                md4byts = this.m_md4Encoder.decodeHash(md4hash);
                System.arraycopy(md4byts, 0, p21, 0, 16);
                NTLanManAuthContext authCtx = null;
                if (!sess.hasAuthenticationContext() || !(sess.getAuthenticationContext() instanceof NTLanManAuthContext)) {
                    return -1;
                }
                authCtx = (NTLanManAuthContext)sess.getAuthenticationContext();
                byte[] localHash = this.getEncryptor().doNTLM1Encryption(p21, authCtx.getChallenge());
                byte[] clientHash = client.getPassword();
                if (clientHash == null || clientHash.length != 24) {
                    clientHash = client.getANSIPassword();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using secondary password hash - " + HexDump.hexString((byte[])clientHash)));
                        logger.debug((Object)("                   Local hash - " + HexDump.hexString((byte[])localHash)));
                    }
                }
                if (clientHash == null || clientHash.length != localHash.length) {
                    return -2;
                }
                for (int i = 0; i < clientHash.length; ++i) {
                    if (clientHash[i] == localHash[i]) continue;
                    return -2;
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Logged on user " + client.getUserName() + " (" + sess.getRemoteAddress() + ")"));
                }
                AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
                this.getAuthenticationComponent().setCurrentUser(client.getUserName());
                alfClient.setAuthenticationTicket(this.getAuthenticationService().getCurrentTicket());
                this.getHomeFolderForUser(client);
                client.setLogonType(0);
                return 0;
            }
            catch (AuthenticationException ex) {
            }
            catch (NoSuchAlgorithmException ex) {
                // empty catch block
            }
            return -1;
        }
        if (client.isNullSession() && sess instanceof SMBSrvSession) {
            return 0;
        }
        return this.allowGuest() ? 0x10000000 : -1;
    }

    private final int doPassthruUserAuthentication(ClientInfo client, SrvSession sess, int alg) {
        int authSts = -1;
        AuthContext authCtx = sess.getAuthenticationContext();
        if (authCtx == null || !(authCtx instanceof AuthTokenAuthContext)) {
            return -1;
        }
        AuthTokenAuthContext tokenCtx = (AuthTokenAuthContext)authCtx;
        NTLMPassthruToken authToken = tokenCtx.getToken();
        if (authToken == null) {
            return -1;
        }
        byte[] hashedPassword = null;
        if (alg == 1) {
            hashedPassword = client.getPassword();
        } else if (alg == 0) {
            hashedPassword = client.getANSIPassword();
        } else {
            return -1;
        }
        authToken.setUserAndPassword(client.getUserName(), hashedPassword, alg);
        String ticket = null;
        try {
            this.getNTLMAuthenticator().authenticate((Authentication)authToken);
            ticket = this.getAuthenticationService().getCurrentTicket();
            if (authToken.isGuestLogon()) {
                if (this.allowGuest()) {
                    authSts = 0x10000000;
                    client.setLogonType(1);
                }
            } else {
                authSts = 0;
                client.setLogonType(0);
            }
            AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
            alfClient.setAuthenticationTicket(ticket);
            this.getHomeFolderForUser(client);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Auth ticket " + ticket));
            }
        }
        catch (AuthenticationException ex) {
        }
        catch (Exception ex) {
            logger.error((Object)"Error during passthru authentication", (Throwable)ex);
        }
        sess.setAuthenticationContext(null);
        return authSts;
    }
}

