/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.debug;

import org.alfresco.jlan.debug.DebugInterfaceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

public class FileServerDebugInterface
extends DebugInterfaceBase {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.fileserver");
    private StringBuilder m_printBuf = new StringBuilder(120);

    public void debugPrint(String str, int level) {
        if (level <= this.getLogLevel()) {
            this.m_printBuf.append(str);
        }
    }

    public void debugPrintln(String str, int level) {
        if (level <= this.getLogLevel()) {
            if (this.m_printBuf.length() > 0) {
                this.m_printBuf.append(str);
                this.logOutput(this.m_printBuf.toString(), level);
                this.m_printBuf.setLength(0);
            } else {
                this.logOutput(str, level);
            }
        }
    }

    public void debugPrintln(Throwable ex, int level) {
        if (level <= this.getLogLevel()) {
            switch (level) {
                case 4: {
                    logger.debug((Object)ex, ex);
                    break;
                }
                case 3: {
                    logger.info((Object)ex, ex);
                    break;
                }
                case 2: {
                    logger.warn((Object)ex, ex);
                    break;
                }
                case 0: {
                    logger.fatal((Object)ex, ex);
                    break;
                }
                case 1: {
                    logger.error((Object)ex, ex);
                }
            }
        }
    }

    protected void logOutput(String str, int level) {
        switch (level) {
            case 4: {
                logger.debug((Object)str);
                break;
            }
            case 3: {
                logger.info((Object)str);
                break;
            }
            case 2: {
                logger.warn((Object)str);
                break;
            }
            case 0: {
                logger.fatal((Object)str);
                break;
            }
            case 1: {
                logger.error((Object)str);
            }
        }
    }

    public void initialize(ConfigElement params) throws Exception {
        int logLevel = 1;
        if (logger.isDebugEnabled()) {
            logLevel = 4;
        } else if (logger.isInfoEnabled()) {
            logLevel = 3;
        } else if (logger.isWarnEnabled()) {
            logLevel = 2;
        } else if (logger.isErrorEnabled()) {
            logLevel = 1;
        } else if (logger.isFatalEnabled()) {
            logLevel = 0;
        }
        this.setLogLevel(logLevel);
    }
}

