/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.desk;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoDiskDriver;
import org.alfresco.filesys.alfresco.DesktopAction;
import org.alfresco.filesys.alfresco.DesktopParams;
import org.alfresco.filesys.alfresco.DesktopResponse;
import org.alfresco.filesys.alfresco.DesktopTarget;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.smb.server.notify.NotifyChangeHandler;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.Pair;

public class CheckInOutDesktopAction
extends DesktopAction {
    public CheckInOutDesktopAction() {
        super(21, 7);
    }

    public String getConfirmationString() {
        return "Run check in/out action";
    }

    public DesktopResponse runAction(final DesktopParams params) {
        DesktopResponse response;
        if (params.numberOfTargetNodes() == 0) {
            return new DesktopResponse(0);
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WriteTxn
        implements AlfrescoDiskDriver.CallableIO<DesktopResponse> {
            private List<Pair<Integer, String>> fileChanges;

            WriteTxn() {
            }

            @Override
            public DesktopResponse call() throws IOException {
                this.fileChanges = new LinkedList<Pair<Integer, String>>();
                ServiceRegistry serviceRegistry = CheckInOutDesktopAction.this.getServiceRegistry();
                NodeService nodeService = serviceRegistry.getNodeService();
                CheckOutCheckInService checkOutCheckInService = serviceRegistry.getCheckOutCheckInService();
                DesktopResponse response = new DesktopResponse(0);
                for (int idx = 0; idx < params.numberOfTargetNodes(); ++idx) {
                    DesktopTarget target = params.getTarget(idx);
                    if (nodeService.hasAspect(target.getNode(), ContentModel.ASPECT_WORKING_COPY)) {
                        try {
                            HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
                            checkOutCheckInService.checkin(target.getNode(), versionProperties, null, false);
                            if (!CheckInOutDesktopAction.this.getContext().hasFileServerNotifications()) continue;
                            String fileName = null;
                            fileName = target.getTarget().startsWith("\\") ? target.getTarget() : FileName.buildPath((String)params.getFolder().getFullName(), null, (String)target.getTarget(), (char)'\\');
                            this.fileChanges.add((Pair<Integer, String>)new Pair((Object)2, (Object)fileName));
                        }
                        catch (Exception ex) {
                            if (RetryingTransactionHelper.extractRetryCause(ex) != null) {
                                if (ex instanceof RuntimeException) {
                                    throw (RuntimeException)ex;
                                }
                                throw new AlfrescoRuntimeException("Desktop action error", (Throwable)ex);
                            }
                            if (logger.isErrorEnabled()) {
                                logger.error((Object)"Desktop action error", (Throwable)ex);
                            }
                            response.setStatus(1, "Checkin failed for " + target.getTarget() + ", " + ex.getMessage());
                        }
                        continue;
                    }
                    try {
                        FileState fstate;
                        String lockTypeStr;
                        if (nodeService.hasAspect(target.getNode(), ContentModel.ASPECT_LOCKABLE) && (lockTypeStr = (String)((Object)nodeService.getProperty(target.getNode(), ContentModel.PROP_LOCK_TYPE))) != null) {
                            response.setStatus(1, "Checkout failed, file is locked");
                            return response;
                        }
                        NodeRef workingCopyNode = checkOutCheckInService.checkout(target.getNode());
                        String workingCopyName = (String)((Object)nodeService.getProperty(workingCopyNode, ContentModel.PROP_NAME));
                        response.setStatus(0, "Checked out working copy " + workingCopyName);
                        String fileName = FileName.buildPath((String)params.getFolder().getFullName(), null, (String)workingCopyName, (char)'\\');
                        FileStateCache stateCache = CheckInOutDesktopAction.this.getContext().getStateCache();
                        if (stateCache != null && (fstate = stateCache.findFileState(fileName)) != null) {
                            fstate.setFileStatus(1);
                        }
                        if (!CheckInOutDesktopAction.this.getContext().hasChangeHandler()) continue;
                        this.fileChanges.add((Pair<Integer, String>)new Pair((Object)1, (Object)fileName));
                        continue;
                    }
                    catch (Exception ex) {
                        if (RetryingTransactionHelper.extractRetryCause(ex) != null) {
                            if (ex instanceof RuntimeException) {
                                throw (RuntimeException)ex;
                            }
                            throw new AlfrescoRuntimeException("Desktop action error", (Throwable)ex);
                        }
                        if (logger.isErrorEnabled()) {
                            logger.error((Object)"Desktop action error", (Throwable)ex);
                        }
                        response.setStatus(1, "Failed to checkout " + target.getTarget() + ", " + ex.getMessage());
                    }
                }
                return response;
            }

            public void notifyChanges() {
                NotifyChangeHandler notifyChangeHandler = CheckInOutDesktopAction.this.getContext().getChangeHandler();
                for (Pair<Integer, String> fileChange : this.fileChanges) {
                    notifyChangeHandler.notifyFileChanged(((Integer)fileChange.getFirst()).intValue(), (String)fileChange.getSecond());
                }
            }
        }
        WriteTxn callback = new WriteTxn();
        try {
            response = params.getDriver().doInWriteTransaction(params.getSession(), callback);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Desktop action error", (Throwable)e);
        }
        callback.notifyChanges();
        return response;
    }
}

