/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.dictionary;

import java.util.ArrayList;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.alfresco.jcr.dictionary.DataTypeMap;
import org.alfresco.jcr.dictionary.JCRNamespace;
import org.alfresco.jcr.dictionary.NodeDefinitionImpl;
import org.alfresco.jcr.dictionary.NodeTypeManagerImpl;
import org.alfresco.jcr.dictionary.PropertyDefinitionImpl;
import org.alfresco.jcr.item.ValueImpl;
import org.alfresco.jcr.item.property.JCRMixinTypesProperty;
import org.alfresco.jcr.item.property.JCRPrimaryTypeProperty;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class NodeTypeImpl
implements NodeType {
    public static QName NT_BASE = QName.createQName((String)JCRNamespace.NT_URI, (String)"base");
    public static QName MIX_REFERENCEABLE = QName.createQName((String)JCRNamespace.MIX_URI, (String)"referenceable");
    public static QName MIX_LOCKABLE = QName.createQName((String)JCRNamespace.MIX_URI, (String)"lockable");
    public static QName MIX_VERSIONABLE = QName.createQName((String)JCRNamespace.MIX_URI, (String)"versionable");
    private NodeTypeManagerImpl typeManager;
    private ClassDefinition classDefinition;

    public NodeTypeImpl(NodeTypeManagerImpl typeManager, ClassDefinition classDefinition) {
        this.typeManager = typeManager;
        this.classDefinition = classDefinition;
    }

    public String getName() {
        return this.classDefinition.getName().toPrefixString((NamespacePrefixResolver)this.typeManager.getNamespaceService());
    }

    public boolean isMixin() {
        return this.classDefinition.isAspect();
    }

    public boolean hasOrderableChildNodes() {
        return false;
    }

    public String getPrimaryItemName() {
        return null;
    }

    public NodeType[] getSupertypes() {
        ArrayList<NodeType> nodeTypes = new ArrayList<NodeType>();
        NodeType[] declaredSupertypes = this.getDeclaredSupertypes();
        while (declaredSupertypes.length > 0) {
            NodeType supertype = declaredSupertypes[0];
            nodeTypes.add(supertype);
            declaredSupertypes = supertype.getDeclaredSupertypes();
        }
        return nodeTypes.toArray(new NodeType[nodeTypes.size()]);
    }

    public NodeType[] getDeclaredSupertypes() {
        if (this.classDefinition.getName().equals((Object)NT_BASE)) {
            return new NodeType[0];
        }
        QName parent = this.classDefinition.getParentName();
        if (parent == null) {
            if (this.classDefinition.isAspect()) {
                return new NodeType[0];
            }
            return new NodeType[]{this.typeManager.getNodeTypeImpl(NT_BASE)};
        }
        return new NodeType[]{this.typeManager.getNodeTypeImpl(parent)};
    }

    public boolean isNodeType(String nodeTypeName) {
        QName name = QName.createQName((String)nodeTypeName, (NamespacePrefixResolver)this.typeManager.getNamespaceService());
        if (name.equals((Object)NT_BASE)) {
            return true;
        }
        return this.typeManager.getSession().getRepositoryImpl().getServiceRegistry().getDictionaryService().isSubClass(name, this.classDefinition.getName());
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        Map propDefs = this.classDefinition.getProperties();
        PropertyDefinition[] defs = new PropertyDefinition[propDefs.size() + (this.classDefinition.isAspect() ? 0 : 2)];
        int i = 0;
        for (org.alfresco.service.cmr.dictionary.PropertyDefinition propDef : propDefs.values()) {
            defs[i++] = new PropertyDefinitionImpl(this.typeManager, propDef);
        }
        if (!this.classDefinition.isAspect()) {
            defs[i++] = this.typeManager.getPropertyDefinitionImpl(JCRPrimaryTypeProperty.PROPERTY_NAME);
            defs[i++] = this.typeManager.getPropertyDefinitionImpl(JCRMixinTypesProperty.PROPERTY_NAME);
        }
        return defs;
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        Map propDefs = this.classDefinition.getProperties();
        ArrayList<PropertyDefinitionImpl> defs = new ArrayList<PropertyDefinitionImpl>();
        for (org.alfresco.service.cmr.dictionary.PropertyDefinition propDef : propDefs.values()) {
            if (!propDef.getContainerClass().equals(this.classDefinition)) continue;
            defs.add(new PropertyDefinitionImpl(this.typeManager, propDef));
        }
        if (this.classDefinition.equals(NT_BASE)) {
            defs.add(this.typeManager.getPropertyDefinitionImpl(JCRPrimaryTypeProperty.PROPERTY_NAME));
            defs.add(this.typeManager.getPropertyDefinitionImpl(JCRMixinTypesProperty.PROPERTY_NAME));
        }
        return defs.toArray(new PropertyDefinition[defs.size()]);
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        Map assocDefs = this.classDefinition.getChildAssociations();
        NodeDefinition[] defs = new NodeDefinition[assocDefs.size()];
        int i = 0;
        for (ChildAssociationDefinition assocDef : assocDefs.values()) {
            defs[i++] = new NodeDefinitionImpl(this.typeManager, assocDef);
        }
        return defs;
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        Map assocDefs = this.classDefinition.getChildAssociations();
        ArrayList<NodeDefinitionImpl> defs = new ArrayList<NodeDefinitionImpl>();
        for (ChildAssociationDefinition assocDef : assocDefs.values()) {
            if (!assocDef.getSourceClass().equals(this.classDefinition)) continue;
            defs.add(new NodeDefinitionImpl(this.typeManager, assocDef));
        }
        return defs.toArray(new NodeDefinition[defs.size()]);
    }

    public boolean canSetProperty(String propertyName, Value value) {
        try {
            if (value == null) {
                return this.canRemoveItem(propertyName);
            }
            QName propertyQName = QName.createQName((String)propertyName, (NamespacePrefixResolver)this.typeManager.getNamespaceService());
            Map propDefs = this.classDefinition.getProperties();
            org.alfresco.service.cmr.dictionary.PropertyDefinition propDef = (org.alfresco.service.cmr.dictionary.PropertyDefinition)propDefs.get(propertyQName);
            if (propDef == null) {
                return false;
            }
            if (propDef.isProtected() || propDef.isMultiValued()) {
                return false;
            }
            int requiredType = DataTypeMap.convertDataTypeToPropertyType(propDef.getDataType().getName());
            if (requiredType == 0) {
                requiredType = value.getType();
            }
            ValueImpl.getValue(this.typeManager.getSession().getTypeConverter(), requiredType, value);
            return true;
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        try {
            if (values == null) {
                return this.canRemoveItem(propertyName);
            }
            QName propertyQName = QName.createQName((String)propertyName, (NamespacePrefixResolver)this.typeManager.getNamespaceService());
            Map propDefs = this.classDefinition.getProperties();
            org.alfresco.service.cmr.dictionary.PropertyDefinition propDef = (org.alfresco.service.cmr.dictionary.PropertyDefinition)propDefs.get(propertyQName);
            if (propDef == null) {
                return false;
            }
            if (propDef.isProtected() || !propDef.isMultiValued()) {
                return false;
            }
            int valueType = 0;
            for (Value value : values) {
                if (value == null) continue;
                if (valueType != 0 && value.getType() != valueType) {
                    return false;
                }
                valueType = value.getType();
            }
            int requiredType = DataTypeMap.convertDataTypeToPropertyType(propDef.getDataType().getName());
            if (requiredType == 0) {
                requiredType = valueType;
            }
            for (Value value : values) {
                if (value == null) continue;
                ValueImpl.getValue(this.typeManager.getSession().getTypeConverter(), requiredType, value);
            }
            return true;
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    public boolean canAddChildNode(String childNodeName) {
        return false;
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        QName childNodeQName;
        boolean canAdd = false;
        Map assocDefs = this.classDefinition.getChildAssociations();
        ChildAssociationDefinition assocDef = (ChildAssociationDefinition)assocDefs.get(childNodeQName = QName.createQName((String)childNodeName, (NamespacePrefixResolver)this.typeManager.getNamespaceService()));
        if (assocDef != null) {
            QName nodeTypeQName = QName.createQName((String)nodeTypeName, (NamespacePrefixResolver)this.typeManager.getNamespaceService());
            DictionaryService dictionaryService = this.typeManager.getSession().getRepositoryImpl().getServiceRegistry().getDictionaryService();
            canAdd = dictionaryService.isSubClass(nodeTypeQName, assocDef.getTargetClass().getName());
        }
        return canAdd;
    }

    public boolean canRemoveItem(String itemName) {
        Map assocDefs;
        ChildAssociationDefinition assocDef;
        boolean isProtected = false;
        boolean isMandatory = false;
        QName itemQName = QName.createQName((String)itemName, (NamespacePrefixResolver)this.typeManager.getNamespaceService());
        Map propDefs = this.classDefinition.getProperties();
        org.alfresco.service.cmr.dictionary.PropertyDefinition propDef = (org.alfresco.service.cmr.dictionary.PropertyDefinition)propDefs.get(itemQName);
        if (propDef != null) {
            isProtected = propDef.isProtected();
            isMandatory = propDef.isMandatory();
        }
        if ((assocDef = (ChildAssociationDefinition)(assocDefs = this.classDefinition.getChildAssociations()).get(itemQName)) != null) {
            isProtected |= assocDef.isProtected();
            isMandatory |= assocDef.isTargetMandatory();
        }
        return !isProtected && !isMandatory;
    }
}

