/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.util.List;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.BaseParameterizedItemImplTest;
import org.alfresco.repo.action.ParameterizedItemImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.util.GUID;

public class ActionImplTest
extends BaseParameterizedItemImplTest {
    private static final String ID_COND1 = "idCond1";
    private static final String ID_COND2 = "idCond2";
    private static final String ID_COND3 = "idCond3";
    private static final String NAME_COND1 = "nameCond1";
    private static final String NAME_COND2 = "nameCond2";
    private static final String NAME_COND3 = "nameCond3";

    protected ParameterizedItemImpl create() {
        return new ActionImpl(null, "id", "name", this.paramValues);
    }

    public void testGetRuleActionDefintion() {
        Action temp = (Action)((Object)this.create());
        ActionImplTest.assertEquals((String)"name", (String)temp.getActionDefinitionName());
    }

    public void testSimpleProperties() {
        Action action = (Action)((Object)this.create());
        ActionImplTest.assertFalse((boolean)action.getExecuteAsychronously());
        ActionImplTest.assertNull((Object)action.getCompensatingAction());
        action.setTitle("title");
        action.setDescription("description");
        action.setExecuteAsynchronously(true);
        ActionImpl compensatingAction = new ActionImpl(null, GUID.generate(), "actionDefintionName", null);
        action.setCompensatingAction(compensatingAction);
        ActionImplTest.assertEquals((String)"title", (String)action.getTitle());
        ActionImplTest.assertEquals((String)"description", (String)action.getDescription());
        ActionImplTest.assertTrue((boolean)action.getExecuteAsychronously());
        ActionImplTest.assertEquals((Object)compensatingAction, (Object)action.getCompensatingAction());
    }

    public void testActionConditions() {
        ActionConditionImpl cond1 = new ActionConditionImpl(ID_COND1, NAME_COND1, this.paramValues);
        ActionConditionImpl cond2 = new ActionConditionImpl(ID_COND2, NAME_COND2, this.paramValues);
        ActionConditionImpl cond3 = new ActionConditionImpl(ID_COND3, NAME_COND3, this.paramValues);
        Action action = (Action)((Object)this.create());
        ActionImplTest.assertFalse((boolean)action.hasActionConditions());
        List<ActionCondition> noConditions = action.getActionConditions();
        ActionImplTest.assertNotNull(noConditions);
        ActionImplTest.assertEquals((int)0, (int)noConditions.size());
        action.addActionCondition(cond1);
        action.addActionCondition(cond2);
        action.addActionCondition(cond3);
        ActionImplTest.assertTrue((boolean)action.hasActionConditions());
        List<ActionCondition> actionConditions = action.getActionConditions();
        ActionImplTest.assertNotNull(actionConditions);
        ActionImplTest.assertEquals((int)3, (int)actionConditions.size());
        int counter = 0;
        for (ActionCondition condition : actionConditions) {
            if (counter == 0) {
                ActionImplTest.assertEquals((Object)cond1, (Object)condition);
            } else if (counter == 1) {
                ActionImplTest.assertEquals((Object)cond2, (Object)condition);
            } else if (counter == 2) {
                ActionImplTest.assertEquals((Object)cond3, (Object)condition);
            }
            ++counter;
        }
        ActionImplTest.assertEquals((Object)cond1, (Object)action.getActionCondition(0));
        ActionImplTest.assertEquals((Object)cond2, (Object)action.getActionCondition(1));
        ActionImplTest.assertEquals((Object)cond3, (Object)action.getActionCondition(2));
        action.removeActionCondition(cond3);
        ActionImplTest.assertEquals((int)2, (int)action.getActionConditions().size());
        action.setActionCondition(1, cond3);
        ActionImplTest.assertEquals((Object)cond1, (Object)action.getActionCondition(0));
        ActionImplTest.assertEquals((Object)cond3, (Object)action.getActionCondition(1));
        ActionImplTest.assertEquals((int)0, (int)action.indexOfActionCondition(cond1));
        ActionImplTest.assertEquals((int)1, (int)action.indexOfActionCondition(cond3));
        action.addActionCondition(1, cond2);
        ActionImplTest.assertEquals((int)3, (int)action.getActionConditions().size());
        ActionImplTest.assertEquals((Object)cond1, (Object)action.getActionCondition(0));
        ActionImplTest.assertEquals((Object)cond2, (Object)action.getActionCondition(1));
        ActionImplTest.assertEquals((Object)cond3, (Object)action.getActionCondition(2));
        action.removeAllActionConditions();
        ActionImplTest.assertFalse((boolean)action.hasActionConditions());
        ActionImplTest.assertEquals((int)0, (int)action.getActionConditions().size());
    }
}

