/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.service.license.LicenseService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysAdminParamsImpl
implements SysAdminParams,
ApplicationContextAware,
InitializingBean {
    private static final String TOKEN_LOCAL_NAME = "${localname}";
    private final String localName;
    private ApplicationContext ctx;
    private Integer maxUsers;
    private List<String> allowedUsers;
    private boolean allowWrite = true;
    private String alfrescoContext = "alfresco";
    private String alfrescoHost = "localhost";
    private int alfrescoPort = 8080;
    private String alfrescoProtocol = "http";
    private String shareContext = "alfresco";
    private String shareHost = "localhost";
    private int sharePort = 8080;
    private String shareProtocol = "http";
    private String sitePublicGroup = "GROUP_EVERYONE";

    public SysAdminParamsImpl() {
        String srvName = "localhost";
        try {
            srvName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            srvName = "localhost";
        }
        this.localName = srvName;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.allowWrite) {
            LicenseService licenseService = null;
            try {
                licenseService = (LicenseService)this.ctx.getBean("licenseService");
                this.allowWrite = licenseService.isLicenseValid();
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    public void setAllowedUsers(String allowedUsers) {
        StringTokenizer tkn = new StringTokenizer(allowedUsers, ",");
        int length = tkn.countTokens();
        if (length > 0) {
            this.allowedUsers = new ArrayList<String>(length);
            while (tkn.hasMoreTokens()) {
                this.allowedUsers.add(tkn.nextToken().trim());
            }
        }
    }

    @Override
    public List<String> getAllowedUserList() {
        return this.allowedUsers;
    }

    public void setMaxUsers(int maxUsers) {
        this.maxUsers = new Integer(maxUsers);
    }

    @Override
    public int getMaxUsers() {
        return this.maxUsers;
    }

    public void setAllowWrite(boolean allowWrite) {
        this.allowWrite = allowWrite;
    }

    @Override
    public boolean getAllowWrite() {
        return this.allowWrite;
    }

    @Override
    public String getAlfrescoContext() {
        return this.alfrescoContext;
    }

    public void setAlfrescoContext(String alfrescoContext) {
        this.alfrescoContext = alfrescoContext;
    }

    @Override
    public String getAlfrescoHost() {
        return this.alfrescoHost;
    }

    public void setAlfrescoHost(String alfrescoHost) {
        this.alfrescoHost = this.subsituteHost(alfrescoHost);
    }

    @Override
    public int getAlfrescoPort() {
        return this.alfrescoPort;
    }

    public void setAlfrescoPort(int alfrescoPort) {
        this.alfrescoPort = alfrescoPort;
    }

    @Override
    public String getAlfrescoProtocol() {
        return this.alfrescoProtocol;
    }

    public void setAlfrescoProtocol(String alfrescoProtocol) {
        this.alfrescoProtocol = alfrescoProtocol;
    }

    @Override
    public String getShareContext() {
        return this.shareContext;
    }

    public void setShareContext(String shareContext) {
        this.shareContext = shareContext;
    }

    @Override
    public String getShareHost() {
        return this.shareHost;
    }

    public void setShareHost(String shareHost) {
        this.shareHost = this.subsituteHost(shareHost);
    }

    @Override
    public int getSharePort() {
        return this.sharePort;
    }

    public void setSharePort(int sharePort) {
        this.sharePort = sharePort;
    }

    @Override
    public String getShareProtocol() {
        return this.shareProtocol;
    }

    public void setShareProtocol(String shareProtocol) {
        this.shareProtocol = shareProtocol;
    }

    @Override
    public String subsituteHost(String hostName) {
        return hostName.replace(TOKEN_LOCAL_NAME, this.localName);
    }

    @Override
    public String getSitePublicGroup() {
        return this.sitePublicGroup;
    }

    public void setSitePublicGroup(String sitePublicGroup) {
        this.sitePublicGroup = sitePublicGroup;
    }
}

