/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.mbeans.VirtServerRegistry;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.wcm.sandbox.SandboxFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMExpiredContentProcessor {
    protected String workflowName = "jbpm$wcmwf:changerequest";
    protected List<String> workflowStores;
    protected Map<String, Map<String, List<String>>> expiredContent;
    protected AVMService avmService;
    protected AVMSyncService avmSyncService;
    protected AVMService avmLockingAwareService;
    protected AVMLockingService avmLockingService;
    protected NodeService nodeService;
    protected WorkflowService workflowService;
    protected PersonService personService;
    protected PermissionService permissionService;
    protected TransactionService transactionService;
    protected VirtServerRegistry virtServerRegistry;
    protected SearchService searchService;
    private SandboxFactory sandboxFactory;
    private static Log logger = LogFactory.getLog(AVMExpiredContentProcessor.class);
    private static final String STORE_SEPARATOR = "--";
    private static final Pattern STORE_RELATIVE_PATH_PATTERN = Pattern.compile("[^:]+:(.+)");

    public void setAdminUserName(String adminUserName) {
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setAvmLockingService(AVMLockingService avmLockingService) {
        this.avmLockingService = avmLockingService;
    }

    public void setAvmSyncService(AVMSyncService avmSyncService) {
        this.avmSyncService = avmSyncService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setVirtServerRegistry(VirtServerRegistry virtServerRegistry) {
        this.virtServerRegistry = virtServerRegistry;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setAvmLockingAwareService(AVMService avmLockingAwareService) {
        this.avmLockingAwareService = avmLockingAwareService;
    }

    public void setSandboxFactory(SandboxFactory sandboxFactory) {
        this.sandboxFactory = sandboxFactory;
    }

    public void execute() {
        AuthenticationUtil.RunAsWork<String> authorisedWork = new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                RetryingTransactionHelper.RetryingTransactionCallback<String> expiredContentWork = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                    @Override
                    public String execute() throws Exception {
                        AVMExpiredContentProcessor.this.processExpiredContent();
                        return null;
                    }
                };
                return AVMExpiredContentProcessor.this.transactionService.getRetryingTransactionHelper().doInTransaction(expiredContentWork);
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)authorisedWork, (String)AuthenticationUtil.getAdminUserName());
        for (String path : this.workflowStores) {
            this.virtServerRegistry.updateAllWebapps(-1, path, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpiredContent() {
        this.expiredContent = new HashMap<String, Map<String, List<String>>>(8);
        this.workflowStores = new ArrayList<String>(4);
        List<AVMStoreDescriptor> stores = this.avmService.getStores();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking " + stores.size() + " AVM stores..."));
        }
        for (AVMStoreDescriptor storeDesc : stores) {
            String storeName = storeDesc.getName();
            PropertyValue val = this.avmService.getStoreProperty(storeName, SandboxConstants.PROP_SANDBOX_STAGING_MAIN);
            if (val != null) {
                Object var15_14;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Searching store '" + storeName + "' for expired content..."));
                }
                Calendar cal = Calendar.getInstance();
                StringBuilder query = new StringBuilder("@wca\\:expirationDate:[0001\\-01\\-01T00:00:00 TO ");
                query.append(cal.get(1));
                query.append("\\-");
                query.append(cal.get(2) + 1);
                query.append("\\-");
                query.append(cal.get(5));
                query.append("T00:00:00]");
                StoreRef storeRef = new StoreRef("avm", storeName);
                ResultSet results = this.searchService.query(storeRef, "lucene", query.toString());
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found " + results.length() + " potential expired item(s) in store '" + storeName + "'"));
                    }
                    if (results.length() > 0) {
                        for (NodeRef resultNode : results.getNodeRefs()) {
                            Pair<Integer, String> path = AVMNodeConverter.ToAVMVersionPath(resultNode);
                            AVMNodeDescriptor node = this.avmService.lookup((Integer)path.getFirst(), (String)path.getSecond());
                            this.processNode(storeName, node);
                        }
                    }
                    var15_14 = null;
                }
                catch (Throwable throwable) {
                    var15_14 = null;
                    results.close();
                    throw throwable;
                }
                results.close();
                {
                    continue;
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Skipping store '" + storeName + "' as it is not a main staging store"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Expired content to action:\n" + this.expiredContent));
        }
        for (String storeName : this.expiredContent.keySet()) {
            NodeRef webProjectNodeRef = (NodeRef)this.avmService.getStoreProperty(storeName, SandboxConstants.PROP_WEB_PROJECT_NODE_REF).getValue(DataTypeDefinition.NODE_REF);
            String webProjectName = (String)((Object)this.nodeService.getProperty(webProjectNodeRef, ContentModel.PROP_NAME));
            String pattern = I18NUtil.getMessage((String)"expiredcontent.workflow.title");
            String workflowTitle = MessageFormat.format(pattern, webProjectName);
            Map<String, List<String>> users = this.expiredContent.get(storeName);
            for (String userName : users.keySet()) {
                List<String> expiredContent = users.get(userName);
                this.startWorkflow(userName, storeName, expiredContent, workflowTitle);
            }
        }
    }

    private void processNode(String storeName, AVMNodeDescriptor node) {
        if (node.isFile()) {
            String nodePath = node.getPath();
            PropertyValue expirationDateProp = this.avmService.getNodeProperty(-1, nodePath, WCMAppModel.PROP_EXPIRATIONDATE);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Examining expiration date for '" + nodePath + "': " + expirationDateProp));
            }
            if (expirationDateProp != null) {
                Date now = new Date();
                Date expirationDate = (Date)expirationDateProp.getValue(DataTypeDefinition.DATETIME);
                if (expirationDate != null && expirationDate.before(now)) {
                    String[] splitPath = nodePath.split(":");
                    String lockOwner = this.avmLockingService.getLockOwner(storeName, splitPath[1]);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("lock details for '" + nodePath + "': " + lockOwner));
                    }
                    if (lockOwner == null) {
                        String modifier;
                        List<String> userExpiredContent;
                        Map<String, List<String>> storeExpiredContent = this.expiredContent.get(storeName);
                        if (storeExpiredContent == null) {
                            storeExpiredContent = new HashMap<String, List<String>>(4);
                            this.expiredContent.put(storeName, storeExpiredContent);
                        }
                        if ((userExpiredContent = storeExpiredContent.get(modifier = node.getLastModifier())) == null) {
                            userExpiredContent = new ArrayList<String>(4);
                            storeExpiredContent.put(modifier, userExpiredContent);
                        }
                        userExpiredContent.add(nodePath);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Added " + nodePath + " to " + modifier + "'s list of expired content"));
                        }
                        this.avmService.setNodeProperty(nodePath, WCMAppModel.PROP_EXPIRATIONDATE, new PropertyValue(DataTypeDefinition.DATETIME, null));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Reset expiration date for: " + nodePath));
                        }
                    } else if (logger.isWarnEnabled()) {
                        logger.warn((Object)("ignoring '" + nodePath + "', although it has expired, it's currently locked"));
                    }
                }
            }
        }
    }

    private void startWorkflow(String userName, String storeName, List<String> expiredContent, String workflowTitle) {
        List<WorkflowTask> tasks;
        WorkflowDefinition wfDef = this.workflowService.getDefinitionByName(this.workflowName);
        WorkflowPath path = this.workflowService.startWorkflow(wfDef.id, null);
        if (path != null && (tasks = this.workflowService.getTasksForWorkflowPath(path.id)).size() == 1) {
            WorkflowTask startTask = tasks.get(0);
            if (startTask.state == WorkflowTaskState.IN_PROGRESS) {
                String userStore = storeName + STORE_SEPARATOR + userName;
                if (this.avmService.getStore(userStore) == null) {
                    String storeCreator = this.avmService.getStore(storeName).getCreator();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("'" + userName + "' is no longer assigned to web project. Using '" + storeCreator + "' as they created store '" + storeName + "'"));
                    }
                    userName = storeCreator;
                    userStore = storeName + STORE_SEPARATOR + userName;
                }
                NodeRef assignee = this.personService.getPerson(userName);
                String workflowStoreName = this.sandboxFactory.createUserWorkflowSandbox(storeName, userStore);
                NodeRef workflowPackage = this.setupWorkflowPackage(workflowStoreName, expiredContent);
                HashMap<QName, Serializable> params = new HashMap<QName, Serializable>(5);
                params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)workflowPackage);
                params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)assignee);
                params.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)workflowTitle));
                this.workflowService.updateTask(startTask.id, params, null, null);
                this.workflowService.endTask(startTask.id, null);
                this.workflowStores.add(workflowStoreName + ":/" + "www" + "/" + "avm_webapps" + "/ROOT");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Started '" + this.workflowName + "' workflow for user '" + userName + "' in store '" + storeName + "'"));
                }
            }
        }
    }

    private NodeRef setupWorkflowPackage(String workflowStoreName, List<String> expiredContent) {
        String packagesPath = workflowStoreName + ":/" + "www";
        for (String srcPath : expiredContent) {
            Matcher m = STORE_RELATIVE_PATH_PATTERN.matcher(srcPath);
            String relPath = m.matches() && m.group(1).length() != 0 ? m.group(1) : null;
            String pathInWorkflowStore = workflowStoreName + ":" + relPath;
            this.avmLockingAwareService.forceCopy(pathInWorkflowStore);
        }
        AVMNodeDescriptor packageDesc = this.avmService.lookup(-1, packagesPath);
        NodeRef packageNodeRef = this.workflowService.createPackage(AVMNodeConverter.ToNodeRef(-1, packageDesc.getPath()));
        this.nodeService.setProperty(packageNodeRef, WorkflowModel.PROP_IS_SYSTEM_PACKAGE, (Serializable)Boolean.valueOf(true));
        return packageNodeRef;
    }
}

