/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.LayeringDescriptor;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.avm.locking.AVMLockingException;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.wcm.util.WCMUtil;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMLockingAwareService
implements AVMService,
ApplicationContextAware {
    public static final String STORE_SEPARATOR = "--";
    private AVMService fService;
    private AVMLockingService fLockingService;
    private ApplicationContext fContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.fContext = applicationContext;
    }

    public void init() {
        this.fService = (AVMService)this.fContext.getBean("avmService");
        this.fLockingService = (AVMLockingService)this.fContext.getBean("avmLockingService");
    }

    @Override
    public void addAspect(String path, QName aspectName) {
        this.grabLock(path);
        this.fService.addAspect(path, aspectName);
    }

    @Override
    public void copy(int srcVersion, String srcPath, String dstPath, String name) {
        this.fService.copy(srcVersion, srcPath, dstPath, name);
    }

    @Override
    public void createBranch(int version, String srcPath, String dstPath, String name) {
        this.fService.createBranch(version, srcPath, dstPath, name);
    }

    @Override
    public void createDirectory(String path, String name) {
        this.fService.createDirectory(path, name);
    }

    @Override
    public OutputStream createFile(String path, String name) {
        this.grabLock(AVMUtil.extendAVMPath(path, name));
        return this.fService.createFile(path, name);
    }

    @Override
    public void createFile(String path, String name, InputStream in) {
        this.grabLock(AVMUtil.extendAVMPath(path, name));
        this.fService.createFile(path, name, in);
    }

    @Override
    public void createLayeredDirectory(String targetPath, String parent, String name) {
        this.fService.createLayeredDirectory(targetPath, parent, name);
    }

    @Override
    public void createLayeredFile(String targetPath, String parent, String name) {
        this.grabLock(AVMUtil.extendAVMPath(parent, name));
        this.fService.createLayeredFile(targetPath, parent, name);
    }

    @Override
    public Map<String, Integer> createSnapshot(String store, String tag, String description) {
        return this.fService.createSnapshot(store, tag, description);
    }

    @Override
    public void createStore(String name) {
        this.fService.createStore(name);
    }

    @Override
    public void createStore(String name, Map<QName, PropertyValue> props) {
        this.fService.createStore(name, props);
    }

    @Override
    public void deleteNodeProperties(String path) {
        this.grabLock(path);
        this.fService.deleteNodeProperties(path);
    }

    @Override
    public void deleteNodeProperty(String path, QName name) {
        this.grabLock(path);
        this.fService.deleteNodeProperty(path, name);
    }

    @Override
    public void deleteStoreProperty(String store, QName name) {
        this.fService.deleteStoreProperty(store, name);
    }

    @Override
    public AVMNodeDescriptor forceCopy(String path) {
        this.grabLock(path);
        return this.fService.forceCopy(path);
    }

    @Override
    public Pair<Integer, String> getAPath(AVMNodeDescriptor desc) {
        return this.fService.getAPath(desc);
    }

    @Override
    public List<String> getPathsInStoreVersion(AVMNodeDescriptor desc, String store, int version) {
        return this.fService.getPathsInStoreVersion(desc, store, version);
    }

    @Override
    public Set<QName> getAspects(int version, String path) {
        return this.fService.getAspects(version, path);
    }

    @Override
    public Set<QName> getAspects(AVMNodeDescriptor desc) {
        return this.fService.getAspects(desc);
    }

    @Override
    public AVMNodeDescriptor getCommonAncestor(AVMNodeDescriptor left, AVMNodeDescriptor right) {
        return this.fService.getCommonAncestor(left, right);
    }

    @Override
    public ContentData getContentDataForRead(int version, String path) {
        return this.fService.getContentDataForRead(version, path);
    }

    @Override
    public ContentData getContentDataForRead(AVMNodeDescriptor desc) {
        return this.fService.getContentDataForRead(desc);
    }

    @Override
    public ContentData getContentDataForWrite(String path) {
        this.grabLock(path);
        return this.fService.getContentDataForWrite(path);
    }

    @Override
    public ContentReader getContentReader(int version, String path) {
        return this.fService.getContentReader(version, path);
    }

    @Override
    public ContentWriter getContentWriter(String path, boolean update) {
        this.grabLock(path);
        return this.fService.getContentWriter(path, update);
    }

    @Override
    public List<String> getDeleted(int version, String path) {
        return this.fService.getDeleted(version, path);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(int version, String path) {
        return this.fService.getDirectoryListing(version, path);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(int version, String path, boolean includeDeleted) {
        return this.fService.getDirectoryListing(version, path, includeDeleted);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor dir) {
        return this.fService.getDirectoryListing(dir);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor dir, String childNamePattern) {
        return this.fService.getDirectoryListing(dir, childNamePattern);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor dir, boolean includeDeleted) {
        return this.fService.getDirectoryListing(dir, includeDeleted);
    }

    @Override
    public AVMNodeDescriptor[] getDirectoryListingArray(int version, String path, boolean includeDeleted) {
        return this.fService.getDirectoryListingArray(version, path, includeDeleted);
    }

    @Override
    public AVMNodeDescriptor[] getDirectoryListingArray(AVMNodeDescriptor dir, boolean includeDeleted) {
        return this.fService.getDirectoryListingArray(dir, includeDeleted);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(int version, String path) {
        return this.fService.getDirectoryListingDirect(version, path);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(int version, String path, boolean includeDeleted) {
        return this.fService.getDirectoryListingDirect(version, path, includeDeleted);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(AVMNodeDescriptor dir, boolean includeDeleted) {
        return this.fService.getDirectoryListingDirect(dir, includeDeleted);
    }

    @Override
    public InputStream getFileInputStream(int version, String path) {
        return this.fService.getFileInputStream(version, path);
    }

    @Override
    public InputStream getFileInputStream(AVMNodeDescriptor desc) {
        return this.fService.getFileInputStream(desc);
    }

    @Override
    public OutputStream getFileOutputStream(String path) {
        this.grabLock(path);
        return this.fService.getFileOutputStream(path);
    }

    @Override
    public List<Pair<Integer, String>> getHeadPaths(AVMNodeDescriptor desc) {
        return this.fService.getHeadPaths(desc);
    }

    @Override
    public List<AVMNodeDescriptor> getHistory(AVMNodeDescriptor desc, int count) {
        return this.fService.getHistory(desc, count);
    }

    @Override
    public String getIndirectionPath(int version, String path) {
        return this.fService.getIndirectionPath(version, path);
    }

    @Override
    public int getLatestSnapshotID(String storeName) {
        return this.fService.getLatestSnapshotID(storeName);
    }

    @Override
    public LayeringDescriptor getLayeringInfo(int version, String path) {
        return this.fService.getLayeringInfo(version, path);
    }

    @Override
    public int getNextVersionID(String storeName) {
        return this.fService.getNextVersionID(storeName);
    }

    @Override
    public Map<QName, PropertyValue> getNodeProperties(int version, String path) {
        return this.fService.getNodeProperties(version, path);
    }

    @Override
    public Map<QName, PropertyValue> getNodeProperties(AVMNodeDescriptor desc) {
        return this.fService.getNodeProperties(desc);
    }

    @Override
    public PropertyValue getNodeProperty(int version, String path, QName name) {
        return this.fService.getNodeProperty(version, path, name);
    }

    @Override
    public List<Pair<Integer, String>> getPaths(AVMNodeDescriptor desc) {
        return this.fService.getPaths(desc);
    }

    @Override
    public List<Pair<Integer, String>> getPathsInStoreHead(AVMNodeDescriptor desc, String store) {
        return this.fService.getPathsInStoreHead(desc, store);
    }

    @Override
    public AVMStoreDescriptor getStore(String name) {
        return this.fService.getStore(name);
    }

    @Override
    public Map<QName, PropertyValue> getStoreProperties(String store) {
        return this.fService.getStoreProperties(store);
    }

    @Override
    public PropertyValue getStoreProperty(String store, QName name) {
        return this.fService.getStoreProperty(store, name);
    }

    @Override
    public AVMNodeDescriptor getStoreRoot(int version, String name) {
        return this.fService.getStoreRoot(version, name);
    }

    @Override
    public List<VersionDescriptor> getStoreVersions(String name) {
        return this.fService.getStoreVersions(name);
    }

    @Override
    public List<VersionDescriptor> getStoreVersions(String name, Date from, Date to) {
        return this.fService.getStoreVersions(name, from, to);
    }

    @Override
    public List<AVMStoreDescriptor> getStores() {
        return this.fService.getStores();
    }

    @Override
    public AVMStoreDescriptor getSystemStore() {
        return this.fService.getSystemStore();
    }

    @Override
    public boolean hasAspect(int version, String path, QName aspectName) {
        return this.fService.hasAspect(version, path, aspectName);
    }

    @Override
    public void link(String parentPath, String name, AVMNodeDescriptor toLink) {
        this.fService.link(parentPath, name, toLink);
    }

    @Override
    public void updateLink(String parentPath, String name, AVMNodeDescriptor toLink) {
        this.fService.updateLink(parentPath, name, toLink);
    }

    @Override
    public AVMNodeDescriptor lookup(int version, String path) {
        return this.fService.lookup(version, path);
    }

    @Override
    public AVMNodeDescriptor lookup(int version, String path, boolean includeDeleted) {
        return this.fService.lookup(version, path, includeDeleted);
    }

    @Override
    public AVMNodeDescriptor lookup(AVMNodeDescriptor dir, String name) {
        return this.fService.lookup(dir, name);
    }

    @Override
    public AVMNodeDescriptor lookup(AVMNodeDescriptor dir, String name, boolean includeDeleted) {
        return this.fService.lookup(dir, name, includeDeleted);
    }

    @Override
    public void makePrimary(String path) {
        this.fService.makePrimary(path);
    }

    @Override
    public void makeTransparent(String dirPath, String name) {
        this.fService.makeTransparent(dirPath, name);
    }

    @Override
    public void purgeStore(String name) {
        this.fService.purgeStore(name);
        String webProject = WCMUtil.getWebProject(this.fService, name);
        if (webProject != null) {
            this.fLockingService.removeLocks(name);
        }
    }

    @Override
    public void purgeVersion(int version, String name) {
        this.fService.purgeVersion(version, name);
    }

    @Override
    public Map<QName, PropertyValue> queryStorePropertyKey(String store, QName keyPattern) {
        return this.fService.queryStorePropertyKey(store, keyPattern);
    }

    @Override
    public Map<String, Map<QName, PropertyValue>> queryStoresPropertyKeys(QName keyPattern) {
        return this.fService.queryStoresPropertyKeys(keyPattern);
    }

    @Override
    public void removeAspect(String path, QName aspectName) {
        this.grabLock(path);
        this.fService.removeAspect(path, aspectName);
    }

    @Override
    public void removeNode(String parent, String name) {
        String path = AVMUtil.extendAVMPath(parent, name);
        this.grabLock(path);
        this.fService.removeNode(parent, name);
        String[] storePath = AVMUtil.splitPath(parent);
        String avmStore = storePath[0];
        this.fService.createSnapshot(avmStore, null, "Removed " + path);
        String webProject = WCMUtil.getWebProject(this.fService, avmStore);
        if (webProject != null) {
            Map<String, String> lockDataToMatch = Collections.singletonMap("avm-store-name", avmStore);
            String relPath = AVMUtil.extendAVMPath(storePath[1], name);
            this.fLockingService.removeLocks(webProject, relPath, lockDataToMatch);
        }
    }

    @Override
    public void removeNode(String path) {
        this.grabLock(path);
        this.fService.removeNode(path);
        String[] storePath = AVMUtil.splitPath(path);
        String avmStore = storePath[0];
        String relPath = storePath[1];
        this.fService.createSnapshot(avmStore, null, "Removed " + path);
        String webProject = WCMUtil.getWebProject(this.fService, avmStore);
        if (webProject != null) {
            Map<String, String> lockDataToMatch = Collections.singletonMap("avm-store-name", avmStore);
            this.fLockingService.removeLocks(webProject, relPath, lockDataToMatch);
        }
    }

    @Override
    public void rename(String srcParent, String srcName, String dstParent, String dstName) {
        String srcPath = AVMUtil.extendAVMPath(srcParent, srcName);
        String dstPath = AVMUtil.extendAVMPath(dstParent, dstName);
        AVMNodeDescriptor desc = this.fService.lookup(-1, srcPath, false);
        if (desc == null || !desc.isDirectory()) {
            this.grabLock(srcPath);
        }
        this.fService.rename(srcParent, srcName, dstParent, dstName);
        if (desc == null || !desc.isDirectory()) {
            String[] srcStorePath = AVMUtil.splitPath(srcPath);
            String[] dstStorePath = AVMUtil.splitPath(dstPath);
            String srcWebProject = WCMUtil.getWebProject(this.fService, srcStorePath[0]);
            String dstWebProject = WCMUtil.getWebProject(this.fService, dstStorePath[0]);
            if (dstWebProject != null && dstWebProject.equals(srcWebProject)) {
                this.grabLock(dstPath);
            } else {
                this.fLockingService.removeLock(srcWebProject, srcStorePath[1]);
                this.grabLock(dstPath);
            }
        }
    }

    @Override
    public void renameStore(String sourceName, String destName) {
        this.fService.renameStore(sourceName, destName);
    }

    @Override
    public void retargetLayeredDirectory(String path, String target) {
        this.fService.retargetLayeredDirectory(path, target);
    }

    @Override
    public void revert(String path, AVMNodeDescriptor toRevertTo) {
        this.grabLock(path);
        this.fService.revert(path, toRevertTo);
    }

    @Override
    public void setContentData(String path, ContentData data) {
        this.grabLock(path);
        this.fService.setContentData(path, data);
    }

    @Override
    public void setEncoding(String path, String encoding) {
        this.grabLock(path);
        this.fService.setEncoding(path, encoding);
    }

    @Override
    public void setGuid(String path, String guid) {
        this.grabLock(path);
        this.fService.setGuid(path, guid);
    }

    @Override
    public void setMetaDataFrom(String path, AVMNodeDescriptor from) {
        this.grabLock(path);
        this.fService.setMetaDataFrom(path, from);
    }

    @Override
    public void setMimeType(String path, String mimeType) {
        this.grabLock(path);
        this.fService.setMimeType(path, mimeType);
    }

    @Override
    public void setNodeProperties(String path, Map<QName, PropertyValue> properties) {
        this.grabLock(path);
        this.fService.setNodeProperties(path, properties);
    }

    @Override
    public void setNodeProperty(String path, QName name, PropertyValue value) {
        this.grabLock(path);
        this.fService.setNodeProperty(path, name, value);
    }

    @Override
    public void setOpacity(String path, boolean opacity) {
        this.fService.setOpacity(path, opacity);
    }

    @Override
    public void setStoreProperties(String store, Map<QName, PropertyValue> props) {
        this.fService.setStoreProperties(store, props);
    }

    @Override
    public void setStoreProperty(String store, QName name, PropertyValue value) {
        this.fService.setStoreProperty(store, name, value);
    }

    @Override
    public void uncover(String dirPath, String name) {
        this.grabLock(AVMUtil.extendAVMPath(dirPath, name));
        this.fService.uncover(dirPath, name);
    }

    @Override
    public void createDirectory(String path, String name, List<QName> aspects, Map<QName, PropertyValue> properties) {
        this.fService.createDirectory(path, name, aspects, properties);
    }

    @Override
    public void createFile(String path, String name, InputStream in, List<QName> aspects, Map<QName, PropertyValue> properties) {
        this.grabLock(AVMUtil.extendAVMPath(path, name));
        this.fService.createFile(path, name, in, aspects, properties);
    }

    private void grabLock(String path) {
        AVMNodeDescriptor desc = this.fService.lookup(-1, path, false);
        if (desc != null && desc.isDirectory()) {
            return;
        }
        String[] storePath = AVMUtil.splitPath(path);
        String avmStore = storePath[0];
        String webProject = WCMUtil.getWebProject(this.fService, storePath[0]);
        if (webProject != null && webProject.equals(avmStore)) {
            return;
        }
        if (webProject != null) {
            String userName = AuthenticationUtil.getFullyAuthenticatedUser();
            AVMLockingService.LockState lockState = this.fLockingService.getLockState(webProject, storePath[1], userName);
            switch (lockState) {
                case LOCK_NOT_OWNER: {
                    String lockOwner = this.fLockingService.getLockOwner(webProject, storePath[1]);
                    throw new AVMLockingException("avmlockservice.locked", path, lockOwner);
                }
                case NO_LOCK: {
                    Map<String, String> lockAttributes = Collections.singletonMap("avm-store-name", avmStore);
                    this.fLockingService.lock(webProject, storePath[1], userName, lockAttributes);
                    break;
                }
            }
        }
    }

    @Override
    public List<VersionDescriptor> getStoreVersionsTo(String name, int version) {
        return this.fService.getStoreVersionsTo(name, version);
    }

    @Override
    public List<VersionDescriptor> getStoreVersionsFrom(String name, int version) {
        return this.fService.getStoreVersionsFrom(name, version);
    }

    @Override
    public List<VersionDescriptor> getStoreVersionsBetween(String name, int from, int to) {
        return this.fService.getStoreVersionsBetween(name, from, to);
    }
}

