/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMRepository;
import org.alfresco.repo.avm.Lookup;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.security.permissions.ACLCopyMode;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncException;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.NameMatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMSyncServiceImpl
implements AVMSyncService {
    private static Log logger = LogFactory.getLog(AVMSyncServiceImpl.class);
    private AVMService fAVMService;
    private AVMRepository fAVMRepository;
    private PermissionService fPermissionService;

    public void setAvmService(AVMService avmService) {
        this.fAVMService = avmService;
    }

    public void setAvmRepository(AVMRepository avmRepository) {
        this.fAVMRepository = avmRepository;
    }

    public void setPermissionService(PermissionService service) {
        this.fPermissionService = service;
    }

    @Override
    public List<AVMDifference> compare(int srcVersion, String srcPath, int dstVersion, String dstPath, NameMatcher excluder) {
        long start = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(srcPath + " : " + dstPath));
        }
        if (srcPath == null || dstPath == null) {
            throw new AVMBadArgumentException("Illegal null path.");
        }
        ArrayList<AVMDifference> result = new ArrayList<AVMDifference>();
        AVMNodeDescriptor srcDesc = this.fAVMService.lookup(srcVersion, srcPath, true);
        if (srcDesc == null) {
            throw new AVMSyncException("Source not found: " + srcPath);
        }
        AVMNodeDescriptor dstDesc = this.fAVMService.lookup(dstVersion, dstPath, true);
        if (dstDesc == null) {
            result.add(new AVMDifference(srcVersion, srcPath, dstVersion, dstPath, 0));
        } else {
            this.compare(srcVersion, srcDesc, dstVersion, dstDesc, result, excluder, true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Raw compare: [" + srcVersion + "," + srcPath + "][" + dstVersion + "," + dstPath + "][" + result.size() + "] in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return result;
    }

    private void compare(int srcVersion, AVMNodeDescriptor srcDesc, int dstVersion, AVMNodeDescriptor dstDesc, List<AVMDifference> result, NameMatcher excluder, boolean firstLevel) {
        String srcPath = srcDesc.getPath();
        String dstPath = dstDesc.getPath();
        String[] srcParts = AVMUtil.splitBase(srcPath);
        String srcChildName = srcParts[1];
        String[] dstParts = AVMUtil.splitBase(dstPath);
        String dstChildName = dstParts[1];
        if (dstChildName.equalsIgnoreCase(srcChildName) && !dstChildName.equals(srcChildName)) {
            String dstParentPath = dstParts[0];
            if (dstParentPath == null) {
                dstParentPath = AVMUtil.buildAVMPath(AVMUtil.getStoreName(dstPath), "");
            }
            dstPath = AVMUtil.extendAVMPath(dstParentPath, srcChildName);
        }
        if (excluder != null && (excluder.matches(srcPath) || excluder.matches(dstPath))) {
            return;
        }
        int diffCode = this.compareOne(srcDesc, dstDesc, false);
        switch (diffCode) {
            case 4: {
                return;
            }
            case 0: 
            case 1: 
            case 2: {
                result.add(new AVMDifference(srcVersion, srcPath, dstVersion, dstPath, diffCode));
                return;
            }
            case 3: {
                if (srcDesc.isLayeredDirectory() && srcDesc.getIndirection().equalsIgnoreCase(dstPath) && srcVersion < 0 && dstVersion < 0) {
                    SortedMap<String, AVMNodeDescriptor> srcList;
                    if (!firstLevel) {
                        int dirDiffCode = this.compareOne(srcDesc, dstDesc, true);
                        switch (dirDiffCode) {
                            case 0: 
                            case 1: 
                            case 2: {
                                result.add(new AVMDifference(srcVersion, srcPath, dstVersion, dstPath, dirDiffCode));
                                return;
                            }
                            case 4: {
                                break;
                            }
                            default: {
                                throw new AVMSyncException("Invalid Difference Code " + dirDiffCode + " - Internal Error.");
                            }
                        }
                    }
                    if ((srcList = this.fAVMService.getDirectoryListingDirect(srcDesc, true)).size() == 0) {
                        return;
                    }
                    SortedMap<String, AVMNodeDescriptor> dstList = this.fAVMService.getDirectoryListing(dstDesc, true);
                    for (String name : srcList.keySet()) {
                        AVMNodeDescriptor srcChild = (AVMNodeDescriptor)srcList.get(name);
                        AVMNodeDescriptor dstChild = (AVMNodeDescriptor)dstList.get(name);
                        String srcChildPath = srcChild.getPath();
                        String dstChildPath = AVMNodeConverter.ExtendAVMPath(dstPath, name);
                        if (excluder != null && (excluder.matches(srcChildPath) || excluder.matches(dstChildPath))) continue;
                        if (dstChild == null) {
                            result.add(new AVMDifference(srcVersion, srcChildPath, dstVersion, dstChildPath, 0));
                            continue;
                        }
                        this.compare(srcVersion, srcChild, dstVersion, dstChild, result, excluder, false);
                    }
                    return;
                }
                if (dstDesc.isLayeredDirectory() && dstDesc.getIndirection().equalsIgnoreCase(srcPath) && srcVersion < 0 && dstVersion < 0) {
                    SortedMap<String, AVMNodeDescriptor> dstList;
                    if (!firstLevel) {
                        int dirDiffCode = this.compareOne(srcDesc, dstDesc, true);
                        switch (dirDiffCode) {
                            case 0: 
                            case 1: 
                            case 2: {
                                result.add(new AVMDifference(srcVersion, srcPath, dstVersion, dstPath, dirDiffCode));
                                return;
                            }
                            case 4: {
                                break;
                            }
                            default: {
                                throw new AVMSyncException("Invalid Difference Code " + dirDiffCode + " - Internal Error.");
                            }
                        }
                    }
                    if ((dstList = this.fAVMService.getDirectoryListingDirect(dstDesc, true)).size() == 0) {
                        return;
                    }
                    SortedMap<String, AVMNodeDescriptor> srcList = this.fAVMService.getDirectoryListing(srcDesc, true);
                    for (String name : dstList.keySet()) {
                        AVMNodeDescriptor dstChild = (AVMNodeDescriptor)dstList.get(name);
                        AVMNodeDescriptor srcChild = (AVMNodeDescriptor)srcList.get(name);
                        String srcChildPath = AVMNodeConverter.ExtendAVMPath(srcPath, name);
                        String dstChildPath = dstChild.getPath();
                        if (excluder != null && (excluder.matches(srcChildPath) || excluder.matches(dstChildPath))) continue;
                        if (srcChild == null) {
                            result.add(new AVMDifference(srcVersion, srcChildPath, dstVersion, dstChildPath, 1));
                            continue;
                        }
                        this.compare(srcVersion, srcChild, dstVersion, dstChild, result, excluder, false);
                    }
                    return;
                }
                SortedMap<String, AVMNodeDescriptor> srcList = this.fAVMService.getDirectoryListing(srcDesc, true);
                SortedMap<String, AVMNodeDescriptor> dstList = this.fAVMService.getDirectoryListing(dstDesc, true);
                for (String name : srcList.keySet()) {
                    AVMNodeDescriptor srcChild = (AVMNodeDescriptor)srcList.get(name);
                    AVMNodeDescriptor dstChild = (AVMNodeDescriptor)dstList.get(name);
                    String srcChildPath = srcChild.getPath();
                    String dstChildPath = AVMNodeConverter.ExtendAVMPath(dstPath, name);
                    if (excluder != null && (excluder.matches(srcChildPath) || excluder.matches(dstChildPath))) continue;
                    if (dstChild == null) {
                        result.add(new AVMDifference(srcVersion, srcChildPath, dstVersion, dstChildPath, 0));
                        continue;
                    }
                    this.compare(srcVersion, srcChild, dstVersion, dstChild, result, excluder, false);
                }
                for (String name : dstList.keySet()) {
                    if (srcList.containsKey(name)) continue;
                    AVMNodeDescriptor dstChild = (AVMNodeDescriptor)dstList.get(name);
                    String srcChildPath = AVMNodeConverter.ExtendAVMPath(srcPath, name);
                    String dstChildPath = dstChild.getPath();
                    if (excluder != null && (excluder.matches(srcChildPath) || excluder.matches(dstChildPath))) continue;
                    result.add(new AVMDifference(srcVersion, srcChildPath, dstVersion, dstChildPath, 1));
                }
                break;
            }
            default: {
                throw new AVMSyncException("Invalid Difference Code " + diffCode + " - Internal Error.");
            }
        }
    }

    @Override
    public void update(List<AVMDifference> diffList, NameMatcher excluder, boolean ignoreConflicts, boolean ignoreOlder, boolean overrideConflicts, boolean overrideOlder, String tag, String description) {
        long start = System.currentTimeMillis();
        HashMap<String, Integer> storeVersions = new HashMap<String, Integer>();
        HashSet<String> destStores = new HashSet<String>();
        TreeMap<String, AVMDifference> diffsToUpdate = new TreeMap<String, AVMDifference>();
        for (AVMDifference diff : diffList) {
            if (excluder != null && (excluder.matches(diff.getSourcePath()) || excluder.matches(diff.getDestinationPath()))) continue;
            if (!diff.isValid()) {
                throw new AVMSyncException("Malformed AVMDifference.");
            }
            diffsToUpdate.put(diff.getSourcePath(), diff);
        }
        for (AVMDifference diff : diffsToUpdate.values()) {
            int version;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("update: " + diff));
            }
            if ((version = diff.getSourceVersion()) < 0) {
                String storeName = AVMUtil.getStoreName(diff.getSourcePath());
                if (storeVersions.containsKey(storeName)) {
                    version = (Integer)storeVersions.get(storeName);
                } else {
                    version = this.fAVMService.createSnapshot(storeName, "Snapshotted for submit.", null).get(storeName);
                    storeVersions.put(storeName, version);
                }
            }
            AVMNodeDescriptor srcDesc = this.fAVMService.lookup(version, diff.getSourcePath(), true);
            String[] dstParts = AVMNodeConverter.SplitBase(diff.getDestinationPath());
            if (dstParts[0] == null || diff.getDestinationVersion() >= 0) {
                throw new AVMSyncException("Invalid destination node: " + diff.getDestinationPath());
            }
            AVMNodeDescriptor dstDesc = this.fAVMService.lookup(-1, diff.getDestinationPath(), true);
            int diffCode = 0;
            if (dstDesc != null) {
                diffCode = this.compareOne(srcDesc, dstDesc, false);
            }
            String dstPath = diff.getDestinationPath();
            destStores.add(AVMUtil.getStoreName(dstPath));
            this.dispatchUpdate(diffCode, dstParts[0], dstParts[1], excluder, srcDesc, dstDesc, ignoreConflicts, ignoreOlder, overrideConflicts, overrideOlder);
        }
        for (String storeName : destStores) {
            this.fAVMService.createSnapshot(storeName, tag, description);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Raw update: [" + diffList.size() + "] in " + (System.currentTimeMillis() - start) + " msecs"));
        }
    }

    private void dispatchUpdate(int diffCode, String parentPath, String name, NameMatcher excluder, AVMNodeDescriptor srcDesc, AVMNodeDescriptor dstDesc, boolean ignoreConflicts, boolean ignoreOlder, boolean overrideConflicts, boolean overrideOlder) {
        switch (diffCode) {
            case 4: {
                return;
            }
            case 0: {
                this.linkIn(parentPath, name, srcDesc, excluder, dstDesc != null && !dstDesc.isDeleted(), dstDesc);
                return;
            }
            case 1: {
                if (overrideOlder) {
                    this.linkIn(parentPath, name, srcDesc, excluder, !dstDesc.isDeleted(), dstDesc);
                    return;
                }
                if (ignoreOlder) {
                    return;
                }
                throw new AVMSyncException("Older version prevents update.");
            }
            case 2: {
                if (overrideConflicts) {
                    this.linkIn(parentPath, name, srcDesc, excluder, true, dstDesc);
                    return;
                }
                if (ignoreConflicts) {
                    return;
                }
                throw new AVMSyncException("Conflict prevents update.");
            }
            case 3: {
                int dirDiffCode = this.compareOne(srcDesc, dstDesc, true);
                if (dirDiffCode == 3) {
                    throw new AVMSyncException("Unexpected diff code: " + dirDiffCode);
                }
                this.dispatchUpdate(dirDiffCode, parentPath, name, excluder, srcDesc, dstDesc, ignoreConflicts, ignoreOlder, overrideConflicts, overrideOlder);
                return;
            }
        }
        throw new AVMSyncException("Invalid Difference Code " + diffCode + " - Internal Error.");
    }

    private void linkIn(String parentPath, String name, AVMNodeDescriptor toLink, NameMatcher excluder, boolean removeFirst, AVMNodeDescriptor dstDesc) {
        if (toLink == null) {
            block10: {
                try {
                    this.fAVMService.removeNode(parentPath, name);
                }
                catch (AVMNotFoundException nfe) {
                    if (!logger.isDebugEnabled()) break block10;
                    logger.debug((Object)("linkIn: Does not exist: " + parentPath + "/" + name));
                }
            }
            return;
        }
        this.mkdirs(parentPath, AVMNodeConverter.SplitBase(toLink.getPath())[0]);
        if (toLink.isLayeredDirectory() && !toLink.isPrimary()) {
            if (removeFirst) {
                this.fAVMService.removeNode(parentPath, name);
            }
            this.recursiveCopy(parentPath, name, toLink, excluder);
            return;
        }
        String newPath = AVMNodeConverter.ExtendAVMPath(parentPath, name);
        if (toLink.isLayeredDirectory() && toLink.isPrimary() && dstDesc == null && toLink.getIndirection().equals(newPath)) {
            this.recursiveCopy(parentPath, name, toLink, excluder);
            return;
        }
        if (removeFirst) {
            if (toLink.isDirectory()) {
                this.fAVMService.removeNode(parentPath, name);
                this.fAVMService.link(parentPath, name, toLink);
            } else {
                this.fAVMService.updateLink(parentPath, name, toLink);
            }
        } else {
            this.fAVMService.link(parentPath, name, toLink);
        }
        this.setACL(parentPath, toLink.getPath(), newPath);
    }

    private Acl getACL(String path) {
        Lookup lookup = AVMRepository.GetInstance().lookup(-1, path, false);
        if (lookup != null) {
            AVMNode node = lookup.getCurrentNode();
            return node.getAcl();
        }
        return null;
    }

    private void setACL(String parentPath, String toCopyPath, String newPath) {
        Acl parentAcl = this.getACL(parentPath);
        Acl acl = this.getACL(toCopyPath);
        Lookup lookup = AVMRepository.GetInstance().lookup(-1, newPath, false);
        if (lookup == null) {
            return;
        }
        AVMNode newNode = lookup.getCurrentNode();
        newNode.copyACLs(acl, parentAcl, ACLCopyMode.COPY);
        AVMDAOs.Instance().fAVMNodeDAO.update(newNode);
    }

    private void recursiveCopy(String parentPath, String name, AVMNodeDescriptor toCopy, NameMatcher excluder) {
        this.fAVMService.createDirectory(parentPath, name);
        String newParentPath = AVMNodeConverter.ExtendAVMPath(parentPath, name);
        this.fAVMService.setMetaDataFrom(newParentPath, toCopy);
        AVMNodeDescriptor parentDesc = this.fAVMService.lookup(-1, newParentPath, true);
        SortedMap<String, AVMNodeDescriptor> children = this.fAVMService.getDirectoryListing(toCopy, true);
        for (Map.Entry entry : children.entrySet()) {
            this.recursiveCopy(parentDesc, (String)entry.getKey(), (AVMNodeDescriptor)entry.getValue(), excluder);
        }
    }

    private void recursiveCopy(AVMNodeDescriptor parent, String name, AVMNodeDescriptor toCopy, NameMatcher excluder) {
        String newPath = AVMNodeConverter.ExtendAVMPath(parent.getPath(), name);
        if (excluder != null && (excluder.matches(newPath) || excluder.matches(toCopy.getPath()))) {
            return;
        }
        if (toCopy.isFile() || toCopy.isDeleted() || toCopy.isPlainDirectory()) {
            this.fAVMRepository.link(parent, name, toCopy);
            this.setACL(parent.getPath(), toCopy.getPath(), newPath);
            return;
        }
        AVMNodeDescriptor newParentDesc = this.fAVMRepository.createDirectory(parent, name);
        this.fAVMService.setMetaDataFrom(newParentDesc.getPath(), toCopy);
        SortedMap<String, AVMNodeDescriptor> children = this.fAVMService.getDirectoryListing(toCopy, true);
        for (Map.Entry entry : children.entrySet()) {
            this.recursiveCopy(newParentDesc, (String)entry.getKey(), (AVMNodeDescriptor)entry.getValue(), excluder);
        }
    }

    private int compareOne(AVMNodeDescriptor srcDesc, AVMNodeDescriptor dstDesc, boolean compareDir) {
        Integer diff;
        if (srcDesc == null) {
            return 1;
        }
        if (srcDesc.getId() == dstDesc.getId()) {
            return 4;
        }
        if (srcDesc.isDirectory() && dstDesc.isFile() || srcDesc.isFile() && dstDesc.isDirectory()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("compareOne(1): conflict [" + srcDesc + "," + dstDesc + "]"));
            }
            return 2;
        }
        if (srcDesc.isDeleted() || dstDesc.isDeleted()) {
            Integer diff2;
            AVMNodeDescriptor common = this.fAVMService.getCommonAncestor(srcDesc, dstDesc);
            if (common == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("compareOne(2): conflict [" + srcDesc + "," + dstDesc + "]"));
                }
                return 2;
            }
            if (common.getId() == srcDesc.getId()) {
                return 1;
            }
            if (common.getId() == dstDesc.getId()) {
                return 0;
            }
            if (common.isLayeredFile() && (diff2 = this.compareLayeredCommonAncestor(common, srcDesc, dstDesc)) != null) {
                return diff2;
            }
            if (srcDesc.isDeleted() && (srcDesc.getDeletedType() == 3 || srcDesc.getDeletedType() == 1) ? (diff2 = this.compareLayeredCommonAncestor(common, srcDesc, dstDesc)) != null : dstDesc.isDeleted() && (dstDesc.getDeletedType() == 3 || dstDesc.getDeletedType() == 1) && (diff2 = this.compareLayeredCommonAncestor(common, dstDesc, srcDesc)) != null) {
                return diff2;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("compareOne(3): conflict [" + srcDesc + "," + dstDesc + "]"));
            }
            return 2;
        }
        if (srcDesc.isDirectory() && dstDesc.isDirectory()) {
            AVMNodeDescriptor common;
            if (!compareDir) {
                return 3;
            }
            if ((srcDesc.isLayeredDirectory() && srcDesc.getIndirection().equals(dstDesc.getPath()) || dstDesc.isLayeredDirectory() && dstDesc.getIndirection().equals(srcDesc.getPath())) && this.compareNodeProps(srcDesc, dstDesc) == 4) {
                int dirDiffCode = this.compareACLs(srcDesc, dstDesc);
                if (dirDiffCode != 2) {
                    return dirDiffCode;
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("compareOne(4): conflict [" + srcDesc + "," + dstDesc + "]"));
                }
            }
            if ((common = this.fAVMService.getCommonAncestor(srcDesc, dstDesc)) == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("compareOne(5): conflict [" + srcDesc + "," + dstDesc + "]"));
                }
                return 2;
            }
            if (common.getId() == srcDesc.getId()) {
                return 1;
            }
            if (common.getId() == dstDesc.getId()) {
                return 0;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("compareOne(6): conflict [" + srcDesc + "," + dstDesc + "]"));
            }
            return 2;
        }
        if (srcDesc.isLayeredFile()) {
            if (dstDesc.isPlainFile()) {
                if (srcDesc.getIndirection().equals(dstDesc.getPath())) {
                    return 4;
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("compareOne(7): conflict [" + srcDesc + "," + dstDesc + "]"));
                }
                return 2;
            }
            AVMNodeDescriptor common = this.fAVMService.getCommonAncestor(srcDesc, dstDesc);
            if (common == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("compareOne(8): conflict [" + srcDesc + "," + dstDesc + "]"));
                }
                return 2;
            }
            if (common.getId() == srcDesc.getId()) {
                return 1;
            }
            if (common.getId() == dstDesc.getId()) {
                return 0;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("compareOne(9): conflict [" + srcDesc + "," + dstDesc + "]"));
            }
            return 2;
        }
        if (dstDesc.isLayeredFile()) {
            Integer diff3;
            if (dstDesc.getIndirection().equals(srcDesc.getPath())) {
                return 4;
            }
            AVMNodeDescriptor common = this.fAVMService.getCommonAncestor(srcDesc, dstDesc);
            if (common == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("compareOne(10): conflict [" + srcDesc + "," + dstDesc + "]"));
                }
                return 2;
            }
            if (common.getId() == srcDesc.getId()) {
                return 1;
            }
            if (common.getId() == dstDesc.getId()) {
                return 0;
            }
            if (common.isLayeredFile() && (diff3 = this.compareLayeredCommonAncestor(common, srcDesc, dstDesc)) != null) {
                return diff3;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("compareOne(11): conflict [" + srcDesc + "," + dstDesc + "]"));
            }
            return 2;
        }
        AVMNodeDescriptor common = this.fAVMService.getCommonAncestor(srcDesc, dstDesc);
        if (common == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("compareOne(12): conflict [" + srcDesc + "," + dstDesc + "]"));
            }
            return 2;
        }
        if (common.getId() == srcDesc.getId()) {
            return 1;
        }
        if (common.getId() == dstDesc.getId()) {
            return 0;
        }
        if (common.isLayeredFile() && (diff = this.compareLayeredCommonAncestor(common, srcDesc, dstDesc)) != null) {
            return diff;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("compareOne(13): conflict [" + srcDesc + "," + dstDesc + "]"));
        }
        return 2;
    }

    private Integer compareLayeredCommonAncestor(AVMNodeDescriptor common, AVMNodeDescriptor srcDesc, AVMNodeDescriptor dstDesc) {
        Integer diff = null;
        diff = this.compareLayeredCommonAncestor(common, dstDesc.getId(), 0);
        if (diff == null) {
            diff = this.compareLayeredCommonAncestor(common, srcDesc.getId(), 1);
        }
        return diff;
    }

    private Integer compareLayeredCommonAncestor(AVMNodeDescriptor common, long compareNodeId, int diffType) {
        Integer diff = null;
        AVMNode compareAncNode = AVMDAOs.Instance().fAVMNodeDAO.getByID(compareNodeId).getAncestor();
        if (compareAncNode != null) {
            if (common.getId() == compareAncNode.getId()) {
                diff = diffType;
            } else if (common.isLayeredFile() || compareAncNode.getType() == 1) {
                diff = this.compareLayeredCommonAncestor(common, compareAncNode.getId(), diffType);
            }
        }
        return diff;
    }

    private int compareNodeProps(AVMNodeDescriptor srcDesc, AVMNodeDescriptor dstDesc) {
        Map<QName, PropertyValue> srcProps = this.fAVMService.getNodeProperties(srcDesc);
        Map<QName, PropertyValue> dstProps = this.fAVMService.getNodeProperties(dstDesc);
        if (srcProps.size() == dstProps.size()) {
            for (Map.Entry<QName, PropertyValue> srcEntry : srcProps.entrySet()) {
                PropertyValue srcValue = srcEntry.getValue();
                PropertyValue dstValue = dstProps.get(srcEntry.getKey());
                if (srcValue == null && dstValue == null || srcValue != null && dstValue != null && srcValue.equals(dstValue)) continue;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("compareNodeProps(1): conflict [" + srcDesc + "," + dstDesc + "]"));
                }
                return 2;
            }
            return 4;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("compareNodeProps(2): conflict [" + srcDesc + "," + dstDesc + "]"));
        }
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int compareACLs(AVMNodeDescriptor srcDesc, AVMNodeDescriptor dstDesc) {
        Acl srcAcl = this.getACL(srcDesc.getPath());
        Acl dstAcl = this.getACL(dstDesc.getPath());
        if (srcAcl == null && dstAcl == null) {
            return 4;
        }
        if (srcAcl != null) {
            if (dstAcl != null && srcAcl.getAclId() == dstAcl.getAclId()) {
                return 4;
            }
            if (srcAcl.getAclType().equals((Object)ACLType.LAYERED)) {
                if (dstAcl != null && !dstAcl.getAclType().equals((Object)ACLType.SHARED) && !dstAcl.getAclType().equals((Object)ACLType.LAYERED) && !dstAcl.getAclType().equals((Object)ACLType.DEFINING)) throw new AVMSyncException("srcAcl type: " + (Object)((Object)srcAcl.getAclType()) + ", unexpected dstAcl type: " + (Object)((Object)dstAcl.getAclType()));
                return 4;
            }
            if (srcAcl.getAclType().equals((Object)ACLType.DEFINING)) {
                if (dstAcl == null || dstAcl.getAclType().equals((Object)ACLType.SHARED) || dstAcl.getAclType().equals((Object)ACLType.LAYERED)) {
                    return 0;
                }
                if (!dstAcl.getAclType().equals((Object)ACLType.DEFINING)) throw new AVMSyncException("srcAcl type: " + (Object)((Object)srcAcl.getAclType()) + ", unexpected dstAcl type: " + (Object)((Object)dstAcl.getAclType()));
                boolean same = this.compareACEs(srcDesc, dstDesc);
                if (same) {
                    return 4;
                }
            } else if (srcAcl.getAclType().equals((Object)ACLType.SHARED)) {
                if (dstAcl != null && !dstAcl.getAclType().equals((Object)ACLType.SHARED)) throw new AVMSyncException("srcAcl type: " + (Object)((Object)srcAcl.getAclType()) + ", unexpected dstAcl type: " + (Object)((Object)dstAcl.getAclType()));
                boolean same = this.compareACEs(srcDesc, dstDesc);
                if (same) {
                    return 4;
                }
            }
        } else if (srcAcl == null && dstAcl != null) {
            return 4;
        }
        if (!logger.isInfoEnabled()) return 2;
        logger.info((Object)("compareACLs: conflict [" + srcDesc + "," + dstDesc + "]"));
        return 2;
    }

    private boolean compareACEs(AVMNodeDescriptor srcDesc, AVMNodeDescriptor dstDesc) {
        boolean same = false;
        NodeRef srcNodeRef = AVMNodeConverter.ToNodeRef(-1, srcDesc.getPath());
        Set srcSet = this.fPermissionService.getAllSetPermissions(srcNodeRef);
        NodeRef dstNodeRef = AVMNodeConverter.ToNodeRef(-1, dstDesc.getPath());
        Set dstSet = this.fPermissionService.getAllSetPermissions(dstNodeRef);
        if (srcSet.size() == dstSet.size()) {
            same = true;
            for (AccessPermission srcPerm : srcSet) {
                boolean found = false;
                for (AccessPermission dstPerm : dstSet) {
                    if (!this.compareAccessPermission(srcPerm, dstPerm)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                same = false;
                break;
            }
        }
        return same;
    }

    private boolean compareAccessPermission(AccessPermission srcPerm, AccessPermission dstPerm) {
        if (srcPerm == dstPerm) {
            return true;
        }
        if (srcPerm == null) {
            return false;
        }
        if (srcPerm.getAccessStatus() == null ? dstPerm.getAccessStatus() != null : !srcPerm.getAccessStatus().equals((Object)dstPerm.getAccessStatus())) {
            return false;
        }
        if (srcPerm.getAuthority() == null ? dstPerm.getAuthority() != null : !srcPerm.getAuthority().equals(dstPerm.getAuthority())) {
            return false;
        }
        return !(srcPerm.getPermission() == null ? dstPerm.getPermission() != null : !srcPerm.getPermission().equals(dstPerm.getPermission()));
    }

    @Override
    public void flatten(String layerPath, String underlyingPath) {
        long start = System.currentTimeMillis();
        if (layerPath == null || underlyingPath == null) {
            throw new AVMBadArgumentException("Illegal null path.");
        }
        AVMNodeDescriptor layerNode = this.fAVMService.lookup(-1, layerPath, true);
        if (layerNode == null) {
            throw new AVMNotFoundException("Not found: " + layerPath);
        }
        AVMNodeDescriptor underlyingNode = this.fAVMService.lookup(-1, underlyingPath, true);
        if (underlyingNode == null) {
            throw new AVMNotFoundException("Not found: " + underlyingPath);
        }
        this.flatten(layerNode, underlyingNode);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Raw flatten: " + layerNode + " " + underlyingNode + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
    }

    private boolean flatten(AVMNodeDescriptor layer, AVMNodeDescriptor underlying) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("flatten: " + layer + " " + underlying));
        }
        if (!layer.isLayeredDirectory()) {
            return false;
        }
        if (!layer.getIndirection().equalsIgnoreCase(underlying.getPath())) {
            return false;
        }
        if (!underlying.isDirectory()) {
            return false;
        }
        SortedMap<String, AVMNodeDescriptor> layerListing = this.fAVMService.getDirectoryListingDirect(-1, layer.getPath(), true);
        if (layerListing.size() == 0) {
            return true;
        }
        SortedMap<String, AVMNodeDescriptor> underListing = this.fAVMService.getDirectoryListing(underlying, true);
        boolean flattened = true;
        for (String name : layerListing.keySet()) {
            AVMNodeDescriptor lookup;
            AVMNodeDescriptor topNode = (AVMNodeDescriptor)layerListing.get(name);
            AVMNodeDescriptor bottomNode = (AVMNodeDescriptor)underListing.get(name);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Trying to flatten out: " + name));
            }
            if (bottomNode == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Can't flatten (no bottomNode): " + name));
                }
                flattened = false;
                continue;
            }
            if (topNode.getId() == bottomNode.getId()) {
                this.fAVMRepository.flatten(layer.getPath(), name);
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Identity flattened: " + name));
                continue;
            }
            if (bottomNode.isLayeredDirectory() && (lookup = this.fAVMService.lookup(bottomNode.getIndirectionVersion(), bottomNode.getIndirection())) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Can't flatten (no bottomNode indirection): " + name));
                }
                flattened = false;
                continue;
            }
            if (this.flatten(topNode, bottomNode)) {
                this.fAVMRepository.flatten(layer.getPath(), name);
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Recursively flattened: " + name));
                continue;
            }
            flattened = false;
        }
        return flattened;
    }

    @Override
    public void resetLayer(String layerPath) {
        long start = System.currentTimeMillis();
        AVMNodeDescriptor desc = this.fAVMService.lookup(-1, layerPath);
        if (desc == null) {
            throw new AVMNotFoundException("Not Found: " + layerPath);
        }
        SortedMap<String, AVMNodeDescriptor> layerListing = this.fAVMService.getDirectoryListingDirect(-1, layerPath, true);
        for (String name : layerListing.keySet()) {
            this.fAVMRepository.flatten(layerPath, name);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Raw resetLayer: " + layerPath + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
    }

    private void mkdirs(String path, String sourcePath) {
        if (this.fAVMService.lookup(-1, path) != null) {
            return;
        }
        String[] pathParts = AVMNodeConverter.SplitBase(path);
        if (pathParts[0] == null) {
            throw new AVMSyncException("No corresponding destination path: " + path);
        }
        this.mkdirs(pathParts[0], AVMNodeConverter.SplitBase(sourcePath)[0]);
        this.fAVMService.createDirectory(pathParts[0], pathParts[1]);
        this.fAVMService.setMetaDataFrom(path, this.fAVMService.lookup(-1, sourcePath));
    }
}

