/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.actions;

import java.util.List;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncException;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.NameMatcher;
import org.alfresco.util.Pair;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAVMSubmitAction
extends ActionExecuterAbstractBase {
    private static Log fgLogger = LogFactory.getLog(SimpleAVMSubmitAction.class);
    public static String NAME = "simple-avm-submit";
    private AVMService fAVMService;
    private AVMSyncService fAVMSyncService;
    private NameMatcher fExcluder;

    public void setAvmService(AVMService avmService) {
        this.fAVMService = avmService;
    }

    public void setAvmSyncService(AVMSyncService avmSyncService) {
        this.fAVMSyncService = avmSyncService;
    }

    public void setExcluder(NameMatcher excluder) {
        this.fExcluder = excluder;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(actionedUponNodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        String path = (String)avmVersionPath.getSecond();
        String[] storePath = path.split(":");
        if (storePath.length != 2) {
            throw new AVMSyncException("Malformed source path " + path);
        }
        PropertyValue wsProp = this.fAVMService.getStoreProperty(storePath[0], SandboxConstants.PROP_WEBSITE_NAME);
        if (wsProp == null) {
            fgLogger.warn((Object)(SandboxConstants.PROP_WEBSITE_NAME.toString() + " property not found."));
            return;
        }
        String websiteName = wsProp.getStringValue();
        String avmDest = websiteName + ":" + storePath[1];
        List<AVMDifference> diffs = this.fAVMSyncService.compare(version, path, -1, avmDest, this.fExcluder);
        this.fAVMSyncService.update(diffs, this.fExcluder, false, false, true, true, "Submit of item: " + AVMNodeConverter.SplitBase(path)[1], null);
        this.fAVMSyncService.flatten(storePath[0] + ":/" + "www", websiteName + ":/" + "www");
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }
}

