/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.blog;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.BlogIntegrationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.blog.BlogDetails;
import org.alfresco.repo.blog.BlogIntegrationImplementation;
import org.alfresco.repo.blog.BlogIntegrationRuntimeException;
import org.alfresco.repo.blog.BlogIntegrationService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogIntegrationServiceImpl
implements BlogIntegrationService,
BlogIntegrationModel {
    private NodeService nodeService;
    private ContentService contentService;
    private Map<String, BlogIntegrationImplementation> implementations = new HashMap<String, BlogIntegrationImplementation>(5);
    public static List<String> supportedMimetypes = new ArrayList<String>(5);

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public void register(BlogIntegrationImplementation implementation) {
        if (this.implementations.containsKey(implementation.getName())) {
            throw new BlogIntegrationRuntimeException("A blog implementation with name '" + implementation.getName() + "' has already been registered.");
        }
        this.implementations.put(implementation.getName(), implementation);
    }

    @Override
    public BlogIntegrationImplementation getBlogIntegrationImplementation(String implementationName) {
        return this.implementations.get(implementationName);
    }

    @Override
    public List<BlogIntegrationImplementation> getBlogIntegrationImplementations() {
        return new ArrayList<BlogIntegrationImplementation>(this.implementations.values());
    }

    @Override
    public List<BlogDetails> getBlogDetails(NodeRef nodeRef) {
        ArrayList<BlogDetails> result = new ArrayList<BlogDetails>(5);
        if (this.nodeService.hasAspect(nodeRef, ASPECT_BLOG_DETAILS)) {
            result.add(BlogDetails.createBlogDetails(this.nodeService, nodeRef));
        }
        this.getBlogDetailsImpl(nodeRef, result);
        return result;
    }

    private void getBlogDetailsImpl(NodeRef nodeRef, List<BlogDetails> blogDetails) {
        NodeRef parent;
        ChildAssociationRef parentAssoc = this.nodeService.getPrimaryParent(nodeRef);
        if (parentAssoc != null && (parent = parentAssoc.getParentRef()) != null) {
            if (this.nodeService.hasAspect(parent, ASPECT_BLOG_DETAILS)) {
                blogDetails.add(BlogDetails.createBlogDetails(this.nodeService, parent));
            }
            this.getBlogDetailsImpl(parent, blogDetails);
        }
    }

    @Override
    public void newPost(BlogDetails blogDetails, NodeRef nodeRef, QName contentProperty, boolean publish) {
        BlogIntegrationImplementation implementation = this.getImplementation(blogDetails.getImplementationName());
        if (this.nodeService.hasAspect(nodeRef, ASPECT_BLOG_POST)) {
            throw new BlogIntegrationRuntimeException("Can not create new blog post since this conten has already been posted to a blog.");
        }
        ContentReader contentReader = this.contentService.getReader(nodeRef, contentProperty);
        if (contentReader == null) {
            throw new BlogIntegrationRuntimeException("No content found for new blog entry.");
        }
        String body = null;
        if (!supportedMimetypes.contains(contentReader.getMimetype())) {
            throw new BlogIntegrationRuntimeException("The content mimetype '" + contentReader.getMimetype() + "' is not supported.");
        }
        body = contentReader.getContentString();
        String title = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TITLE));
        if (title == null || title.length() == 0) {
            title = body.length() > 23 ? body.substring(0, 23) + " ..." : body;
        }
        String postId = implementation.newPost(blogDetails, title, body, true);
        NodeRef blogDetailsNodeRef = blogDetails.getNodeRef();
        if (blogDetailsNodeRef != null) {
            Map<String, Object> details = implementation.getPost(blogDetails, postId);
            String link = (String)details.get("link");
            HashMap<QName, Object> props = new HashMap<QName, Object>(5);
            props.put(PROP_POST_ID, postId);
            if (link != null) {
                props.put(PROP_LINK, link);
            }
            Date now = new Date();
            props.put(PROP_POSTED, now);
            props.put(PROP_LAST_UPDATE, now);
            props.put(PROP_PUBLISHED, publish);
            this.nodeService.addAspect(nodeRef, ASPECT_BLOG_POST, props);
            this.nodeService.createAssociation(nodeRef, blogDetailsNodeRef, ASSOC_BLOG_DETAILS);
        }
    }

    private BlogIntegrationImplementation getImplementation(String implementationName) {
        if (!this.implementations.containsKey(implementationName)) {
            throw new BlogIntegrationRuntimeException("There is no blog implementation present for '" + implementationName + "'");
        }
        return this.implementations.get(implementationName);
    }

    @Override
    public void updatePost(NodeRef nodeRef, QName contentProperty, boolean publish) {
        List assocs;
        BlogDetails blogDetails = null;
        String postId = null;
        if (this.nodeService.hasAspect(nodeRef, ASPECT_BLOG_POST)) {
            assocs = this.nodeService.getTargetAssocs(nodeRef, (QNamePattern)ASSOC_BLOG_DETAILS);
            if (assocs.size() == 0) {
                throw new BlogIntegrationRuntimeException("Can not resolve blog details for update because blogDetails association is not populated.");
            }
        } else {
            throw new BlogIntegrationRuntimeException("Can not update blog post as this node has not been previously posted to a blog.");
        }
        blogDetails = BlogDetails.createBlogDetails(this.nodeService, ((AssociationRef)assocs.get(0)).getTargetRef());
        postId = (String)((Object)this.nodeService.getProperty(nodeRef, PROP_POST_ID));
        BlogIntegrationImplementation implementation = this.getImplementation(blogDetails.getImplementationName());
        String title = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TITLE));
        if (title == null || title.length() == 0) {
            throw new BlogIntegrationRuntimeException("No title available for update blog post.  Set the title property and re-try.");
        }
        ContentReader contentReader = this.contentService.getReader(nodeRef, contentProperty);
        if (contentReader == null) {
            throw new BlogIntegrationRuntimeException("No content found for update blog entry.");
        }
        String body = null;
        if (!supportedMimetypes.contains(contentReader.getMimetype())) {
            throw new BlogIntegrationRuntimeException("The content mimetype '" + contentReader.getMimetype() + "' is not supported.");
        }
        body = contentReader.getContentString();
        boolean result = implementation.updatePost(blogDetails, postId, title, body, publish);
        if (!result) {
            throw new BlogIntegrationRuntimeException("The update of the post unexpectedly failed.  Check your blog for more information.");
        }
        Map<String, Object> details = implementation.getPost(blogDetails, postId);
        String link = (String)details.get("link");
        Map props = this.nodeService.getProperties(nodeRef);
        Date now = new Date();
        props.put(PROP_LAST_UPDATE, now);
        props.put(PROP_PUBLISHED, publish);
        props.put(PROP_LINK, link);
        this.nodeService.setProperties(nodeRef, props);
    }

    @Override
    public void deletePost(NodeRef nodeRef) {
        List assocs;
        BlogDetails blogDetails = null;
        String postId = null;
        if (this.nodeService.hasAspect(nodeRef, ASPECT_BLOG_POST)) {
            assocs = this.nodeService.getTargetAssocs(nodeRef, (QNamePattern)ASSOC_BLOG_DETAILS);
            if (assocs.size() == 0) {
                throw new BlogIntegrationRuntimeException("Can not resolve blog details for delete because blogDetails association is not populated.");
            }
        } else {
            throw new BlogIntegrationRuntimeException("Can not delete blog post as this node has not been previously posted to a blog.");
        }
        blogDetails = BlogDetails.createBlogDetails(this.nodeService, ((AssociationRef)assocs.get(0)).getTargetRef());
        postId = (String)((Object)this.nodeService.getProperty(nodeRef, PROP_POST_ID));
        BlogIntegrationImplementation implementation = this.getImplementation(blogDetails.getImplementationName());
        boolean result = implementation.deletePost(blogDetails, postId);
        if (!result) {
            throw new BlogIntegrationRuntimeException("Deleting the post unexpectedly failed.  Check your blog for more information.");
        }
        this.nodeService.removeAspect(nodeRef, ASPECT_BLOG_POST);
    }

    static {
        supportedMimetypes.add("text/plain");
        supportedMimetypes.add("text/html");
    }
}

