/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.cleanup;

import java.util.ArrayList;
import java.util.HashMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.cleanup.EagerContentStoreCleaner;
import org.alfresco.repo.domain.avm.AVMNodeDAO;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentStoreCleaner {
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"ContentStoreCleaner");
    private static final long LOCK_TTL = 30000L;
    private static ThreadLocal<Pair<Long, String>> lockThreadLocal = new ThreadLocal();
    private static Log logger = LogFactory.getLog(ContentStoreCleaner.class);
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener("ContentStoreCleaner");
    private EagerContentStoreCleaner eagerContentStoreCleaner;
    private JobLockService jobLockService;
    private ContentDataDAO contentDataDAO;
    private DictionaryService dictionaryService;
    private ContentService contentService;
    private AVMNodeDAO avmNodeDAO;
    private TransactionService transactionService;
    private int protectDays = 7;

    public void setEagerContentStoreCleaner(EagerContentStoreCleaner eagerContentStoreCleaner) {
        this.eagerContentStoreCleaner = eagerContentStoreCleaner;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setContentDataDAO(ContentDataDAO contentDataDAO) {
        this.contentDataDAO = contentDataDAO;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setAvmNodeDAO(AVMNodeDAO avmNodeDAO) {
        this.avmNodeDAO = avmNodeDAO;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setProtectDays(int protectDays) {
        this.protectDays = protectDays;
    }

    public void init() {
        this.checkProperties();
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        PropertyCheck.mandatory((Object)this, (String)"contentDataDAO", (Object)this.contentDataDAO);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.contentService);
        PropertyCheck.mandatory((Object)this, (String)"avmNodeDAO", (Object)this.avmNodeDAO);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"eagerContentStoreCleaner", (Object)this.eagerContentStoreCleaner);
        if (this.protectDays < 0) {
            throw new AlfrescoRuntimeException("Property 'protectDays' must be 0 or greater (0 is not recommended)");
        }
        if (this.protectDays == 0) {
            logger.warn((Object)"Property 'protectDays' is set to 0.  Please ensure that your backup strategy is appropriate for this setting.");
        }
    }

    private void refreshLock() {
        Pair lockPair = lockThreadLocal.get();
        if (lockPair == null) {
            String lockToken = this.jobLockService.getLock(LOCK_QNAME, 30000L);
            Long lastLock = new Long(System.currentTimeMillis());
            lockPair = new Pair((Object)lastLock, (Object)lockToken);
            lockThreadLocal.set((Pair<Long, String>)lockPair);
        } else {
            long now = System.currentTimeMillis();
            long lastLock = (Long)lockPair.getFirst();
            String lockToken = (String)lockPair.getSecond();
            if (now - lastLock > 15000L) {
                this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 30000L);
                lastLock = System.currentTimeMillis();
                lockPair = new Pair((Object)lastLock, (Object)lockToken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock() {
        Pair<Long, String> lockPair = lockThreadLocal.get();
        if (lockPair != null) {
            try {
                this.jobLockService.releaseLock((String)lockPair.getSecond(), LOCK_QNAME);
                Object var3_2 = null;
                lockThreadLocal.set(null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                lockThreadLocal.set(null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.checkProperties();
        if (this.transactionService.isReadOnly()) {
            logger.debug((Object)"Content store cleanup bypassed; the system is read-only.");
            return;
        }
        try {
            block6: {
                try {
                    logger.debug((Object)"Content store cleanup started.");
                    this.refreshLock();
                    this.executeInternal();
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug((Object)"   Content store cleanup completed.");
                }
                catch (VmShutdownListener.VmShutdownException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"   Content store cleanup aborted.");
                    }
                    Object var3_2 = null;
                    this.releaseLock();
                }
            }
            Object var3_1 = null;
            this.releaseLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseLock();
            throw throwable;
        }
    }

    private void executeInternal() {
        RetryingTransactionHelper.RetryingTransactionCallback<Integer> getAndDeleteWork = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            @Override
            public Integer execute() throws Exception {
                return ContentStoreCleaner.this.cleanBatch(1000);
            }
        };
        while (true) {
            this.refreshLock();
            Integer deleted = this.transactionService.getRetryingTransactionHelper().doInTransaction(getAndDeleteWork);
            if (vmShutdownListener.isVmShuttingDown()) {
                throw new VmShutdownListener.VmShutdownException();
            }
            if (deleted == 0) break;
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("   Removed " + deleted + " orphaned content URLs."));
        }
    }

    private int cleanBatch(int batchSize) {
        final HashMap urlsById = new HashMap(batchSize * 2);
        ContentDataDAO.ContentUrlHandler contentUrlHandler = new ContentDataDAO.ContentUrlHandler(){

            public void handle(Long id, String contentUrl, Long orphanTime) {
                urlsById.put(id, contentUrl);
            }
        };
        long maxOrphanTime = System.currentTimeMillis() - (long)(this.protectDays * 24 * 3600 * 1000);
        this.contentDataDAO.getContentUrlsOrphaned(contentUrlHandler, maxOrphanTime, batchSize);
        if (urlsById.size() == 0) {
            return 0;
        }
        ArrayList<Long> idsToDelete = new ArrayList<Long>(urlsById.keySet());
        this.contentDataDAO.deleteContentUrls(idsToDelete);
        for (String contentUrlToDelete : urlsById.values()) {
            this.eagerContentStoreCleaner.registerOrphanedContentUrl(contentUrlToDelete, true);
        }
        return urlsById.size();
    }
}

