/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Collections;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.ExplictTransformationDetails;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;

public class ContentTransformerRegistryTest
extends AbstractContentTransformerTest {
    private static final String A = "text/plain";
    private static final String B = "text/xml";
    private static final String C = "application/msword";
    private static final String D = "text/html";
    private static final TransformationOptions OPTIONS = new TransformationOptions();
    private ContentTransformerRegistry registry;
    private ContentTransformerRegistry dummyRegistry;
    private ContentReader reader;
    private ContentWriter writer;

    public void setUp() throws Exception {
        super.setUp();
        this.registry = (ContentTransformerRegistry)this.ctx.getBean("contentTransformerRegistry");
        this.reader = new FileContentReader(TempFileProvider.createTempFile((String)this.getName(), (String)".txt"));
        this.reader.setMimetype(A);
        this.writer = new FileContentWriter(TempFileProvider.createTempFile((String)this.getName(), (String)".txt"));
        this.writer.setMimetype(D);
        byte[] bytes = new byte[256];
        for (int i = 0; i < 256; ++i) {
            bytes[i] = (byte)i;
        }
        this.dummyRegistry = new ContentTransformerRegistry();
        new DummyTransformer(this.mimetypeService, this.dummyRegistry, A, B, 10L);
        new DummyTransformer(this.mimetypeService, this.dummyRegistry, A, B, 10L);
        new DummyTransformer(this.mimetypeService, this.dummyRegistry, A, C, 10L);
        new DummyTransformer(this.mimetypeService, this.dummyRegistry, A, C, 10L);
        new DummyTransformer(this.mimetypeService, this.dummyRegistry, B, C, 10L);
        new DummyTransformer(this.mimetypeService, this.dummyRegistry, A, D, 20L);
        new DummyTransformer(this.mimetypeService, this.dummyRegistry, A, D, 20L);
        new DummyTransformer(this.mimetypeService, this.dummyRegistry, A, D, 10L);
        new DummyTransformer(this.mimetypeService, this.dummyRegistry, A, D, 20L);
        new DummyTransformer(this.mimetypeService, this.dummyRegistry, A, D, 20L);
    }

    public void testSetUp() throws Exception {
        super.testSetUp();
        ContentTransformerRegistryTest.assertNotNull((Object)this.registry);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.registry.getTransformer(sourceMimetype, targetMimetype, options);
    }

    public void testNullRetrieval() throws Exception {
        ContentTransformer transformer = null;
        transformer = this.dummyRegistry.getTransformer(C, B, OPTIONS);
        ContentTransformerRegistryTest.assertNull((String)"No transformer expected", (Object)transformer);
        transformer = this.dummyRegistry.getTransformer(C, A, OPTIONS);
        ContentTransformerRegistryTest.assertNull((String)"No transformer expected", (Object)transformer);
        transformer = this.dummyRegistry.getTransformer(B, A, OPTIONS);
        ContentTransformerRegistryTest.assertNull((String)"No transformer expected", (Object)transformer);
    }

    public void testSimpleRetrieval() throws Exception {
        ContentTransformer transformer = null;
        transformer = this.dummyRegistry.getTransformer(B, C, OPTIONS);
        ContentTransformerRegistryTest.assertNotNull((String)"No transformer found", (Object)transformer);
        ContentTransformerRegistryTest.assertTrue((String)"Incorrect reliability", (boolean)transformer.isTransformable(B, C, OPTIONS));
        ContentTransformerRegistryTest.assertFalse((String)"Incorrect reliability", (boolean)transformer.isTransformable(C, B, OPTIONS));
    }

    public void testPerformanceRetrieval() throws Exception {
        ContentTransformer transformer1 = this.dummyRegistry.getTransformer(A, D, OPTIONS);
        ContentTransformerRegistryTest.assertTrue((String)"Incorrect reliability", (boolean)transformer1.isTransformable(A, D, OPTIONS));
        ContentTransformerRegistryTest.assertFalse((String)"Incorrect reliability", (boolean)transformer1.isTransformable(D, A, OPTIONS));
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect transformation time", (long)10L, (long)transformer1.getTransformationTime());
    }

    public void testScoredRetrieval() throws Exception {
        ContentTransformer transformer = null;
        transformer = this.dummyRegistry.getTransformer(A, B, OPTIONS);
        ContentTransformerRegistryTest.assertNotNull((String)"No transformer found", (Object)transformer);
        ContentTransformerRegistryTest.assertTrue((String)"Incorrect reliability", (boolean)transformer.isTransformable(A, B, OPTIONS));
        ContentTransformerRegistryTest.assertFalse((String)"Incorrect reliability", (boolean)transformer.isTransformable(B, A, OPTIONS));
        transformer = this.dummyRegistry.getTransformer(A, C, OPTIONS);
        ContentTransformerRegistryTest.assertNotNull((String)"No transformer found", (Object)transformer);
        ContentTransformerRegistryTest.assertTrue((String)"Incorrect reliability", (boolean)transformer.isTransformable(A, C, OPTIONS));
        ContentTransformerRegistryTest.assertFalse((String)"Incorrect reliability", (boolean)transformer.isTransformable(C, A, OPTIONS));
    }

    public void testExplicitTransformation() {
        DummyTransformer dummyTransformer = new DummyTransformer(this.mimetypeService, this.dummyRegistry, "application/x-shockwave-flash", "application/vnd.ms-excel", 12345L);
        ExplictTransformationDetails key = new ExplictTransformationDetails("application/x-shockwave-flash", "application/vnd.ms-excel");
        dummyTransformer.setExplicitTransformations(Collections.singletonList(key));
        dummyTransformer.register();
        ContentTransformer checkTransformer = this.dummyRegistry.getTransformer("application/x-shockwave-flash", "application/vnd.ms-excel", OPTIONS);
        ContentTransformerRegistryTest.assertNotNull((String)"No explicit transformer found", (Object)checkTransformer);
        ContentTransformerRegistryTest.assertTrue((String)"Expected explicit transformer", (dummyTransformer == checkTransformer ? 1 : 0) != 0);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return null;
    }

    private static class DummyTransformer
    extends AbstractContentTransformer2 {
        private String sourceMimetype;
        private String targetMimetype;
        private long transformationTime;

        public DummyTransformer(MimetypeService mimetypeService, ContentTransformerRegistry registry, String sourceMimetype, String targetMimetype, long transformationTime) {
            super.setMimetypeService(mimetypeService);
            super.setRegistry(registry);
            this.sourceMimetype = sourceMimetype;
            this.targetMimetype = targetMimetype;
            this.transformationTime = transformationTime;
            this.register();
        }

        public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
            return this.sourceMimetype.equals(sourceMimetype) && this.targetMimetype.equals(targetMimetype);
        }

        public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
            super.recordTime(this.transformationTime);
        }

        public synchronized long getTransformationTime() {
            return this.transformationTime;
        }
    }
}

