/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.model.WikiModel;
import info.bliki.wiki.tags.ATag;
import java.util.List;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.ContentToken;

public class MediaWikiContentTransformer
extends AbstractContentTransformer2 {
    private FileFolderService fileFolderService;
    private NodeService nodeService;

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return "text/mediawiki".equals(sourceMimetype) && "text/html".equals(targetMimetype);
    }

    public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        String imageURL = "{$image}";
        String pageURL = "${title}";
        if (options.getTargetNodeRef() != null) {
            NodeRef parentNodeRef = this.nodeService.getPrimaryParent(options.getTargetNodeRef()).getParentRef();
            StringBuffer folderPath = new StringBuffer(256);
            List<FileInfo> fileInfos = this.fileFolderService.getNamePath(null, parentNodeRef);
            for (FileInfo fileInfo : fileInfos) {
                folderPath.append(fileInfo.getName()).append("/");
            }
            pageURL = "/alfresco/d/d?path=" + folderPath + "${title}.html";
            imageURL = "/alfresco/d/d?path=" + folderPath + "Images/${image}";
        }
        AlfrescoWikiModel wikiModel = new AlfrescoWikiModel(imageURL, pageURL);
        writer.putContent(wikiModel.render(reader.getContentString()));
    }

    private class AlfrescoWikiModel
    extends WikiModel {
        public AlfrescoWikiModel(String imageBaseURL, String linkBaseURL) {
            super(imageBaseURL, linkBaseURL);
        }

        public void appendInternalLink(String link, String hashSection, String linkText) {
            link = link.replaceAll(":", " - ");
            String encodedtopic = Encoder.encodeTitleUrl((String)link);
            encodedtopic = encodedtopic.replaceAll("_", " ");
            String hrefLink = this.fExternalWikiBaseURL.replace("${title}", encodedtopic);
            ATag aTagNode = new ATag();
            this.append((BaseToken)aTagNode);
            aTagNode.addAttribute("id", "w");
            String href = hrefLink;
            if (hashSection != null) {
                href = href + '#' + hashSection;
            }
            aTagNode.addAttribute("href", href);
            aTagNode.addObjectAttribute("wikilink", (Object)hrefLink);
            ContentToken text = new ContentToken(linkText);
            aTagNode.addChild((Object)text);
        }
    }
}

