/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import org.alfresco.repo.content.transform.AbstractContentTransformerTest;

public abstract class TikaPoweredContentTransformerTest
extends AbstractContentTransformerTest {
    protected boolean isQuickPhraseExpected(String targetMimetype) {
        return targetMimetype.equals("text/plain") || targetMimetype.equals("text/html") || targetMimetype.equals("text/xml");
    }

    protected boolean isQuickWordsExpected(String targetMimetype) {
        return targetMimetype.startsWith("text/") || targetMimetype.equals("text/html") || targetMimetype.equals("text/xml");
    }

    protected void additionalContentCheck(String sourceMimetype, String targetMimetype, String contents) {
        if (targetMimetype.equals("text/xml")) {
            TikaPoweredContentTransformerTest.assertTrue((String)"XML header not found", (boolean)contents.contains("<?xml version="));
            TikaPoweredContentTransformerTest.assertTrue((String)"XHTML header not found", (boolean)contents.contains("<html"));
            TikaPoweredContentTransformerTest.assertTrue((String)"XHTML footer not found", (boolean)contents.contains("</html>"));
        } else if (targetMimetype.equals("text/html")) {
            TikaPoweredContentTransformerTest.assertFalse((String)"XML header found but shouldn't be there for HTML", (boolean)contents.contains("<?xml version="));
            TikaPoweredContentTransformerTest.assertTrue((String)"HTML header not found", (boolean)contents.contains("<html"));
            TikaPoweredContentTransformerTest.assertTrue((String)"HTML footer not found", (boolean)contents.contains("</html>"));
        } else if (targetMimetype.equals("text/plain")) {
            TikaPoweredContentTransformerTest.assertFalse((String)"XML header found but shouldn't be there for Plain Text", (boolean)contents.contains("<?xml version="));
            TikaPoweredContentTransformerTest.assertFalse((String)"XHTML header found but shouldn't be there for Plain Text", (boolean)contents.contains("<html"));
            TikaPoweredContentTransformerTest.assertFalse((String)"XHTML footer found but shouldn't be there for Plain Text", (boolean)contents.contains("</html>"));
        }
    }
}

