/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.encoding;

import junit.framework.TestCase;
import org.alfresco.repo.domain.encoding.EncodingDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private EncodingDAO encodingDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.encodingDAO = (EncodingDAO)this.ctx.getBean("encodingDAO");
    }

    private Pair<Long, String> get(final String encoding, final boolean autoCreate, boolean expectSuccess) {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            @Override
            public Pair<Long, String> execute() throws Throwable {
                Pair<Long, String> mimetypePair = null;
                mimetypePair = autoCreate ? EncodingDAOTest.this.encodingDAO.getOrCreateEncoding(encoding) : EncodingDAOTest.this.encodingDAO.getEncoding(encoding);
                return mimetypePair;
            }
        };
        try {
            return this.txnHelper.doInTransaction(callback, !autoCreate, false);
        }
        catch (Throwable e) {
            if (expectSuccess) {
                throw new RuntimeException("Expected to get encoding '" + encoding + "'.", e);
            }
            return null;
        }
    }

    public void testCreateWithCommit() throws Exception {
        String encoding = GUID.generate();
        Pair<Long, String> encodingPair = this.get(encoding, true, true);
        Pair<Long, String> encodingPairCheck = this.get((String)encodingPair.getSecond(), false, true);
        EncodingDAOTest.assertEquals((String)"Encoding ID changed", (Object)encodingPair.getFirst(), (Object)encodingPairCheck.getFirst());
    }

    public void testCreateWithRollback() throws Exception {
        final String encoding = GUID.generate();
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            @Override
            public Pair<Long, String> execute() throws Throwable {
                EncodingDAOTest.this.get(encoding, true, true);
                throw new RuntimeException("Forced");
            }
        };
        try {
            this.txnHelper.doInTransaction(callback);
            EncodingDAOTest.fail((String)"Transaction didn't roll back");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.get(encoding, false, false);
    }

    public void testCaseInsensitivity() throws Exception {
        String encoding = "AAA-" + GUID.generate();
        Pair<Long, String> lowercasePair = this.get(encoding.toLowerCase(), true, true);
        Pair<Long, String> uppercasePair = this.get(encoding.toUpperCase(), true, true);
        EncodingDAOTest.assertNotNull(uppercasePair);
        EncodingDAOTest.assertEquals((String)"Upper and lowercase encoding instance IDs were not the same", (Object)lowercasePair.getFirst(), (Object)uppercasePair.getFirst());
    }
}

