/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.util.List;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeAssocEntity {
    private Long id;
    private Long version;
    private NodeEntity sourceNode;
    private NodeEntity targetNode;
    private Long typeQNameId;
    private List<Long> typeQNameIds;

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("NodeAssocEntity").append("[ ID=").append(this.id).append(", sourceNode=").append(this.sourceNode).append(", targetNode=").append(this.targetNode).append(", typeQNameId=").append(this.typeQNameId).append(", typeQNameIds=").append(this.typeQNameIds).append("]");
        return sb.toString();
    }

    public AssociationRef getAssociationRef(QNameDAO qnameDAO) {
        QName assocTypeQName = (QName)qnameDAO.getQName(this.typeQNameId).getSecond();
        AssociationRef assocRef = new AssociationRef(this.id, this.sourceNode.getNodeRef(), assocTypeQName, this.targetNode.getNodeRef());
        return assocRef;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public NodeEntity getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(NodeEntity sourceNode) {
        this.sourceNode = sourceNode;
    }

    public NodeEntity getTargetNode() {
        return this.targetNode;
    }

    public void setTargetNode(NodeEntity targetNode) {
        this.targetNode = targetNode;
    }

    public Long getTypeQNameId() {
        return this.typeQNameId;
    }

    public void setTypeQNameId(Long typeQNameId) {
        this.typeQNameId = typeQNameId;
    }

    public List<Long> getTypeQNameIds() {
        return this.typeQNameIds;
    }

    public void setTypeQNameIds(List<Long> typeQNameIds) {
        this.typeQNameIds = typeQNameIds;
    }
}

