/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FieldGroup;
import org.alfresco.repo.forms.processor.node.AssociationFieldProcessor;
import org.alfresco.repo.forms.processor.node.PropertyFieldProcessor;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.NamespaceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldUtils {
    public static Field makePropertyField(PropertyDefinition propDef, Object value, FieldGroup group, NamespaceService namespaceService) {
        PropertyFieldProcessor processor = new PropertyFieldProcessor(namespaceService, null);
        return processor.makeField(propDef, value, group);
    }

    public static List<Field> makePropertyFields(Collection<PropertyDefinition> propDefs, FieldGroup group, NamespaceService namespaceService) {
        return FieldUtils.makePropertyFields(propDefs, null, group, namespaceService);
    }

    public static List<Field> makePropertyFields(Map<PropertyDefinition, Object> propDefAndValue, FieldGroup group, NamespaceService namespaceService) {
        return FieldUtils.makePropertyFields(propDefAndValue.keySet(), propDefAndValue, group, namespaceService);
    }

    public static List<Field> makePropertyFields(Collection<PropertyDefinition> propDefs, Map<PropertyDefinition, Object> values, FieldGroup group, NamespaceService namespaceService) {
        PropertyFieldProcessor processor = new PropertyFieldProcessor(namespaceService, null);
        ArrayList<Field> fields = new ArrayList<Field>(propDefs.size());
        for (PropertyDefinition propDef : propDefs) {
            Object value = values == null ? null : values.get(propDef);
            Field field = processor.makeField(propDef, value, group);
            fields.add(field);
        }
        return fields;
    }

    public static Field makeAssociationField(AssociationDefinition assocDef, Object value, FieldGroup group, NamespaceService namespaceService) {
        AssociationFieldProcessor processor = new AssociationFieldProcessor(namespaceService, null);
        return processor.makeField(assocDef, value, group);
    }

    public static List<Field> makeAssociationFields(Collection<AssociationDefinition> assocDefs, FieldGroup group, NamespaceService namespaceService) {
        return FieldUtils.makeAssociationFields(assocDefs, null, group, namespaceService);
    }

    public static List<Field> makeAssociationFields(Map<AssociationDefinition, Object> assocDefAndValue, FieldGroup group, NamespaceService namespaceService) {
        return FieldUtils.makeAssociationFields(assocDefAndValue.keySet(), assocDefAndValue, group, namespaceService);
    }

    public static List<Field> makeAssociationFields(Collection<AssociationDefinition> assocDefs, Map<AssociationDefinition, Object> values, FieldGroup group, NamespaceService namespaceService) {
        AssociationFieldProcessor processor = new AssociationFieldProcessor(namespaceService, null);
        ArrayList<Field> fields = new ArrayList<Field>(assocDefs.size());
        for (AssociationDefinition propDef : assocDefs) {
            Object value = values == null ? null : values.get(propDef);
            Field field = processor.makeField(propDef, value, group);
            fields.add(field);
        }
        return fields;
    }
}

