/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.io.Serializable;
import java.util.List;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.workflow.ContentModelFormPersister;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.workflow.TaskUpdater;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskFormPersister
extends ContentModelFormPersister<WorkflowTask> {
    private final TaskUpdater updater;
    private String transitionId = null;

    public TaskFormPersister(ContentModelItemData<WorkflowTask> itemData, NamespaceService namespaceService, DictionaryService dictionaryService, WorkflowService workflowService, NodeService nodeService, AuthenticationService authenticationService, Log logger) {
        super(itemData, namespaceService, dictionaryService, logger);
        WorkflowTask item = itemData.getItem();
        if (!workflowService.isTaskEditable(item, authenticationService.getCurrentUserName())) {
            throw new AccessDeniedException("Failed to update task with id '" + item.getId() + "'.");
        }
        this.updater = new TaskUpdater(item.id, workflowService, nodeService);
    }

    @Override
    protected boolean addAssociation(QName qName, List<NodeRef> values) {
        this.updater.addAssociation(qName, values);
        return true;
    }

    @Override
    protected boolean removeAssociation(QName qName, List<NodeRef> values) {
        this.updater.removeAssociation(qName, values);
        return true;
    }

    @Override
    protected boolean updateProperty(QName qName, Serializable value) {
        this.updater.addProperty(qName, value);
        return true;
    }

    @Override
    protected boolean addTransientAssociation(String fieldName, List<NodeRef> values) {
        if ("packageItems".equals(fieldName)) {
            this.updater.addPackageItems(values);
            return true;
        }
        return false;
    }

    @Override
    protected boolean removeTransientAssociation(String fieldName, List<NodeRef> values) {
        if ("packageItems".equals(fieldName)) {
            this.updater.removePackageItems(values);
            return true;
        }
        return false;
    }

    @Override
    protected boolean updateTransientProperty(String fieldName, FormData.FieldData fieldData) {
        if ("transitions".equals(fieldName)) {
            Object value = fieldData.getValue();
            if (value == null) {
                value = "";
            }
            this.transitionId = value.toString();
            return true;
        }
        return false;
    }

    @Override
    public WorkflowTask persist() {
        if (this.transitionId == null) {
            return this.updater.update();
        }
        this.updater.update();
        if (this.transitionId.length() == 0) {
            return this.updater.transition();
        }
        return this.updater.transition(this.transitionId);
    }
}

