/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxDumpUtil {
    private static final String NAME_HEADER = "Attribute Name";
    private static final String VALUE_HEADER = "Attribute Value";
    private static final String NULL_VALUE = "<null>";
    private static final String UNREADABLE_VALUE = "<not readable>";

    public static void dumpConnection(MBeanServerConnection connection, PrintWriter out) throws IOException {
        Set<ObjectName> objectNames = connection.queryNames(null, null);
        TreeSet<ObjectName> newObjectNames = new TreeSet<ObjectName>(new Comparator<ObjectName>(){

            @Override
            public int compare(ObjectName o1, ObjectName o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        newObjectNames.addAll(objectNames);
        objectNames = newObjectNames;
        for (ObjectName objectName : objectNames) {
            try {
                JmxDumpUtil.printMBeanInfo(connection, objectName, out);
            }
            catch (JMException e) {}
        }
    }

    private static void printMBeanInfo(MBeanServerConnection connection, ObjectName objectName, PrintWriter out) throws IOException, JMException {
        TreeMap<String, Object> attributes = new TreeMap<String, Object>();
        MBeanInfo info = connection.getMBeanInfo(objectName);
        attributes.put("** Object Name", objectName.toString());
        attributes.put("** Object Type", info.getClassName());
        for (MBeanAttributeInfo element : info.getAttributes()) {
            Object value;
            if (element.isReadable()) {
                try {
                    value = connection.getAttribute(objectName, element.getName());
                }
                catch (Exception e) {
                    value = UNREADABLE_VALUE;
                }
            } else {
                value = UNREADABLE_VALUE;
            }
            attributes.put(element.getName(), value);
        }
        JmxDumpUtil.tabulate(NAME_HEADER, VALUE_HEADER, attributes, out, 0);
    }

    private static void printCompositeInfo(CompositeData composite, PrintWriter out, int nestLevel) throws IOException {
        TreeMap<String, Object> attributes = new TreeMap<String, Object>();
        for (String key : composite.getCompositeType().keySet()) {
            Object value;
            try {
                value = composite.get(key);
            }
            catch (Exception e) {
                value = UNREADABLE_VALUE;
            }
            attributes.put(key, value);
        }
        JmxDumpUtil.tabulate(NAME_HEADER, VALUE_HEADER, attributes, out, nestLevel);
    }

    private static void tabulate(String keyHeader, String valueHeader, Map<String, Object> rows, PrintWriter out, int nestLevel) throws IOException {
        int col;
        if (rows.isEmpty()) {
            return;
        }
        int maxKeyLength = keyHeader.length();
        int maxValLength = valueHeader.length();
        for (Map.Entry<String, Object> entry : rows.entrySet()) {
            maxKeyLength = Math.max(maxKeyLength, entry.getKey().length());
            maxValLength = Math.max(maxValLength, JmxDumpUtil.getValueLength(entry.getValue()));
        }
        JmxDumpUtil.outputRow(out, maxKeyLength, keyHeader, valueHeader, nestLevel);
        JmxDumpUtil.indent(out, nestLevel);
        for (col = 0; col < maxKeyLength; ++col) {
            out.print('-');
        }
        out.print(' ');
        for (col = 0; col < maxValLength; ++col) {
            out.print('-');
        }
        out.println();
        for (Map.Entry<String, Object> entry : rows.entrySet()) {
            JmxDumpUtil.outputRow(out, maxKeyLength, entry.getKey(), entry.getValue(), nestLevel);
        }
        out.println();
    }

    private static void indent(PrintWriter out, int nestLevel) {
        int size = nestLevel * 3;
        for (int i = 0; i < size; ++i) {
            out.print(' ');
        }
    }

    private static void outputRow(PrintWriter out, int maxKeyLength, String key, Object value, int nestLevel) throws IOException {
        JmxDumpUtil.indent(out, nestLevel);
        out.print(key);
        for (int i = key.length() - 1; i < maxKeyLength; ++i) {
            out.print(' ');
        }
        JmxDumpUtil.outputValue(out, value, nestLevel);
    }

    private static void outputValue(PrintWriter out, Object value, int nestLevel) throws IOException {
        if (value == null) {
            out.println(NULL_VALUE);
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                out.println("[]");
            } else {
                out.println();
                JmxDumpUtil.indent(out, nestLevel + 1);
                out.println('[');
                for (int i = 0; i < length; ++i) {
                    JmxDumpUtil.indent(out, nestLevel + 2);
                    JmxDumpUtil.outputValue(out, Array.get(value, i), nestLevel + 2);
                    if (i + 1 >= length) continue;
                    JmxDumpUtil.indent(out, nestLevel + 1);
                    out.println(',');
                }
                JmxDumpUtil.indent(out, nestLevel + 1);
                out.println(']');
            }
        } else if (value instanceof CompositeData) {
            out.println();
            JmxDumpUtil.indent(out, nestLevel + 1);
            out.println('[');
            JmxDumpUtil.printCompositeInfo((CompositeData)value, out, nestLevel + 2);
            JmxDumpUtil.indent(out, nestLevel + 1);
            out.println(']');
        } else {
            out.println(value.toString());
        }
    }

    private static int getValueLength(Object value) {
        if (value == null) {
            return NULL_VALUE.length();
        }
        if (value.getClass().isArray() || value instanceof CompositeData) {
            return 0;
        }
        return value.toString().length();
    }
}

