/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.alfresco.repo.model.ml.tools.AbstractMultilingualTestCases;

public class ContentFilterLanguagesMapTest
extends AbstractMultilingualTestCases {
    public void testGetFilterLanguages() throws Exception {
        List<String> lggs = this.contentFilterLanguagesService.getFilterLanguages();
        ContentFilterLanguagesMapTest.assertNotNull((String)"Language list is null", lggs);
        try {
            lggs.add("NEW LOCALE");
            ContentFilterLanguagesMapTest.assertTrue((String)"Add a value to the content filter language list is not permit, this list would be read only", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            lggs.remove(0);
            ContentFilterLanguagesMapTest.assertTrue((String)"Remove a value to the content filter language list is not permit, this list would be read only", (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetMissingLanguages() throws Exception {
        List<String> lggs = this.contentFilterLanguagesService.getFilterLanguages();
        List<String> missingLggsNull = this.contentFilterLanguagesService.getMissingLanguages(null);
        ContentFilterLanguagesMapTest.assertNotNull((String)"Language list returned with the null parameter is null", missingLggsNull);
        ContentFilterLanguagesMapTest.assertEquals((String)"Language list returned with the null parameter  corrupted", (int)missingLggsNull.size(), (int)lggs.size());
        List<String> missingLggsEmpty = this.contentFilterLanguagesService.getMissingLanguages(Collections.EMPTY_LIST);
        ContentFilterLanguagesMapTest.assertNotNull((String)"Language list returned with the empty parameter is null", missingLggsEmpty);
        ContentFilterLanguagesMapTest.assertEquals((String)"Language list returned with the empty parameter  corrupted", (int)missingLggsEmpty.size(), (int)lggs.size());
        ArrayList<String> param = new ArrayList<String>();
        param.add(0, lggs.get(0));
        param.add(1, lggs.get(1));
        List<String> missingLggsOk = this.contentFilterLanguagesService.getMissingLanguages(param);
        ContentFilterLanguagesMapTest.assertNotNull((String)"Language list returned with the correct parameter is null", missingLggsOk);
        ContentFilterLanguagesMapTest.assertEquals((String)"Language list size returned with the correct parameter is not correct", (int)missingLggsOk.size(), (int)(lggs.size() - 2));
        ContentFilterLanguagesMapTest.assertFalse((String)("Language found : " + (String)param.get(0)), (boolean)missingLggsOk.contains(param.get(0)));
        ContentFilterLanguagesMapTest.assertFalse((String)("Language found : " + (String)param.get(1)), (boolean)missingLggsOk.contains(param.get(1)));
        param.add(2, "WRONG LOCALE CODE");
        List<String> missingLggsWrong = this.contentFilterLanguagesService.getMissingLanguages(param);
        ContentFilterLanguagesMapTest.assertNotNull((String)"Language list returned with the wrong parameter is null", missingLggsWrong);
        ContentFilterLanguagesMapTest.assertEquals((String)"Language list size returned with the correct parameter is not correct", (int)missingLggsWrong.size(), (int)(lggs.size() - 2));
        ContentFilterLanguagesMapTest.assertFalse((String)("Language found : " + (String)param.get(0)), (boolean)missingLggsWrong.contains(param.get(0)));
        ContentFilterLanguagesMapTest.assertFalse((String)("Language found : " + (String)param.get(1)), (boolean)missingLggsWrong.contains(param.get(1)));
        ContentFilterLanguagesMapTest.assertFalse((String)("Language found : " + (String)param.get(2)), (boolean)missingLggsWrong.contains(param.get(2)));
    }

    public void testISOCodeConvertions() throws Exception {
        String[] newCode = new String[]{"he", "id", "yi"};
        String[] oldCode = new String[]{"iw", "in", "ji"};
        Locale loc0 = new Locale(newCode[0]);
        Locale loc1 = new Locale(newCode[1]);
        Locale loc2 = new Locale(newCode[2]);
        ContentFilterLanguagesMapTest.assertEquals((String)("java.util.Locale Convertion not correct for " + newCode[0]), (String)oldCode[0], (String)loc0.getLanguage());
        ContentFilterLanguagesMapTest.assertEquals((String)("java.util.Locale Convertion not correct for " + newCode[1]), (String)oldCode[1], (String)loc1.getLanguage());
        ContentFilterLanguagesMapTest.assertEquals((String)("java.util.Locale Convertion not correct for " + newCode[2]), (String)oldCode[2], (String)loc2.getLanguage());
        ContentFilterLanguagesMapTest.assertEquals((String)("Convertion of new ISO codes not correct for " + newCode[0]), (String)oldCode[0], (String)this.contentFilterLanguagesService.convertToOldISOCode(newCode[0]));
        ContentFilterLanguagesMapTest.assertEquals((String)("Convertion of new ISO codes not correct for " + newCode[1]), (String)oldCode[1], (String)this.contentFilterLanguagesService.convertToOldISOCode(newCode[1]));
        ContentFilterLanguagesMapTest.assertEquals((String)("Convertion of new ISO codes not correct for " + newCode[2]), (String)oldCode[2], (String)this.contentFilterLanguagesService.convertToOldISOCode(newCode[2]));
        ContentFilterLanguagesMapTest.assertEquals((String)("Convertion of old ISO codes not correct for " + oldCode[0]), (String)newCode[0], (String)this.contentFilterLanguagesService.convertToNewISOCode(oldCode[0]));
        ContentFilterLanguagesMapTest.assertEquals((String)("Convertion of old ISO codes not correct for " + oldCode[1]), (String)newCode[1], (String)this.contentFilterLanguagesService.convertToNewISOCode(oldCode[1]));
        ContentFilterLanguagesMapTest.assertEquals((String)("Convertion of old ISO codes not correct for " + oldCode[2]), (String)newCode[2], (String)this.contentFilterLanguagesService.convertToNewISOCode(oldCode[2]));
    }
}

