/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.cleanup;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.error.StackTraceUtil;
import org.alfresco.repo.node.cleanup.NodeCleanupWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeCleanupRegistry
implements NodeCleanupWorker {
    private static Log logger = LogFactory.getLog(NodeCleanupRegistry.class);
    private List<NodeCleanupWorker> cleanupWorkers = new ArrayList<NodeCleanupWorker>(5);

    public void register(NodeCleanupWorker cleanupWorker) {
        this.cleanupWorkers.add(cleanupWorker);
    }

    @Override
    public List<String> doClean() {
        ArrayList<String> results = new ArrayList<String>(100);
        for (NodeCleanupWorker cleanupWorker : this.cleanupWorkers) {
            try {
                results.addAll(cleanupWorker.doClean());
            }
            catch (Throwable e) {
                logger.error((Object)("NodeCleanupWork doesn't handle all exception conditions: " + cleanupWorker.getClass().getName()));
                StringBuilder sb = new StringBuilder(1024);
                StackTraceUtil.buildStackTrace((String)("Node cleanup failed:    Worker: " + cleanupWorker.getClass().getName() + "\n" + "   Error:  " + e.getMessage()), (StackTraceElement[])e.getStackTrace(), (StringBuilder)sb, (int)0);
                results.add(sb.toString());
            }
        }
        return results;
    }
}

